/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.SpatialProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatLongProviderAdapter
extends SpatialProviderAdapter
implements LatLongProvider {
    private static Map<Identifiable, LatLong> identifiableLatLongCache = new ConcurrentHashMap<Identifiable, LatLong>();
    private static Map<Identifiable, double[]> identifiableCenterCache = new ConcurrentHashMap<Identifiable, double[]>();
    private static Map<String, LatLongDataProvider> latLongDataProviders = null;

    public static void registerLatLongDataProvider(String string, LatLongDataProvider latLongDataProvider) {
        LatLongProviderAdapter.getLatLongDataProviders().put(string, latLongDataProvider);
    }

    public static synchronized Map<String, LatLongDataProvider> getLatLongDataProviders() {
        if (latLongDataProviders == null) {
            latLongDataProviders = new HashMap<String, LatLongDataProvider>();
            latLongDataProviders.put("inline", new InlineLatLongDataProvider());
            latLongDataProviders.put("platform", new PlatformLatLongDataProvider());
        }
        return latLongDataProviders;
    }

    @Override
    public boolean isAdapterForType(Object object) {
        boolean bl;
        boolean bl2 = bl = object == LatLongProvider.class;
        if (!bl) {
            bl = super.isAdapterForType(object);
        }
        return bl;
    }

    @Override
    public LatLong getLatLong() {
        Identifiable identifiable = (Identifiable)this.getTarget();
        LatLong latLong = identifiableLatLongCache.get(identifiable);
        if (latLong == null) {
            latLong = new LatLong();
            String string = identifiable.getDublinCore().getSpatial();
            if (string != null && string.startsWith("stemspatial:")) {
                try {
                    URI uRI = this.extractDataURI(string);
                    if (uRI != null && (latLong = this.getLatLong(uRI)) != null) {
                        identifiableLatLongCache.put(identifiable, latLong);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return latLong;
    }

    @Override
    public LatLong getLatLongNoWait() {
        Identifiable identifiable = (Identifiable)this.getTarget();
        LatLong latLong = identifiableLatLongCache.get(identifiable);
        if (latLong == null) {
            latLong = new LatLong();
            String string = identifiable.getDublinCore().getSpatial();
            if (string != null && string.startsWith("stemspatial:")) {
                try {
                    URI uRI = this.extractDataURI(string);
                    if (uRI != null && (latLong = this.getLatLongNoWait(uRI)) != null && latLong.size() > 0) {
                        identifiableLatLongCache.put(identifiable, latLong);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return latLong;
    }

    private URI extractDataURI(String string) {
        URI uRI = null;
        try {
            String string2 = string.substring("stemspatial:".length());
            uRI = URI.createURI((String)string2);
        }
        catch (Exception exception) {
            Activator.logError("Badly formated spatial URI \"" + string + "\"", null);
        }
        return uRI;
    }

    private LatLong getLatLong(URI uRI) {
        LatLong latLong = new LatLong();
        LatLongDataProvider latLongDataProvider = this.getLatLongDataProvider(uRI.scheme());
        if (latLongDataProvider != null) {
            latLong = latLongDataProvider.getLatLong(uRI);
        } else {
            Activator.logError("Unable to find a lat/long data provider for scheme \"" + uRI.scheme() + "\"", null);
        }
        return latLong;
    }

    private LatLong getLatLongNoWait(URI uRI) {
        LatLong latLong = new LatLong();
        LatLongDataProvider latLongDataProvider = this.getLatLongDataProvider(uRI.scheme());
        if (latLongDataProvider != null) {
            latLong = latLongDataProvider.getLatLongNoWait(uRI);
        } else {
            Activator.logError("Unable to find a lat/long data provider for scheme \"" + uRI.scheme() + "\"", null);
        }
        return latLong;
    }

    @Override
    public double[] getCenter() {
        double[] dArray = identifiableCenterCache.get(this.getTarget());
        if (dArray != null) {
            return dArray;
        }
        dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        LatLong latLong = this.getLatLong();
        if (latLong.getSegments().isEmpty()) {
            return null;
        }
        for (LatLong.Segment segment : latLong.getSegments()) {
            if (d == Double.MAX_VALUE && d3 == Double.MIN_VALUE) {
                d = d3 = segment.latitude(0);
                d2 = d4 = segment.longitude(0);
            }
            int n = segment.size();
            int n2 = 0;
            while (n2 < n) {
                double d5 = segment.longitude(n2);
                double d6 = segment.latitude(n2);
                if (d2 < d5) {
                    d2 = d5;
                }
                if (d < d6) {
                    d = d6;
                }
                if (d4 > d5) {
                    d4 = d5;
                }
                if (d3 > d6) {
                    d3 = d6;
                }
                ++n2;
            }
        }
        dArray[0] = (d + d3) / 2.0;
        dArray[1] = (d2 + d4) / 2.0;
        identifiableCenterCache.put((Identifiable)this.getTarget(), dArray);
        return dArray;
    }

    protected LatLongDataProvider getLatLongDataProvider(String string) {
        return LatLongProviderAdapter.getLatLongDataProviders().get(string);
    }
}

