/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformLatLongDataProvider
implements LatLongDataProvider {
    public static final String SAX_PARSER1 = "org.apache.xerces.parsers.SAXParser";
    public static final String SAX_PARSER2 = "org.apache.crimson.parser.XMLReaderImpl";
    static Map<URI, Map<String, LatLong>> cache = new ConcurrentHashMap<URI, Map<String, LatLong>>();
    public static final String PLATFORM_SCHEME = "platform";
    private static final CharSequence NORMAL_RES_FOLDER = "country";
    private static final CharSequence LOW_RES_FOLDER = "country_reduced";
    public boolean isSampling = false;
    public int sampleFrequency = 1;
    public boolean reportIOExceptions = true;
    public boolean useLowerResolutionLatLongData = false;

    public PlatformLatLongDataProvider() {
        this.setPreferences();
        Activator.getDefault().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                PlatformLatLongDataProvider.this.setPreferences();
                cache = new ConcurrentHashMap<URI, Map<String, LatLong>>();
            }
        });
    }

    @Override
    public LatLong getLatLong(URI uRI) {
        LatLong latLong = null;
        latLong = this.getLatLongMap(uRI.trimFragment()).get(uRI.fragment());
        latLong = latLong != null ? latLong : new LatLong();
        return latLong;
    }

    @Override
    public LatLong getLatLongNoWait(URI uRI) {
        LatLong latLong = null;
        latLong = this.getLatLongMapNoWait(uRI.trimFragment()).get(uRI.fragment());
        latLong = latLong != null ? latLong : new LatLong();
        return latLong;
    }

    public Set<String> getIds(URI uRI) {
        return this.getLatLongMap(uRI).keySet();
    }

    public Set<String> getIdsNoWait(URI uRI) {
        return this.getLatLongMapNoWait(uRI).keySet();
    }

    private Map<String, LatLong> getLatLongMap(URI uRI) {
        Map<String, LatLong> map = cache.get(uRI);
        if (map == null) {
            map = this.createLatLongMap(uRI);
            cache.put(uRI, map);
        }
        return map;
    }

    private synchronized Map<String, LatLong> getLatLongMapNoWait(final URI uRI) {
        Map<String, LatLong> map = cache.get(uRI);
        if (map == null) {
            map = new ConcurrentHashMap<String, LatLong>();
            cache.put(uRI, map);
            Job job = new Job(uRI.toString()){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(uRI.toString(), 100);
                    Map<String, LatLong> map = PlatformLatLongDataProvider.this.createLatLongMap(uRI);
                    cache.put(uRI, map);
                    iProgressMonitor.done();
                    return new Status(0, "org.eclipse.stem.definitions", 0, "Done", null);
                }
            };
            job.schedule();
        }
        return map;
    }

    Map<String, LatLong> createLatLongMap(URI uRI) {
        ConcurrentHashMap<String, LatLong> concurrentHashMap;
        block8: {
            concurrentHashMap = new ConcurrentHashMap<String, LatLong>();
            URIConverterImpl uRIConverterImpl = new URIConverterImpl();
            GMLDecoder gMLDecoder = new GMLDecoder(concurrentHashMap);
            try {
                InputStream inputStream = uRIConverterImpl.createInputStream(this.adjustFilePath(uRI));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PlatformLatLongDataProvider.parseInputStream(bufferedReader, gMLDecoder);
            }
            catch (IOException iOException) {
                if (this.useLowerResolutionLatLongData) {
                    try {
                        InputStream inputStream = uRIConverterImpl.createInputStream(uRI);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        PlatformLatLongDataProvider.parseInputStream(bufferedReader, gMLDecoder);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (this.reportIOExceptions) {
                            Activator.logInformation(fileNotFoundException.getMessage(), fileNotFoundException);
                        }
                        break block8;
                    }
                    catch (IOException iOException2) {
                        if (this.reportIOExceptions) {
                            Activator.logError(iOException2.getMessage(), iOException2);
                        }
                        break block8;
                    }
                }
                if (!this.reportIOExceptions) break block8;
                Activator.logError(iOException.getMessage(), iOException);
            }
        }
        return concurrentHashMap;
    }

    private URI adjustFilePath(URI uRI) {
        URI uRI2 = uRI;
        if (this.useLowerResolutionLatLongData) {
            String string = uRI.toString().replace(NORMAL_RES_FOLDER, LOW_RES_FOLDER);
            uRI2 = URI.createURI((String)string);
        }
        return uRI2;
    }

    private void setPreferences() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        this.isSampling = preferences.getBoolean("org.eclipse.stem.definitions.latlong.sample");
        this.sampleFrequency = preferences.getInt("org.eclipse.stem.definitions.latlong.samplefrequency");
        this.reportIOExceptions = preferences.getBoolean("org.eclipse.stem.definitions.latlong.ioreport");
        this.useLowerResolutionLatLongData = preferences.getBoolean("org.eclipse.stem.definitions.latlong.lowresolution");
    }

    public static XMLReader getSAXParser() {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(SAX_PARSER1);
            }
            catch (SAXException sAXException2) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader(SAX_PARSER2);
                }
                catch (SAXException sAXException3) {
                    Activator.logError(sAXException3.getMessage(), sAXException3);
                }
            }
        }
        return xMLReader;
    }

    public static void parseInputStream(BufferedReader bufferedReader, DefaultHandler defaultHandler) {
        try {
            XMLReader xMLReader = PlatformLatLongDataProvider.getSAXParser();
            xMLReader.setContentHandler(defaultHandler);
            xMLReader.parse(new InputSource(bufferedReader));
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Activator.logError(iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            Activator.logError(sAXException.getMessage(), sAXException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GMLDecoder
    extends DefaultHandler {
        private static final String XML_MAP_ELEMENT_NAME = "Map";
        private static final String XML_TITLE_ELEMENT_NAME = "title";
        private static final String XML_SUBTITLE_ELEMENT_NAME = "subTitle";
        private static final String XML_UPDATED_ELEMENT_NAME = "updated";
        private static final String XML_ENTRY_ELEMENT_NAME = "entry";
        private static final String XML_WHERE_ELEMENT_NAME = "where";
        private static final String XML_OUTER_BOUNDARY_ELEMENT_NAME = "outerBoundaryIs";
        private static final String XML_LINEAR_RING_ELEMENT_NAME = "LinearRing";
        private static final String XML_POLYGON_ELEMENT_NAME = "Polygon";
        private static final String XML_POSLIST_ELEMENT_NAME = "posList";
        private static final String XML_ID_ATTR = "gml:id";
        private String title = "";
        private String currentPolygonId = null;
        private Locator locator = null;
        Map<String, LatLong> latLongMap = null;
        private LatLong polygonLatLong = null;
        private LatLong.SegmentBuilder segmentBuilder = null;
        private StringBuilder characterStringBuilder = new StringBuilder();

        protected GMLDecoder(Map<String, LatLong> map) {
            this.latLongMap = map;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5 = string4 = string2.equals("") ? string3 : string2;
            if (string4.equalsIgnoreCase(XML_MAP_ELEMENT_NAME)) {
                assert (this.latLongMap != null);
            } else if (string4.equalsIgnoreCase(XML_TITLE_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (string4.equalsIgnoreCase(XML_SUBTITLE_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (string4.equalsIgnoreCase(XML_UPDATED_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (!(string4.equalsIgnoreCase(XML_ENTRY_ELEMENT_NAME) || string4.equalsIgnoreCase(XML_WHERE_ELEMENT_NAME) || string4.equalsIgnoreCase(XML_OUTER_BOUNDARY_ELEMENT_NAME) || string4.equalsIgnoreCase(XML_LINEAR_RING_ELEMENT_NAME))) {
                if (string4.equalsIgnoreCase(XML_POLYGON_ELEMENT_NAME)) {
                    assert (this.currentPolygonId == null);
                    assert (this.polygonLatLong == null);
                    this.currentPolygonId = attributes.getValue(XML_ID_ATTR);
                    this.polygonLatLong = new LatLong();
                } else if (string4.equalsIgnoreCase(XML_POSLIST_ELEMENT_NAME)) {
                    assert (this.segmentBuilder == null);
                    this.segmentBuilder = new LatLong.SegmentBuilder();
                    this.characterStringBuilder = new StringBuilder();
                } else {
                    throw new SAXParseException("Invalid element name \"" + string4 + "\"", this.locator);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4;
            String string5 = string4 = string2.equals("") ? string3 : string2;
            if (string4.equalsIgnoreCase(XML_MAP_ELEMENT_NAME)) {
                assert (this.latLongMap != null);
            } else if (string4.equalsIgnoreCase(XML_TITLE_ELEMENT_NAME)) {
                this.title = this.characterStringBuilder.toString();
                this.characterStringBuilder = new StringBuilder();
            } else if (string4.equalsIgnoreCase(XML_SUBTITLE_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (string4.equalsIgnoreCase(XML_UPDATED_ELEMENT_NAME)) {
                this.characterStringBuilder = new StringBuilder();
            } else if (!(string4.equalsIgnoreCase(XML_ENTRY_ELEMENT_NAME) || string4.equalsIgnoreCase(XML_WHERE_ELEMENT_NAME) || string4.equalsIgnoreCase(XML_OUTER_BOUNDARY_ELEMENT_NAME) || string4.equalsIgnoreCase(XML_LINEAR_RING_ELEMENT_NAME))) {
                if (string4.equalsIgnoreCase(XML_POLYGON_ELEMENT_NAME)) {
                    this.latLongMap.put(this.currentPolygonId, this.polygonLatLong);
                    this.currentPolygonId = null;
                    this.polygonLatLong = null;
                } else if (string4.equalsIgnoreCase(XML_POSLIST_ELEMENT_NAME)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.characterStringBuilder.toString(), " \n");
                    this.characterStringBuilder = new StringBuilder();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            String string7 = stringTokenizer.nextToken();
                            this.segmentBuilder.add(string6, string7);
                            continue;
                        }
                        Activator.logError("Latitude/Longitude data titled \"" + this.title + "\" is missing a longitude  match for the latitude value \"" + string6 + "\" at line: " + this.locator.getLineNumber() + ", column: " + this.locator.getColumnNumber(), null);
                        this.segmentBuilder.clear();
                        break;
                    }
                    if (this.segmentBuilder.size() > 0) {
                        try {
                            this.polygonLatLong.add(PlatformLatLongDataProvider.this.isSampling ? this.segmentBuilder.toSegment(PlatformLatLongDataProvider.this.sampleFrequency) : this.segmentBuilder.toSegment());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Activator.logError("Problem processing Latitude/Longitude data titled \"" + this.title + "\"", illegalArgumentException);
                        }
                    }
                    this.segmentBuilder = null;
                } else {
                    throw new SAXParseException("Invalid element name \"" + string4 + "\"", this.locator);
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.characterStringBuilder.append(new String(cArray, n, n2));
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            Activator.logInformation(sAXParseException.getMessage(), sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            Activator.logError(sAXParseException.getMessage(), sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            Activator.logError(sAXParseException.getMessage(), sAXParseException);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

