/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransportMode implements Enumerator
{
    UNSPECIFIED_LITERAL(0, "unspecified", "unspecified"),
    AIR_LITERAL(2, "air", "air"),
    ROAD_LITERAL(4, "road", "road"),
    RAIL_LITERAL(6, "rail", "rail"),
    MARINE_LITERAL(8, "marine", "marine"),
    FOOT_LITERAL(10, "foot", "foot");

    public static final int UNSPECIFIED = 0;
    public static final int AIR = 2;
    public static final int ROAD = 4;
    public static final int RAIL = 6;
    public static final int MARINE = 8;
    public static final int FOOT = 10;
    private static final TransportMode[] VALUES_ARRAY;
    public static final List<TransportMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransportMode[]{UNSPECIFIED_LITERAL, AIR_LITERAL, ROAD_LITERAL, RAIL_LITERAL, MARINE_LITERAL, FOOT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransportMode get(String string) {
        int n = 0;
        while (n < VALUES_ARRAY.length) {
            TransportMode transportMode = VALUES_ARRAY[n];
            if (transportMode.toString().equals(string)) {
                return transportMode;
            }
            ++n;
        }
        return null;
    }

    public static TransportMode getByName(String string) {
        int n = 0;
        while (n < VALUES_ARRAY.length) {
            TransportMode transportMode = VALUES_ARRAY[n];
            if (transportMode.getName().equals(string)) {
                return transportMode;
            }
            ++n;
        }
        return null;
    }

    public static TransportMode get(int n) {
        switch (n) {
            case 0: {
                return UNSPECIFIED_LITERAL;
            }
            case 2: {
                return AIR_LITERAL;
            }
            case 4: {
                return ROAD_LITERAL;
            }
            case 6: {
                return RAIL_LITERAL;
            }
            case 8: {
                return MARINE_LITERAL;
            }
            case 10: {
                return FOOT_LITERAL;
            }
        }
        return null;
    }

    private TransportMode(int n2, String string2, String string3) {
        this.value = n2;
        this.name = string2;
        this.literal = string3;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

