/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.DynamicEdgeLabelImpl;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.EdgeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.TransportMode;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabelValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportRelationshipLabelImpl
extends DynamicEdgeLabelImpl
implements TransportRelationshipLabel {
    protected static final TransportMode TRANSPORT_MODE_EDEFAULT = TransportMode.UNSPECIFIED_LITERAL;
    protected TransportMode transportMode = TRANSPORT_MODE_EDEFAULT;
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = null;
    protected String populationIdentifier = POPULATION_IDENTIFIER_EDEFAULT;
    protected static final String TRANSPORT_IDENTIFIER_EDEFAULT = null;
    protected String transportIdentifier = TRANSPORT_IDENTIFIER_EDEFAULT;
    protected static final long RATE_TIME_PERIOD_EDEFAULT = 0L;
    protected long rateTimePeriod = 0L;
    protected static final int DEPARTURE_CAPACITY_EDEFAULT = 0;
    protected static final int MAXIMUM_DEPARTURE_CAPACITY_EDEFAULT = 0;
    protected int maximumDepartureCapacity = 0;
    protected static final int CAPACITY_EDEFAULT = 0;
    protected static final int MAXIMUM_CAPACITY_EDEFAULT = 0;
    protected int maximumCapacity = 0;
    protected static final long TRANSIT_TIME_EDEFAULT = 0L;
    protected long transitTime = 0L;
    protected static final long START_UP_DELAY_EDEFAULT = 0L;
    protected long startUpDelay = 0L;
    private EObject nodeBArrivals = null;
    private EObject nodeAArrivals = null;

    protected TransportRelationshipLabelImpl() {
        this.setCurrentValue(LabelsFactory.eINSTANCE.createTransportRelationshipLabelValue());
        this.setNextValue(LabelsFactory.eINSTANCE.createTransportRelationshipLabelValue());
    }

    public static Edge createTransportRelationship(Node node, Node node2, TransportMode transportMode, String string, String string2, long l, int n, EdgeDecorator edgeDecorator) {
        return TransportRelationshipLabelImpl.createTransportRelationship(node, node2, transportMode, string, string2, l, n, false, edgeDecorator);
    }

    public static Edge createTransportRelationship(Node node, Node node2, TransportMode transportMode, String string, String string2, long l, int n, boolean bl, EdgeDecorator edgeDecorator) {
        return TransportRelationshipLabelImpl.createTransportRelationship(node, node2, transportMode, string, string2, l, n, n, 0L, 0L, bl, edgeDecorator);
    }

    public static Edge createTransportRelationship(Node node, Node node2, TransportMode transportMode, String string, String string2, long l, int n, int n2, long l2, long l3, EdgeDecorator edgeDecorator) {
        return TransportRelationshipLabelImpl.createTransportRelationship(node, node2, transportMode, string, string2, l, n, n2, l2, l3, false, edgeDecorator);
    }

    public static Edge createTransportRelationship(Node node, Node node2, TransportMode transportMode, String string, String string2, long l, int n, int n2, long l2, long l3, boolean bl, EdgeDecorator edgeDecorator) {
        Edge edge = EdgeImpl.createEdge((Node)node, (Node)node2, (boolean)bl);
        TransportRelationshipLabel transportRelationshipLabel = LabelsFactory.eINSTANCE.createTransportRelationshipLabel();
        transportRelationshipLabel.setURIOfIdentifiableToBeLabeled(edge.getURI());
        transportRelationshipLabel.setDecorator((Decorator)edgeDecorator);
        transportRelationshipLabel.setPopulationIdentifier(string2);
        transportRelationshipLabel.setTransportIdentifier(string);
        transportRelationshipLabel.setRateTimePeriod(l);
        transportRelationshipLabel.setMaximumDepartureCapacity(n);
        transportRelationshipLabel.setMaximumCapacity(n2);
        transportRelationshipLabel.setTransitTime(l2);
        transportRelationshipLabel.setStartUpDelay(l3);
        transportRelationshipLabel.setTransportMode(transportMode);
        TransportRelationshipLabelValue transportRelationshipLabelValue = transportRelationshipLabel.getCurrentTransportRelationshipLabelValue();
        transportRelationshipLabelValue.setAvailableDepartureCapacityProportion(1.0);
        edge.setLabel((EdgeLabel)transportRelationshipLabel);
        return edge;
    }

    protected EClass eStaticClass() {
        return LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL;
    }

    @Override
    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    @Override
    public void setTransportMode(TransportMode transportMode) {
        TransportMode transportMode2 = this.transportMode;
        TransportMode transportMode3 = this.transportMode = transportMode == null ? TRANSPORT_MODE_EDEFAULT : transportMode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)transportMode2, (Object)this.transportMode));
        }
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String string) {
        String string2 = this.populationIdentifier;
        this.populationIdentifier = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)string2, (Object)this.populationIdentifier));
        }
    }

    @Override
    public String getTransportIdentifier() {
        return this.transportIdentifier;
    }

    @Override
    public void setTransportIdentifier(String string) {
        String string2 = this.transportIdentifier;
        this.transportIdentifier = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)string2, (Object)this.transportIdentifier));
        }
    }

    @Override
    public TransportRelationshipLabelValue getCurrentTransportRelationshipLabelValue() {
        return (TransportRelationshipLabelValue)this.getCurrentValue();
    }

    @Override
    public long getRateTimePeriod() {
        return this.rateTimePeriod;
    }

    @Override
    public void setRateTimePeriod(long l) {
        long l2 = this.rateTimePeriod;
        this.rateTimePeriod = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, l2, this.rateTimePeriod));
        }
    }

    @Override
    public int getDepartureCapacity() {
        return (int)((double)this.getMaximumDepartureCapacity() * this.getCurrentTransportRelationshipLabelValue().getAvailableDepartureCapacityProportion());
    }

    @Override
    public int getMaximumDepartureCapacity() {
        return this.maximumDepartureCapacity;
    }

    @Override
    public void setMaximumDepartureCapacity(int n) {
        int n2 = this.maximumDepartureCapacity;
        this.maximumDepartureCapacity = n;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, n2, this.maximumDepartureCapacity));
        }
    }

    @Override
    public int getCapacity() {
        return (int)((double)this.getMaximumCapacity() * this.getCurrentTransportRelationshipLabelValue().getAvailableDepartureCapacityProportion());
    }

    @Override
    public int getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public void setMaximumCapacity(int n) {
        int n2 = this.maximumCapacity;
        this.maximumCapacity = n;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, n2, this.maximumCapacity));
        }
    }

    @Override
    public long getTransitTime() {
        return this.transitTime;
    }

    @Override
    public void setTransitTime(long l) {
        long l2 = this.transitTime;
        this.transitTime = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, l2, this.transitTime));
        }
    }

    @Override
    public long getStartUpDelay() {
        return this.startUpDelay;
    }

    @Override
    public void setStartUpDelay(long l) {
        long l2 = this.startUpDelay;
        this.startUpDelay = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, l2, this.startUpDelay));
        }
    }

    @Override
    public void send(Node node, EObject eObject) {
        if (this.getEdge().getA().equals(node)) {
            this.nodeBArrivals = eObject;
        } else {
            this.nodeAArrivals = eObject;
        }
    }

    @Override
    public EList<EObject> receive(Node node, STEMTime sTEMTime) {
        BasicEList basicEList = new BasicEList();
        if (this.getEdge().getA().equals(node)) {
            if (this.nodeAArrivals != null) {
                basicEList.add((Object)this.nodeAArrivals);
                this.nodeAArrivals = null;
            }
        } else if (this.nodeBArrivals != null) {
            basicEList.add((Object)this.nodeBArrivals);
            this.nodeBArrivals = null;
        }
        return basicEList;
    }

    public static List<Edge> getTransportEdgesToNode(Node node, String string) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : node.getEdges()) {
            TransportRelationshipLabel transportRelationshipLabel;
            EdgeLabel edgeLabel;
            if (edge.isDirected() && !edge.isDirectedAt(node) || !((edgeLabel = edge.getLabel()) instanceof TransportRelationshipLabel) || !(transportRelationshipLabel = (TransportRelationshipLabel)edgeLabel).getPopulationIdentifier().equalsIgnoreCase(string)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    public static List<Edge> getTransportEdgesFromNode(Node node, String string) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : node.getEdges()) {
            TransportRelationshipLabel transportRelationshipLabel;
            EdgeLabel edgeLabel;
            if (edge.isDirected() && edge.isDirectedAt(node) || !((edgeLabel = edge.getLabel()) instanceof TransportRelationshipLabel) || !(transportRelationshipLabel = (TransportRelationshipLabel)edgeLabel).getPopulationIdentifier().equalsIgnoreCase(string)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    public void reset() {
        super.reset();
        this.nodeAArrivals = null;
        this.nodeBArrivals = null;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 10: {
                return this.getTransportMode();
            }
            case 11: {
                return this.getPopulationIdentifier();
            }
            case 12: {
                return this.getTransportIdentifier();
            }
            case 13: {
                return this.getCurrentTransportRelationshipLabelValue();
            }
            case 14: {
                return this.getRateTimePeriod();
            }
            case 15: {
                return this.getDepartureCapacity();
            }
            case 16: {
                return this.getMaximumDepartureCapacity();
            }
            case 17: {
                return this.getCapacity();
            }
            case 18: {
                return this.getMaximumCapacity();
            }
            case 19: {
                return this.getTransitTime();
            }
            case 20: {
                return this.getStartUpDelay();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 10: {
                this.setTransportMode((TransportMode)((Object)object));
                return;
            }
            case 11: {
                this.setPopulationIdentifier((String)object);
                return;
            }
            case 12: {
                this.setTransportIdentifier((String)object);
                return;
            }
            case 14: {
                this.setRateTimePeriod((Long)object);
                return;
            }
            case 16: {
                this.setMaximumDepartureCapacity((Integer)object);
                return;
            }
            case 18: {
                this.setMaximumCapacity((Integer)object);
                return;
            }
            case 19: {
                this.setTransitTime((Long)object);
                return;
            }
            case 20: {
                this.setStartUpDelay((Long)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 10: {
                this.setTransportMode(TRANSPORT_MODE_EDEFAULT);
                return;
            }
            case 11: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setTransportIdentifier(TRANSPORT_IDENTIFIER_EDEFAULT);
                return;
            }
            case 14: {
                this.setRateTimePeriod(0L);
                return;
            }
            case 16: {
                this.setMaximumDepartureCapacity(0);
                return;
            }
            case 18: {
                this.setMaximumCapacity(0);
                return;
            }
            case 19: {
                this.setTransitTime(0L);
                return;
            }
            case 20: {
                this.setStartUpDelay(0L);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 10: {
                return this.transportMode != TRANSPORT_MODE_EDEFAULT;
            }
            case 11: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 12: {
                return TRANSPORT_IDENTIFIER_EDEFAULT == null ? this.transportIdentifier != null : !TRANSPORT_IDENTIFIER_EDEFAULT.equals(this.transportIdentifier);
            }
            case 13: {
                return this.getCurrentTransportRelationshipLabelValue() != null;
            }
            case 14: {
                return this.rateTimePeriod != 0L;
            }
            case 15: {
                return this.getDepartureCapacity() != 0;
            }
            case 16: {
                return this.maximumDepartureCapacity != 0;
            }
            case 17: {
                return this.getCapacity() != 0;
            }
            case 18: {
                return this.maximumCapacity != 0;
            }
            case 19: {
                return this.transitTime != 0L;
            }
            case 20: {
                return this.startUpDelay != 0L;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((Object)this.transportMode);
        stringBuffer.append(", ");
        stringBuffer.append(this.populationIdentifier);
        stringBuffer.append(", \"");
        stringBuffer.append(this.transportIdentifier);
        stringBuffer.append("\" ");
        stringBuffer.append(this.getCurrentTransportRelationshipLabelValue().toString());
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.rateTimePeriod >= 0L;
        assert (bl);
        bl = bl && this.getCurrentTransportRelationshipLabelValue().sane();
        return bl;
    }
}

