/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.graph.provider.StaticNodeLabelItemProvider;
import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.provider.DefinitionsEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulationLabelItemProvider
extends StaticNodeLabelItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public PopulationLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPopulationIdentifierPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addCurrentPopulationValuePropertyDescriptor(object);
            this.addPopulatedAreaPropertyDescriptor(object);
            this.addValidYearPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPopulationIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_populationIdentifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_populationIdentifier_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__POPULATION_IDENTIFIER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_name_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCurrentPopulationValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_currentPopulationValue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_currentPopulationValue_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__CURRENT_POPULATION_VALUE, false, false, false, null, null, null));
    }

    protected void addPopulatedAreaPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_populatedArea_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_populatedArea_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__POPULATED_AREA, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    protected void addValidYearPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_validYear_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_validYear_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__VALID_YEAR, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public String getText(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        PopulationLabel populationLabel = (PopulationLabel)object;
        stringBuilder.append(GeographicNames.getName((URI)populationLabel.getURIOfIdentifiableToBeLabeled()));
        stringBuilder.append(", \"");
        stringBuilder.append(populationLabel.getPopulationIdentifier());
        stringBuilder.append("\" population: ");
        stringBuilder.append((int)populationLabel.getCurrentPopulationValue().getCount());
        stringBuilder.append(populationLabel.getPopulatedArea() == 0.0 ? "" : " (" + populationLabel.getPopulatedArea() + " km^2)");
        return stringBuilder.toString();
    }

    public String getTextGen(Object object) {
        String string = ((PopulationLabel)object).getName();
        return string == null || string.length() == 0 ? this.getString("_UI_PopulationLabel_type") : String.valueOf(this.getString("_UI_PopulationLabel_type")) + " " + string;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PopulationLabel.class)) {
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
        super.collectNewChildDescriptors(collection, object);
    }

    public ResourceLocator getResourceLocator() {
        return DefinitionsEditPlugin.INSTANCE;
    }
}

