/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.stem.internal.data.specifications.IdentfiableSpecificationFactory;
import org.eclipse.stem.internal.data.specifications.IdentifiablePropertyFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataGenerator {
    public static final String ROOT_PROPERTY_FILES = "resources" + File.separator + "data";
    public static final String ROOT_SERIALIZED_FILES = "temp" + File.separator + "data";

    protected List<IdentifiablePropertyFileSpecification> processFiles(String[] stringArray) {
        List<IdentifiablePropertyFileSpecification> list = new ArrayList<IdentifiablePropertyFileSpecification>();
        if (stringArray.length == 0) {
            System.err.println("Missing specification of source directory as an argument");
        } else {
            String string = stringArray[0];
            String string2 = String.valueOf(string) + File.separator + ROOT_PROPERTY_FILES;
            String string3 = String.valueOf(string) + File.separator + ROOT_SERIALIZED_FILES;
            try {
                list = this.createIdentifiablePropertyFileSpecifications(string2);
                for (IdentifiablePropertyFileSpecification identifiablePropertyFileSpecification : list) {
                    identifiablePropertyFileSpecification.serialize(string3);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return list;
    }

    protected List<IdentifiablePropertyFileSpecification> createIdentifiablePropertyFileSpecifications(String string) {
        ArrayList<IdentifiablePropertyFileSpecification> arrayList = new ArrayList<IdentifiablePropertyFileSpecification>();
        List<File> list = this.getPropertyFiles(new File(string));
        int n = 0;
        for (File file : list) {
            IdentifiablePropertyFileSpecification identifiablePropertyFileSpecification = IdentfiableSpecificationFactory.INSTANCE.createIdentifiablePropertyFileSpecification(file);
            if (identifiablePropertyFileSpecification != null) {
                arrayList.add(identifiablePropertyFileSpecification);
                continue;
            }
            ++n;
        }
        if (n > 0) {
            System.out.println("Skipped " + n + " incorrect property file" + (n == 1 ? "" : "s"));
        }
        System.out.println("Created " + arrayList.size() + " GraphRecord" + (arrayList.size() == 1 ? "" : "s"));
        return arrayList;
    }

    private List<File> getPropertyFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    boolean bl = file.isFile() && string.endsWith(".properties") && !string.endsWith("names.properties") && !string.endsWith("centers.properties");
                    return bl;
                }
            });
            Collections.addAll(arrayList, fileArray2);
            File[] fileArray3 = fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().equals(".svn") && !file.getName().equals("CVS");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray3[n2];
                arrayList.addAll(this.getPropertyFiles(file2));
                ++n2;
            }
        } else {
            System.err.println("The directory \"" + file.getAbsolutePath() + "\" doesn't exist or is not a directory");
        }
        return arrayList;
    }
}

