/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.internal.data.specifications.IdentifiableSpecification;

public abstract class PluginFileGenerator {
    public static final String PLUGIN_XML_FILE_NAME = "plugin.xml";
    public static final String PLUGIN_PROPERTIES_FILE_NAME = "plugin.properties";
    public static final String GRAPH_EXTENSION_POINT_ID = "org.eclipse.stem.core.graph";
    public static final String MODEL_EXTENSION_POINT_ID = "org.eclipse.stem.core.model";
    public static final String SCENARIO_EXTENSION_POINT_ID = "org.eclipse.stem.core.scenario";
    public static final String ID_GRAPH_CATEGORY = "org.eclipse.stem.core.graph";
    public static final String ID_MODEL_CATEGORY = "org.eclipse.stem.core.model";
    public static final String ID_SCENARIO_CATEGORY = "org.eclipse.stem.core.scenario";
    public static final String UI_STEM_CATEGORY_NAME = "_UI_Standard_Scenario_category";
    public static final String STEM_CATEGORY_NAME = "STEM";
    public static final String PROVIDER_NAME = "Eclipse.org";

    protected void outputPluginHeader(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<?eclipse version=\"3.3\"?>");
        printWriter.println("<plugin>");
        printWriter.println("<!-- Generated Content.  Do not Edit. -->");
        printWriter.println("<!-- Generated: " + this.createGeneratedDateComment() + " -->");
    }

    protected void outputPluginFooter(PrintWriter printWriter) {
        printWriter.println("</plugin>");
    }

    protected void outputDublinCore(IdentifiableSpecification identifiableSpecification, String string, PrintWriter printWriter) {
        DublinCore dublinCore = identifiableSpecification.getDublinCore();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<dublin_core ");
        stringBuilder.append("category_id=\"");
        stringBuilder.append(string);
        stringBuilder.append("\" ");
        stringBuilder.append(dublinCore.toString());
        stringBuilder.append("/>");
        printWriter.println(stringBuilder.toString());
    }

    protected String createGeneratedDateComment() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(Calendar.getInstance().getTime());
    }
}

