/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.stem.internal.data.specifications.IdentifiablePropertyFileSpecification;

public class IdentfiableSpecificationFactory {
    public static final IdentfiableSpecificationFactory INSTANCE = new IdentfiableSpecificationFactory();

    public IdentifiablePropertyFileSpecification createIdentifiablePropertyFileSpecification(File file) {
        IdentifiablePropertyFileSpecification identifiablePropertyFileSpecification;
        block9: {
            identifiablePropertyFileSpecification = null;
            if (file.isFile() && file.canRead()) {
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    properties.load(bufferedInputStream);
                    bufferedInputStream.close();
                    String string = (String)properties.get("RECORD_CLASSNAME");
                    if (string != null) {
                        string = string.trim();
                        try {
                            identifiablePropertyFileSpecification = (IdentifiablePropertyFileSpecification)Class.forName(string).newInstance();
                            identifiablePropertyFileSpecification.collectPropertyDataSet(properties);
                        }
                        catch (Exception exception) {
                            System.err.println("Error while reading the properties file \"" + file.getName() + "\", creating an instance of the class \"" + string + "\" caused the following error.");
                            exception.printStackTrace();
                        }
                        catch (Error error) {
                            System.err.println("Error while reading the properties file \"" + file.getName() + "\", creating an instance of the class \"" + string + "\" caused the following error.");
                            error.printStackTrace();
                        }
                        break block9;
                    }
                    System.err.println("The properties file \"" + file.getName() + "\" did not contain the property \"" + "RECORD_CLASSNAME" + "\" the defines the name of the class that processes the contents of the file.\"");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
            } else {
                System.err.println("The file \"" + file.getAbsolutePath() + "\" is not a file or can't be read.");
            }
        }
        return identifiablePropertyFileSpecification;
    }
}

