/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.internal.data.propertydata.PropertyData;
import org.eclipse.stem.internal.data.specifications.IdentifiableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdentifiablePropertyFileSpecification
extends IdentifiableSpecification {
    public static final String RECORD_CLASSNAME_PROPERTY = "RECORD_CLASSNAME";
    public static final String BIBLIOGRAPHIC_CITATION_PROPERTY = "BIBLIOGRAPHIC_CITATION";
    public static final String CONTRIBUTOR_PROPERTY = "CONTRIBUTOR";
    public static final String COVERAGE_PROPERTY = "COVERAGE";
    public static final String CREATED_PROPERTY = "CREATED";
    public static final String CREATOR_PROPERTY = "CREATOR";
    public static final String DATE_PROPERTY = "DATE";
    public static final String DESCRIPTION_PROPERTY = "DESCRIPTION";
    public static final String FORMAT_PROPERTY = "FORMAT";
    public static final String IDENTIFIER_PROPERTY = "IDENTIFIER";
    public static final String LANGUAGE_PROPERTY = "LANGUAGE";
    public static final String LICENSE_PROPERTY = "LICENSE";
    public static final String PUBLISHER_PROPERTY = "PUBLISHER";
    public static final String RELATION_PROPERTY = "RELATION";
    public static final String REQUIRED_PROPERTY = "REQUIRED";
    public static final String RIGHTS_PROPERTY = "RIGHTS";
    public static final String SOURCE_PROPERTY = "SOURCE";
    public static final String SPATIAL_PROPERTY = "SPATIAL_URI";
    public static final String SUBJECT_PROPERTY = "SUBJECT";
    public static final String TITLE_PROPERTY = "TITLE";
    public static final String TYPE_PROPERTY = "TYPE";
    public static final String VALID_PROPERTY = "VALID";
    protected List<PropertyData> propertyDataSet = new ArrayList<PropertyData>();

    public static IdentifiablePropertyFileSpecification createPropertyDataSetIdentifiableSpecification(File file) {
        IdentifiablePropertyFileSpecification identifiablePropertyFileSpecification;
        block9: {
            identifiablePropertyFileSpecification = null;
            if (file.isFile() && file.canRead()) {
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    properties.load(bufferedInputStream);
                    bufferedInputStream.close();
                    String string = (String)properties.get(RECORD_CLASSNAME_PROPERTY);
                    if (string != null) {
                        string = string.trim();
                        try {
                            identifiablePropertyFileSpecification = (IdentifiablePropertyFileSpecification)Class.forName(string).newInstance();
                            identifiablePropertyFileSpecification.collectPropertyDataSet(properties);
                        }
                        catch (Exception exception) {
                            System.err.println("Error while reading the properties file \"" + file.getName() + "\", creating an instance of the class \"" + string + "\" caused the following error.");
                            exception.printStackTrace();
                        }
                        catch (Error error) {
                            System.err.println("Error while reading the properties file \"" + file.getName() + "\", creating an instance of the class \"" + string + "\" caused the following error.");
                            error.printStackTrace();
                        }
                        break block9;
                    }
                    System.err.println("The properties file \"" + file.getName() + "\" did not contain the property \"" + RECORD_CLASSNAME_PROPERTY + "\" that defines the name of the class that processes the contents of the file.\"");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
            } else {
                System.err.println("The file \"" + file.getAbsolutePath() + "\" is not a file or can't be read.");
            }
        }
        return identifiablePropertyFileSpecification;
    }

    protected void collectPropertyDataSet(Properties properties) {
        this.collectNonDataProperties(properties);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            PropertyData propertyData = this.createPropertyDataInstanceFromProperty(string, ((String)entry.getValue()).trim());
            if (propertyData == null) continue;
            this.propertyDataSet.add(propertyData);
        }
    }

    protected abstract PropertyData createPropertyDataInstanceFromProperty(String var1, String var2);

    protected void collectNonDataProperties(Properties properties) {
        properties.remove(RECORD_CLASSNAME_PROPERTY);
        this.dublinCore.setBibliographicCitation(properties.getProperty(BIBLIOGRAPHIC_CITATION_PROPERTY));
        this.dublinCore.setContributor(properties.getProperty(CONTRIBUTOR_PROPERTY));
        this.dublinCore.setCoverage(properties.getProperty(COVERAGE_PROPERTY));
        this.dublinCore.setCreated(properties.getProperty(CREATED_PROPERTY));
        this.dublinCore.setCreator(properties.getProperty(CREATOR_PROPERTY));
        this.dublinCore.setDate(properties.getProperty(DATE_PROPERTY));
        this.dublinCore.setDescription(properties.getProperty(DESCRIPTION_PROPERTY));
        this.dublinCore.setFormat(properties.getProperty(FORMAT_PROPERTY));
        this.dublinCore.setIdentifier(properties.getProperty(IDENTIFIER_PROPERTY));
        this.dublinCore.setLanguage(properties.getProperty(LANGUAGE_PROPERTY));
        this.dublinCore.setLicense(properties.getProperty(LICENSE_PROPERTY));
        this.dublinCore.setPublisher(properties.getProperty(PUBLISHER_PROPERTY));
        this.dublinCore.setRelation(properties.getProperty(RELATION_PROPERTY));
        this.dublinCore.setRequired(properties.getProperty(REQUIRED_PROPERTY));
        this.dublinCore.setRights(properties.getProperty(RIGHTS_PROPERTY));
        this.dublinCore.setSource(properties.getProperty(SOURCE_PROPERTY));
        this.dublinCore.setSpatial(properties.getProperty(SPATIAL_PROPERTY));
        this.dublinCore.setSubject(properties.getProperty(SUBJECT_PROPERTY));
        this.dublinCore.setTitle(properties.getProperty(TITLE_PROPERTY));
        this.dublinCore.setType(properties.getProperty(TYPE_PROPERTY));
        this.dublinCore.setValid(properties.getProperty(VALID_PROPERTY));
        properties.remove(BIBLIOGRAPHIC_CITATION_PROPERTY);
        properties.remove(CONTRIBUTOR_PROPERTY);
        properties.remove(COVERAGE_PROPERTY);
        properties.remove(CREATED_PROPERTY);
        properties.remove(CREATOR_PROPERTY);
        properties.remove(DATE_PROPERTY);
        properties.remove(DESCRIPTION_PROPERTY);
        properties.remove(FORMAT_PROPERTY);
        properties.remove(IDENTIFIER_PROPERTY);
        properties.remove(LANGUAGE_PROPERTY);
        properties.remove(LICENSE_PROPERTY);
        properties.remove(PUBLISHER_PROPERTY);
        properties.remove(RELATION_PROPERTY);
        properties.remove(REQUIRED_PROPERTY);
        properties.remove(RIGHTS_PROPERTY);
        properties.remove(SOURCE_PROPERTY);
        properties.remove(SPATIAL_PROPERTY);
        properties.remove(SUBJECT_PROPERTY);
        properties.remove(TITLE_PROPERTY);
        properties.remove(TYPE_PROPERTY);
        properties.remove(VALID_PROPERTY);
    }

    @Override
    protected Identifiable createIdentifiable() {
        Identifiable identifiable = super.createIdentifiable();
        this.initializeIdentifiableFromNonDataProperties(identifiable);
        if (this.propertyDataSet != null && this.propertyDataSet.size() > 0) {
            this.initializeIdentifiableFromPropertyDataSet(identifiable, this.propertyDataSet);
            this.propertyDataSet = null;
        }
        return identifiable;
    }

    protected void initializeIdentifiableFromNonDataProperties(Identifiable identifiable) {
    }

    protected abstract void initializeIdentifiableFromPropertyDataSet(Identifiable var1, List<PropertyData> var2);
}

