/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.CommonFactory;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;

public abstract class IdentifiableSpecification {
    protected static final URIConverter converter = new URIConverterImpl();
    protected static final DateFormat SERIALIZATION_CONTENT_DESCRIPTOR_DATE_FORMATER = new SimpleDateFormat("yyyyMMdd");
    public static final String SERIALIZATION_DATE_RANGE_FORMAT_2_DATES = "{0}{1}";
    public static final String SERIALIZATION_DATE_RANGE_FORMAT_1_DATE = "{0}";
    public static final String SERIALIZATION_DATE_RANGE_FORMAT_1_DATE_YEAR = "{0}";
    protected Identifiable identifiable = null;
    protected org.eclipse.stem.core.common.DublinCore dublinCore = CommonFactory.eINSTANCE.createDublinCore();

    protected IdentifiableSpecification() {
        this.dublinCore.populate();
    }

    protected IdentifiableSpecification(Date date) {
        this();
        this.setStartDate(date);
    }

    protected IdentifiableSpecification(Date date, Date date2) {
        this(date);
        this.setEndDate(date2);
    }

    public final Identifiable getIdentifiable() {
        if (this.identifiable == null) {
            this.identifiable = this.createIdentifiable();
            if (!this.identifiable.sane()) {
                System.out.println(String.valueOf(this.identifiable.getDublinCore().getTitle()) + " is not sane!!");
            }
            if (this.identifiable.getDublinCore().getTitle() == null || this.identifiable.getDublinCore().getTitle().equals("")) {
                this.identifiable.getDublinCore().setTitle(this.createDublinCoreTitle());
            }
            if (this.identifiable.getDublinCore().getDescription() == null || this.identifiable.getDublinCore().getDescription().equals("")) {
                this.identifiable.getDublinCore().setDescription(this.createDublinCoreDescription());
            }
            this.identifiable.getDublinCore().setCoverage(this.createDubinCoreCoverage());
            this.identifiable.getDublinCore().setSubject(this.createDubinCoreSubject());
        }
        return this.identifiable;
    }

    protected Identifiable createIdentifiable() {
        Identifiable identifiable = this.createIdentifiableInstance();
        identifiable.setDublinCore(this.dublinCore);
        identifiable.setURI(this.createPlatformURI());
        return identifiable;
    }

    protected abstract Identifiable createIdentifiableInstance();

    public final org.eclipse.stem.core.common.DublinCore getDublinCore() {
        return this.dublinCore;
    }

    public final void setDublinCore(org.eclipse.stem.core.common.DublinCore dublinCore) {
        this.dublinCore = dublinCore;
    }

    public final void setEndDate(Date date) {
        this.dublinCore.setValid(this.dublinCore.getValidStartDate(), date);
    }

    public final Date getEndDate() {
        return this.dublinCore.getValidEndDate();
    }

    public final Date getStartDate() {
        return this.dublinCore.getValidStartDate();
    }

    public final void setStartDate(Date date) {
        this.dublinCore.setValid(date);
    }

    public boolean inDateRange(Date date, Date date2) {
        Date date3 = this.getStartDate();
        Date date4 = this.getEndDate();
        boolean bl = date3 == null || date == null || (date3.equals(date) || date3.after(date)) && (date2 == null || date3.equals(date2) || date3.before(date2));
        bl = bl || date3.before(date) && (date4 == null || date4.equals(date) || date4.after(date));
        return bl;
    }

    public boolean isValidBefore(IdentifiableSpecification identifiableSpecification) {
        return this.getDublinCore().isValidBefore(identifiableSpecification.getDublinCore());
    }

    protected void updateDateRange(IdentifiableSpecification identifiableSpecification) {
        Date[] dateArray = this.getDublinCore().computeValidDateRangeOverlap(identifiableSpecification.getDublinCore());
        if (dateArray != null) {
            this.setStartDate(dateArray[0]);
            this.setEndDate(dateArray[1]);
        }
    }

    public static String convertToProjectURI(String string) {
        return string.replace("plugin", "resource");
    }

    public static URI getIdentifiableProjectURI(DublinCore dublinCore) {
        return URI.createURI((String)IdentifiableSpecification.convertToProjectURI(dublinCore.getIdentifier()));
    }

    public void serialize(String string) throws IOException {
        Utility.serializeIdentifiable((Identifiable)this.getIdentifiable(), (URI)converter.normalize(URI.createFileURI((String)(String.valueOf(string) + File.separator + this.getRelativeSerializationPathAndFileName()))));
    }

    protected String getRelativeSerializationPathAndFileName() {
        StringBuilder stringBuilder = new StringBuilder(this.getRelativeSerializationPath());
        stringBuilder.append(File.separator);
        stringBuilder.append(this.getSerializationFileNameRoot());
        stringBuilder.append(".");
        stringBuilder.append(this.getSerializationFileNameExtension());
        return stringBuilder.toString();
    }

    protected abstract String getRelativeSerializationPath();

    protected abstract String getSerializationFileNameRoot();

    protected abstract String getSerializationFileNameExtension();

    protected abstract String getTitleDescriptor();

    protected String createValidDateRangeString(DateFormat dateFormat, String string, String string2, String string3) {
        String string4 = "";
        String string5 = this.dublinCore.getValid();
        Date date = this.dublinCore.getValidStartDate();
        Date date2 = this.dublinCore.getValidEndDate();
        if (string5 != null && date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (date2 != null) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                string4 = calendar.get(1) == calendar2.get(1) ? (calendar.get(2) == 0 && calendar.get(5) == 1 && calendar2.get(2) == 11 && calendar2.get(5) == 31 ? MessageFormat.format(string3, Integer.toString(calendar.get(1))) : MessageFormat.format(string2, dateFormat.format(date), dateFormat.format(date2))) : MessageFormat.format(string2, dateFormat.format(date), dateFormat.format(date2));
            } else {
                string4 = MessageFormat.format(string, dateFormat.format(date));
            }
        }
        return string4;
    }

    protected URI createPlatformURI() {
        StringBuilder stringBuilder = new StringBuilder(this.getURIPrefix());
        stringBuilder.append("/");
        stringBuilder.append(this.getRelativeSerializationPathAndFileName().replace('\\', '/'));
        return URI.createURI((String)stringBuilder.toString());
    }

    protected String getURIPrefix() {
        StringBuilder stringBuilder = new StringBuilder("platform:/plugin/");
        stringBuilder.append(this.getTargetPluginId());
        stringBuilder.append("/resources/data");
        return stringBuilder.toString();
    }

    protected abstract String getTargetPluginId();

    protected String createDublinCoreTitle() {
        String string = this.dublinCore.getTitle();
        StringBuilder stringBuilder = new StringBuilder(string != null ? string : this.getTitleDescriptor());
        return stringBuilder.toString();
    }

    protected String createDublinCoreDescription() {
        return this.getContentCountString();
    }

    protected String createDubinCoreCoverage() {
        return "";
    }

    protected String createDubinCoreSubject() {
        return "";
    }

    protected String getContentCountString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }
}

