/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.internal.data.propertydata.PropertyData;
import org.eclipse.stem.internal.data.propertydata.RelationshipPropertyData;
import org.eclipse.stem.internal.data.specifications.GraphPropertyFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipGraphPropertyFileSpecification
extends GraphPropertyFileSpecification {
    public static final String RELATIONSHIP_DIR = "relationship";

    @Override
    protected void initializeIdentifiableFromPropertyDataSet(Identifiable identifiable, List<PropertyData> list) {
        Graph graph = (Graph)identifiable;
        for (PropertyData propertyData : list) {
            RelationshipPropertyData relationshipPropertyData = (RelationshipPropertyData)propertyData;
            Edge edge = this.createEdge(relationshipPropertyData, this.getDublinCore().getSpatial());
            graph.putEdge(edge);
        }
    }

    protected abstract String getRelationshipName();

    protected abstract Edge createEdge(RelationshipPropertyData var1, String var2);

    protected String getRelationshipSpecifier(RelationshipPropertyData relationshipPropertyData) {
        return "";
    }

    protected URI createRelationshipEdgeURI(RelationshipPropertyData relationshipPropertyData) {
        return this.createRelationshipURI("edge", relationshipPropertyData);
    }

    protected abstract URI createRelationshipURI(String var1, RelationshipPropertyData var2);

    protected URI createRelationshipEdgeLabelURI(RelationshipPropertyData relationshipPropertyData) {
        return this.createRelationshipURI("label", relationshipPropertyData);
    }

    protected abstract EdgeLabel createEdgeLabel(RelationshipPropertyData var1);

    @Override
    protected String createDubinCoreSubject() {
        return RelationshipGraphPropertyFileSpecification.createDublinCoreSubjectString(GraphPackage.Literals.EDGE.getName(), this.getRelationshipName());
    }
}

