/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.utility;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborUtility {
    public static String workspaceFolder = "c:/stem/";
    public static boolean DEBUG = true;
    static int MAX = 50;
    static int counter = 0;
    public static String baseURI = "platform:/plugin/org.eclipse.stem.geography/resources/data/geo/country/";
    public static String baseFolder = String.valueOf(workspaceFolder) + "org.eclipse.stem.geography/" + "resources/data/geo/country/";
    public static String commonborderFolder = String.valueOf(workspaceFolder) + "org.eclipse.stem.internal.data/" + "resources/data/relationship/commonborder/";
    public static StringBuffer problems = new StringBuffer(2000);
    private static int c_bboxNeighbors = 0;
    private static int c_pointNeighbors = 0;
    private static int c_closeNeighbors = 0;
    private static int c_segmentNeighbors = 0;
    private static int c_Neighbors = 0;
    private static long c_start = new Date().getTime();
    private static final long start = new Date().getTime();
    public static boolean bboxCheckOnly = false;

    static List<String[]> neighborCheck(PlatformLatLongDataProvider platformLatLongDataProvider, String string, String string2) {
        String string3 = String.valueOf(baseURI) + string + "/" + string2;
        Map<String, AdminArea[]> map = NeighborUtility.buildMap(platformLatLongDataProvider, string3);
        List<String[]> list = NeighborUtility.processAreas(map);
        return list;
    }

    static List<String[]> neighborCheck(PlatformLatLongDataProvider platformLatLongDataProvider, String string, String string2, String string3, String string4) {
        String string5 = String.valueOf(baseURI) + string + "/" + string2;
        String string6 = String.valueOf(baseURI) + string3 + "/" + string4;
        Map<String, AdminArea[]> map = NeighborUtility.buildMap(platformLatLongDataProvider, string5);
        Map<String, AdminArea[]> map2 = NeighborUtility.buildMap(platformLatLongDataProvider, string6);
        List<String[]> list = NeighborUtility.matchArea(map, map2);
        return list;
    }

    private static Map<String, AdminArea[]> buildMap(PlatformLatLongDataProvider platformLatLongDataProvider, String string) {
        HashMap<String, AdminArea[]> hashMap = new HashMap<String, AdminArea[]>(4000);
        URI uRI = URI.createURI((String)string);
        Set set = platformLatLongDataProvider.getIds(uRI);
        for (String string2 : set) {
            LatLong latLong = platformLatLongDataProvider.getLatLong(URI.createURI((String)(String.valueOf(string) + "#" + string2)));
            NeighborUtility.setArea(hashMap, string2, latLong);
        }
        return hashMap;
    }

    static void doAllInternal(PlatformLatLongDataProvider platformLatLongDataProvider) {
        List<String> list = NeighborUtility.getAdmin0List();
        for (String string : list) {
            String string2 = NeighborUtility.getAdmin(string);
            if (string2.contains("_0_") || string2 == null) continue;
            NeighborUtility.output("** " + string);
            List<String[]> list2 = NeighborUtility.neighborCheck(platformLatLongDataProvider, string, string2);
            NeighborUtility.writeProperties(list2, string, string2, string, string2);
            NeighborUtility.statistics();
            if (list2.size() != 0) continue;
            problems.append(String.valueOf(string) + ": " + string2 + "\n");
        }
        if (problems.length() > 0) {
            NeighborUtility.debug("***");
            NeighborUtility.debug("*** Admin areas with no internal neighbors:");
            NeighborUtility.debug("***");
            NeighborUtility.debug(problems.toString());
            problems = new StringBuffer(2000);
        }
    }

    static List<String[]> doWorld(PlatformLatLongDataProvider platformLatLongDataProvider, boolean bl) {
        HashMap<String, AdminArea[]> hashMap = new HashMap<String, AdminArea[]>(4000);
        List<String> list = NeighborUtility.getAdmin0List();
        if (bl) {
            bboxCheckOnly = true;
        }
        for (String object2 : list) {
            String string;
            URI uRI;
            Set set;
            String string2;
            if (object2.equals("ALB") || object2.equals("GRC")) {
                NeighborUtility.debug(object2);
            }
            if (!(string2 = NeighborUtility.getAdmin0(object2)).contains("_0_")) {
                NeighborUtility.output(String.valueOf(object2) + " admin 0 file  does not exist");
            }
            if ((set = platformLatLongDataProvider.getIds(uRI = URI.createURI((String)(string = String.valueOf(baseURI) + object2 + "/" + string2)))) == null || set.size() == 0) {
                NeighborUtility.output(String.valueOf(object2) + ": " + string2 + " does not exist");
                continue;
            }
            for (String string3 : set) {
                LatLong latLong = platformLatLongDataProvider.getLatLong(URI.createURI((String)(String.valueOf(string) + "#" + string3)));
                if (string2.contains("_0_")) {
                    NeighborUtility.setArea(hashMap, string3, latLong);
                    continue;
                }
                NeighborUtility.setArea(hashMap, object2, latLong);
            }
        }
        NeighborUtility.debug("doWorld: area setup complete.");
        List<String[]> list2 = NeighborUtility.processAreas(hashMap);
        NeighborUtility.debug("ZZZ: ");
        NeighborUtility.statistics();
        NeighborUtility.writeProperties(list2, "ZZZ", "ZZZ_0", "ZZZ", "ZZZ_0");
        return list2;
    }

    public static boolean doAllBorders(PlatformLatLongDataProvider platformLatLongDataProvider, List<String[]> list) {
        NeighborUtility.output("doAllBorders: " + list.size());
        bboxCheckOnly = false;
        ListIterator<String[]> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String[] stringArray = listIterator.next();
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = NeighborUtility.getAdmin(string);
            String string4 = NeighborUtility.getAdmin(string2);
            if (string3 == null || string4 == null) continue;
            NeighborUtility.output(String.valueOf(string) + ":" + string3 + " : " + string2 + ":" + string4);
            List<String[]> list2 = NeighborUtility.neighborCheck(platformLatLongDataProvider, string, string3, string2, string4);
            if (list2.size() == 0) {
                NeighborUtility.output("*** Remove from ZZZ: " + string + ":" + string2);
                listIterator.remove();
            } else {
                NeighborUtility.writeProperties(list2, string, string3, string2, string4);
            }
            NeighborUtility.statistics();
        }
        NeighborUtility.writeProperties(list, "ZZZ", "ZZZ_0", "ZZZ", "ZZZ_0");
        return true;
    }

    static void doAllBorders(PlatformLatLongDataProvider platformLatLongDataProvider) {
        String string = commonborderFolder;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Properties properties = null;
        File file = null;
        try {
            file = new File(string, "ZZZ_0_ZZZ_0.properties");
            FileInputStream fileInputStream = new FileInputStream(file);
            properties = new Properties();
            properties.load(fileInputStream);
            String string2 = null;
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                StringTokenizer stringTokenizer;
                string2 = (String)enumeration.nextElement();
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                String string3 = properties.getProperty(string2);
                if (string3 == null || (stringTokenizer = new StringTokenizer(string3, ",")).countTokens() < 2) continue;
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String[] stringArray = new String[]{string4, string5};
                arrayList.add(stringArray);
            }
            NeighborUtility.output("worldList size: " + arrayList.size());
            NeighborUtility.doAllBorders(platformLatLongDataProvider, arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getAdmin(String string) {
        String string2 = null;
        String string3 = null;
        File file = new File(String.valueOf(baseFolder) + "/" + string);
        if (file.exists()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray2[n2];
                if (string4.contains("_2_")) {
                    string2 = string4;
                    break;
                }
                if (string4.contains("_1_")) {
                    string2 = string4;
                } else if (string4.contains("_0_")) {
                    string3 = string4;
                }
                ++n2;
            }
        }
        if (string2 == null) {
            return string3;
        }
        return string2;
    }

    public static String getAdmin0(String string) {
        String string2 = null;
        File file = new File(String.valueOf(baseFolder) + "/" + string);
        if (file.exists()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                if (string3.contains("_0_")) {
                    string2 = string3;
                    break;
                }
                if (string3.contains("_1_")) {
                    string2 = string3;
                    break;
                }
                if (string3.contains("_2_")) {
                    string2 = string3;
                    NeighborUtility.debug("getAdmin0: file: " + string3);
                }
                ++n2;
            }
        }
        return string2;
    }

    static List<String> getAdmin0List() {
        String string = baseFolder;
        String[] stringArray = new File(string).list();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (!string2.equals(".svn") && !string2.equals("CVS")) {
                arrayList.add(string2);
            }
            ++n2;
        }
        return arrayList;
    }

    static void writeProperties(List<String[]> list, String string, String string2, String string3, String string4) {
        try {
            FileOutputStream fileOutputStream = null;
            try {
                File file = new File(NeighborUtility.getPropertyFolder());
                file.mkdir();
                File file2 = new File(file, String.valueOf(string2.substring(0, 5)) + "_" + string4.substring(0, 5) + ".properties");
                NeighborUtility.debug("Output File: " + file2);
                fileOutputStream = new FileOutputStream(file2, false);
                String string5 = "Common Border relationship between country " + string + " and " + string3;
                if (string.equals(string3)) {
                    string5 = "Common Border relationship within country " + string;
                }
                if (string.equals("ZZZ")) {
                    string5 = "Common Border relationship between all countries in the world";
                }
                String string6 = "# \n#  File generated from:\n#   " + baseFolder + string + "/" + string2 + "\n" + "#   " + baseFolder + string3 + "/" + string4 + "\n" + "#\n" + "#  Generated by: " + NeighborUtility.class + "\n" + "# " + "\n";
                if (string.equals(string3)) {
                    string6 = "# \n#  File generated from:\n#   " + baseFolder + string + "/" + string2 + "\n" + "#\n" + "#  Generated by: " + NeighborUtility.class + "\n" + "# " + "\n";
                }
                ((OutputStream)fileOutputStream).write(string6.getBytes());
                String string7 = "RECORD_CLASSNAME = org.eclipse.stem.internal.data.CommonBorderRelationshipGraphRecord\n";
                ((OutputStream)fileOutputStream).write(string7.getBytes());
                string7 = "TITLE = " + string5 + "\n";
                ((OutputStream)fileOutputStream).write(string7.getBytes());
                string7 = "VALID = start=2006-01-01;\n";
                ((OutputStream)fileOutputStream).write(string7.getBytes());
                String string8 = string2.substring(4, 5);
                String string9 = string4.substring(4, 5);
                String string10 = "ISOKEY_0 = " + string + "\n";
                string10 = String.valueOf(string10) + "ISOKEY_0_LEVEL = " + string8 + "\n";
                string10 = String.valueOf(string10) + "ISOKEY_1 = " + string3 + "\n";
                string10 = String.valueOf(string10) + "ISOKEY_1_LEVEL = " + string9 + "\n";
                ((OutputStream)fileOutputStream).write(string10.getBytes());
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    String[] stringArray = list.get(n2);
                    StringBuffer stringBuffer = new StringBuffer(80);
                    stringBuffer.append("" + (n2 + 1));
                    stringBuffer.append(" = ");
                    stringBuffer.append(stringArray[0]);
                    stringBuffer.append(", ");
                    stringBuffer.append(stringArray[1]);
                    stringBuffer.append(", 0");
                    stringBuffer.append("\n");
                    ((OutputStream)fileOutputStream).write(stringBuffer.toString().getBytes());
                    ++n2;
                }
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void setArea(Map<String, AdminArea[]> map, String string, LatLong latLong) {
        List list = latLong.getSegments();
        int n = list.size();
        LatLong.Segment[] segmentArray = new LatLong.Segment[n];
        int n2 = 0;
        while (n2 < n) {
            segmentArray[n2] = (LatLong.Segment)list.get(n2);
            ++n2;
        }
        Polygon[] polygonArray = NeighborUtility.getPolygons(latLong);
        int n3 = polygonArray.length;
        AdminArea[] adminAreaArray = new AdminArea[n3];
        int n4 = 0;
        while (n4 < n3) {
            Rectangle rectangle = polygonArray[n4].getBounds();
            adminAreaArray[n4] = new AdminArea(segmentArray[n4], rectangle, string);
            ++n4;
        }
        AdminArea[] adminAreaArray2 = map.get(string);
        if (adminAreaArray2 == null) {
            map.put(string, adminAreaArray);
        } else {
            int n5 = adminAreaArray.length;
            int n6 = adminAreaArray2.length;
            AdminArea[] adminAreaArray3 = new AdminArea[n5 + n6];
            int n7 = 0;
            while (n7 < n6) {
                adminAreaArray3[n7] = adminAreaArray2[n7];
                ++n7;
            }
            n7 = adminAreaArray.length;
            int n8 = 0;
            while (n8 < n7) {
                adminAreaArray3[n6] = adminAreaArray[n8];
                ++n8;
                ++n6;
            }
            map.put(string, adminAreaArray3);
        }
    }

    public static List<String[]> processAreas(Map<String, AdminArea[]> map) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(4000);
        int n = 0;
        String[] stringArray = new String[2];
        Set<String> set = map.keySet();
        int n2 = set.size();
        Object[] objectArray = set.toArray(new String[n2]);
        Arrays.sort(objectArray);
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray[n3];
            int n4 = n3 + 1;
            while (n4 < n2) {
                boolean bl;
                if (((String)object).contains("ALB") && ((String)objectArray[n4]).contains("GRC")) {
                    NeighborUtility.debug((String)object);
                }
                if (bl = NeighborUtility.isNeighbor(map, map, (String)object, (String)objectArray[n4])) {
                    ++c_Neighbors;
                    NeighborUtility.debug(String.valueOf(++n) + " = " + (String)object + ", " + (String)objectArray[n4] + ", 0");
                    stringArray = new String[]{object, objectArray[n4]};
                    arrayList.add(stringArray);
                }
                ++n4;
            }
            ++n3;
        }
        return arrayList;
    }

    public static List<String[]> matchArea(Map<String, AdminArea[]> map, Map<String, AdminArea[]> map2) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(4000);
        int n = 0;
        String[] stringArray = null;
        Set<String> set = map.keySet();
        int n2 = set.size();
        Object[] objectArray = set.toArray(new String[n2]);
        Arrays.sort(objectArray);
        Set<String> set2 = map2.keySet();
        int n3 = set2.size();
        Object[] objectArray2 = set2.toArray(new String[n3]);
        Arrays.sort(objectArray2);
        int n4 = 0;
        while (n4 < n2) {
            Object object = objectArray[n4];
            int n5 = 0;
            while (n5 < n3) {
                Object object2 = objectArray2[n5];
                boolean bl = NeighborUtility.isNeighbor(map, map2, (String)object, (String)object2);
                if (bl) {
                    ++c_Neighbors;
                    ++n;
                    NeighborUtility.debug("isNeighbor match: " + (String)object + " " + (String)object2);
                    stringArray = new String[]{object, object2};
                    arrayList.add(stringArray);
                }
                ++n5;
            }
            ++n4;
        }
        return arrayList;
    }

    private static Polygon[] getPolygons(LatLong latLong) {
        List list = latLong.getSegments();
        int n = list.size();
        Polygon[] polygonArray = new Polygon[n];
        int n2 = 0;
        while (n2 < n) {
            Polygon polygon;
            LatLong.Segment segment = (LatLong.Segment)list.get(n2);
            polygonArray[n2] = polygon = NeighborUtility.getPolygon(segment);
            ++n2;
        }
        return polygonArray;
    }

    private static Polygon getPolygon(LatLong.Segment segment) {
        Polygon polygon = new Polygon();
        int n = segment.size();
        int n2 = 0;
        while (n2 < n) {
            double d = segment.longitude(n2);
            double d2 = segment.latitude(n2);
            int n3 = (int)((d + 180.0) * 1000.0);
            int n4 = (int)((d2 + 90.0) * 1000.0);
            polygon.addPoint(n3, n4);
            ++n2;
        }
        return polygon;
    }

    private static boolean isNeighbor(Map<String, AdminArea[]> map, Map<String, AdminArea[]> map2, String string, String string2) {
        boolean bl = false;
        AdminArea[] adminAreaArray = map.get(string);
        AdminArea[] adminAreaArray2 = map2.get(string2);
        AdminArea[] adminAreaArray3 = adminAreaArray;
        int n = adminAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            AdminArea adminArea = adminAreaArray3[n2];
            AdminArea[] adminAreaArray4 = adminAreaArray2;
            int n3 = adminAreaArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                AdminArea adminArea2 = adminAreaArray4[n4];
                if (string.contains("ALB") && string2.contains("GRC")) {
                    NeighborUtility.debug(String.valueOf(string) + " : " + string2);
                }
                if (bl = NeighborUtility.testAdjacency(adminArea, adminArea2)) {
                    ++c_bboxNeighbors;
                    if (bboxCheckOnly) {
                        return true;
                    }
                    bl = NeighborUtility.testAdjacencyMatch(adminArea, adminArea2);
                    if (!bl) {
                        bl = NeighborUtility.testAdjacencyContains(adminArea, adminArea2);
                        if (bl) {
                            ++c_segmentNeighbors;
                            NeighborUtility.debug("*Border containment Match: " + string + " : " + string2);
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return bl;
    }

    public static boolean testAdjacency(AdminArea adminArea, AdminArea adminArea2) {
        Rectangle rectangle = adminArea.bbox;
        Rectangle rectangle2 = adminArea2.bbox;
        double d = rectangle.getMinX();
        double d2 = rectangle.getMaxX();
        double d3 = rectangle.getMinY();
        double d4 = rectangle.getMaxY();
        boolean bl = true;
        if (!(rectangle2.contains(d, d3) || rectangle2.contains(d, d4) || rectangle2.contains(d2, d4) || rectangle2.contains(d2, d3))) {
            bl = false;
        }
        if (!bl) {
            double d5 = rectangle2.getMinX();
            double d6 = rectangle2.getMaxX();
            double d7 = rectangle2.getMinY();
            double d8 = rectangle2.getMaxY();
            bl = true;
            if (!(rectangle.contains(d5, d7) || rectangle.contains(d5, d8) || rectangle.contains(d6, d8) || rectangle.contains(d6, d7))) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean testAdjacencyMatch(AdminArea adminArea, AdminArea adminArea2) {
        int n;
        double d;
        double d2;
        boolean bl = false;
        LatLong.Segment segment = adminArea.segment;
        LatLong.Segment segment2 = adminArea2.segment;
        String string = adminArea.name;
        String string2 = adminArea2.name;
        int n2 = segment.size();
        int n3 = segment2.size();
        int n4 = 0;
        while (n4 < n2) {
            d2 = segment.latitude(n4);
            d = segment.longitude(n4);
            n = 0;
            while (n < n3) {
                if (d2 == segment2.latitude(n) && d == segment2.longitude(n)) {
                    ++c_pointNeighbors;
                    NeighborUtility.debug("*Border point Match: " + string + " : " + string2);
                    bl = true;
                    return true;
                }
                ++n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            d2 = Math.abs(segment.latitude(n4));
            d = Math.abs(segment.longitude(n4));
            n = 0;
            while (n < n3) {
                if (NeighborUtility.closeTo(d2, d, Math.abs(segment2.latitude(n)), Math.abs(segment2.longitude(n)))) {
                    NeighborUtility.debug(" closeTo match point: " + string + " : " + string2);
                    ++c_closeNeighbors;
                    NeighborUtility.debug(String.format("%f %f %f %f", segment.latitude(n4), segment.longitude(n4), segment2.latitude(n), segment2.longitude(n)));
                    return true;
                }
                ++n;
            }
            ++n4;
        }
        return bl;
    }

    public static boolean closeTo(double d, double d2, double d3, double d4) {
        return d <= d3 + 0.01 && d >= d3 - 0.01 && d2 <= d4 + 0.01 && d2 >= d4 - 0.01;
    }

    public static boolean testAdjacencyContains(AdminArea adminArea, AdminArea adminArea2) {
        double d;
        double d2;
        boolean bl = false;
        LatLong.Segment segment = adminArea.segment;
        LatLong.Segment segment2 = adminArea2.segment;
        String string = adminArea.name;
        String string2 = adminArea2.name;
        int n = segment.size();
        int n2 = segment2.size();
        Polygon polygon = NeighborUtility.getPolygon(segment2);
        int n3 = 0;
        while (n3 < n) {
            double d3;
            d2 = segment.latitude(n3);
            d = segment.longitude(n3);
            double d4 = (d + 180.0) * 1000.0;
            bl = polygon.contains(d4, d3 = (d2 + 90.0) * 1000.0);
            if (bl) {
                NeighborUtility.debug(" segment2 contains point " + n3 + " " + string + " : " + string2);
                bl = true;
                return true;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            double d5;
            double d6;
            d2 = segment2.latitude(n3);
            d = segment2.longitude(n3);
            Polygon polygon2 = NeighborUtility.getPolygon(segment);
            bl = polygon2.contains(d6 = (d + 180.0) * 1000.0, d5 = (d2 + 90.0) * 1000.0);
            if (bl) {
                NeighborUtility.debug(" segment1 contains point " + n3 + " " + string + " : " + string2);
                bl = true;
                return true;
            }
            ++n3;
        }
        return bl;
    }

    public static String getPropertyFolder() {
        String string = null;
        try {
            File file = File.createTempFile("test", ".txt");
            string = file.getParent();
            file.delete();
            string = String.valueOf(string) + "/commonborder/";
        }
        catch (IOException iOException) {
            NeighborUtility.debug("Unable to determine tmp folder for property files.");
            NeighborUtility.debug(iOException.getMessage());
        }
        return string;
    }

    public static void statistics() {
        long l = new Date().getTime() - c_start;
        System.out.println("* Neighbor Areas based on BoundingBox:     " + c_bboxNeighbors);
        System.out.println("* Neighbor Areas based on Matching points: " + c_pointNeighbors);
        System.out.println("* Neighbor Areas based on very close Matching points: " + c_closeNeighbors);
        System.out.println("* Neighbor Areas based on containment:     " + c_segmentNeighbors);
        System.out.println("* Final count of Neighbor Areas:            " + c_Neighbors);
        System.out.println("* Elapsed time: " + l);
        c_bboxNeighbors = 0;
        c_pointNeighbors = 0;
        c_closeNeighbors = 0;
        c_segmentNeighbors = 0;
        c_Neighbors = 0;
        c_start = new Date().getTime();
    }

    public static void debug(String string) {
        if (DEBUG) {
            System.out.println(String.valueOf(NeighborUtility.getClock()) + " " + string);
        }
    }

    public static void output(String string) {
        System.out.println(String.valueOf(NeighborUtility.getClock()) + " " + string);
    }

    public static void debug(String string, Throwable throwable) {
        NeighborUtility.debug(string);
        throwable.printStackTrace();
    }

    private static String getClock() {
        long l = new Date().getTime() - start;
        return Long.toString(l);
    }

    public static class AdminArea {
        String name = null;
        Rectangle bbox = null;
        LatLong.Segment segment = null;

        public AdminArea(LatLong.Segment segment, Rectangle rectangle, String string) {
            this.name = string;
            this.bbox = rectangle;
            this.segment = segment;
        }
    }
}

