/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.utility;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;
import org.eclipse.stem.internal.data.utility.NeighborUtility;

public class NeighborUtilityTest
extends TestCase {
    protected LatLongDataProvider fixture;

    protected void setUp() {
        this.setFixture((LatLongDataProvider)new PlatformLatLongDataProvider());
        System.out.println("NeighborUtilityTest: baseFolder=" + NeighborUtility.baseFolder);
        System.out.println("NeighborUtilityTest: outputFolder=" + NeighborUtility.getPropertyFolder());
    }

    protected void tearDown() {
        this.setFixture(null);
    }

    private PlatformLatLongDataProvider getFixture() {
        return (PlatformLatLongDataProvider)this.fixture;
    }

    protected final void setFixture(LatLongDataProvider latLongDataProvider) {
        this.fixture = latLongDataProvider;
    }

    public void testRun() {
        try {
            NeighborUtility.DEBUG = false;
            System.out.println("tstDoAllInternal");
            this.tstDoAllInternal();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void tstInternalNeighbors(String string) {
        PlatformLatLongDataProvider platformLatLongDataProvider = this.getFixture();
        String string2 = NeighborUtility.getAdmin(string);
        System.out.println(String.valueOf(string) + ":" + string2);
        List<String[]> list = NeighborUtility.neighborCheck(platformLatLongDataProvider, string, string2);
        NeighborUtility.writeProperties(list, string, string2, string, string2);
        NeighborUtility.statistics();
    }

    public void tstNeighbors2(String string, String string2) {
        PlatformLatLongDataProvider platformLatLongDataProvider = this.getFixture();
        String string3 = NeighborUtility.getAdmin(string);
        String string4 = NeighborUtility.getAdmin(string2);
        System.out.println(String.valueOf(string) + ":" + string3 + " - " + string2 + ":" + string4);
        List<String[]> list = NeighborUtility.neighborCheck(platformLatLongDataProvider, string, string3, string2, string4);
        NeighborUtility.writeProperties(list, string, string3, string2, string4);
        NeighborUtility.statistics();
    }

    public void tstDoWorld(boolean bl) {
        PlatformLatLongDataProvider platformLatLongDataProvider = this.getFixture();
        List<String[]> list = NeighborUtility.doWorld(platformLatLongDataProvider, bl);
        if (bl) {
            NeighborUtility.doAllBorders(platformLatLongDataProvider, list);
        }
    }

    public void tstDoAllInternal() {
        PlatformLatLongDataProvider platformLatLongDataProvider = this.getFixture();
        NeighborUtility.doAllInternal(platformLatLongDataProvider);
    }

    public void tstDoAllBorders() {
        PlatformLatLongDataProvider platformLatLongDataProvider = this.getFixture();
        NeighborUtility.doAllBorders(platformLatLongDataProvider);
    }
}

