/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.utility;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.graphics.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonCenterGenerator {
    private static final String GML_ID = "gml:id";
    private static final String POLYGON = "gml:Polygon";
    private static final String BOUNDARY = "gml:outerBoundaryIs";
    private static final String LINEARRING = "gml:LinearRing";
    private static final String POSLIST = "gml:posList";
    private static final String MAP_FILE_SUFFIX = "_MAP.xml";
    private static final double RESCALE = 1000000.0;
    private static boolean DO_SINGLE_COUNTRY = false;
    private static final String SINGLE_COUNTRY = "ITA/";
    public static final String GEO_FOLDER = "../org.eclipse.stem.data.geography/resources/data/geo/country/";
    public static final String OUTPUT_FOLDER = "./resources/data/country/";

    public static void main(String[] stringArray) {
        PolygonCenterGenerator.discoverCenters();
    }

    public static final void discoverCenters() {
        try {
            File file = new File(GEO_FOLDER);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (DO_SINGLE_COUNTRY) {
                    fileArray = new File[]{new File("../org.eclipse.stem.data.geography/resources/data/geo/country/ITA/")};
                }
                int n = 0;
                while (n < fileArray.length) {
                    File file2 = fileArray[n];
                    String string = file2.getName();
                    HashMap<String, Point> hashMap = new HashMap<String, Point>();
                    if (!(string.equalsIgnoreCase("ZZZ") && string.equalsIgnoreCase("CVS") || !file2.isDirectory())) {
                        File[] fileArray2 = file2.listFiles();
                        int n2 = 0;
                        while (n2 < fileArray2.length) {
                            File file3 = fileArray2[n2];
                            String string2 = file3.getName();
                            int n3 = string2.indexOf(MAP_FILE_SUFFIX);
                            if (n3 >= 1) {
                                PolygonCenterGenerator.addPolygonCentersGML(file3, hashMap);
                            }
                            ++n2;
                        }
                        PolygonCenterGenerator.writeCenters(hashMap, string);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(" IOException error!" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void addPolygonCentersGML(File file, Map<String, Point> map) {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(file);
        }
        catch (Exception exception) {
            System.out.println("Error parsing file " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        object = document.getDocumentElement();
        NodeList nodeList = object.getElementsByTagName(POLYGON);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = element.getAttribute(GML_ID);
            Polygon polygon = null;
            double d = -1.0;
            NodeList nodeList2 = element.getElementsByTagName(BOUNDARY);
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Element element2 = (Element)nodeList2.item(n2);
                NodeList nodeList3 = element2.getElementsByTagName(LINEARRING);
                int n3 = 0;
                while (n3 < nodeList3.getLength()) {
                    Element element3 = (Element)nodeList3.item(n3);
                    NodeList nodeList4 = element3.getElementsByTagName(POSLIST);
                    int n4 = 0;
                    while (n4 < nodeList4.getLength()) {
                        Node node;
                        String string2;
                        Polygon polygon2;
                        double d2;
                        Element element4 = (Element)nodeList4.item(n4);
                        if (element4 != null && (d2 = Math.abs(PolygonCenterGenerator.getArea(polygon2 = PolygonCenterGenerator.getPolygon(string2 = (node = element4.getFirstChild()).getTextContent())))) >= d) {
                            d = d2;
                            polygon = new Polygon(polygon2.xpoints, polygon2.ypoints, polygon2.npoints);
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            Point point = PolygonCenterGenerator.getInteriorCentroid(polygon);
            map.put(string, point);
            ++n;
        }
        System.out.println("Read " + map.size() + " polygons in file ");
    }

    public static Polygon getPolygon(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            arrayList.add(new Double(string2));
            arrayList2.add(new Double((String)object));
        }
        if (arrayList.get(arrayList.size() - 1) != arrayList.get(0) || arrayList2.get(arrayList2.size() - 1) != arrayList2.get(0)) {
            arrayList.add((Double)arrayList.get(0));
            arrayList2.add((Double)arrayList2.get(0));
        }
        int n = arrayList.size();
        object = new int[n];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = (int)(1000000.0 * (Double)arrayList.get(n2));
            nArray[n2] = (int)(1000000.0 * (Double)arrayList2.get(n2));
            ++n2;
        }
        return new Polygon((int[])object, nArray, n);
    }

    public static double getArea(Polygon polygon) {
        double d = 0.0;
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        int n = 0;
        while (n < nArray.length - 1) {
            d += (double)nArray[n] * (double)nArray2[n + 1] - (double)nArray[n + 1] * (double)nArray2[n];
            ++n;
        }
        return d /= 2.0;
    }

    public static Point getInteriorCentroid(Polygon polygon) {
        int n;
        double d = -1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Rectangle rectangle = polygon.getBounds();
        double d4 = Math.abs((double)rectangle.width);
        double d5 = Math.abs((double)rectangle.height);
        d4 /= 100.0;
        d5 /= 100.0;
        double d6 = rectangle.getMinX();
        double d7 = rectangle.getMinY();
        int n2 = 0;
        while (n2 <= 100) {
            d7 = rectangle.getMinY();
            int n3 = 0;
            while (n3 <= 100) {
                double d8;
                if (polygon.contains(d6, d7) && (d8 = PolygonCenterGenerator.getSqrdEdgeRange(d6, d7, polygon)) >= d) {
                    d = d8;
                    d2 = d6;
                    d3 = d7;
                }
                d7 += d5;
                ++n3;
            }
            d6 += d4;
            ++n2;
        }
        d6 = d2 - d4;
        double d9 = d7 = d3 - d5;
        d4 /= 100.0;
        d5 /= 100.0;
        int n4 = 0;
        while (n4 <= 200) {
            d7 = d9;
            n = 0;
            while (n <= 200) {
                double d10;
                if (polygon.contains(d6, d7) && (d10 = PolygonCenterGenerator.getSqrdEdgeRange(d6, d7, polygon)) >= d) {
                    d = d10;
                    d2 = d6;
                    d3 = d7;
                }
                d7 += d5;
                ++n;
            }
            d6 += d4;
            ++n4;
        }
        n4 = (int)Math.round(d2);
        n = (int)Math.round(d3);
        Point point = new Point(n4, n);
        return point;
    }

    public static void printMap(Map<String, Point> map) {
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            Point point = map.get(string);
            System.out.println("id: " + string + " " + point.x + ", " + point.y);
        }
    }

    public static void writeCenters(Map<String, Point> map, String string) {
        File file = new File(OUTPUT_FOLDER + string + "/" + string + "_centers.properties");
        try {
            System.out.println("writing centers " + file.getName() + " = " + file.getAbsolutePath());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("# " + string + "_centers.properties \n");
            fileWriter.write("# all regions centers (id, lat, long) \n");
            fileWriter.write("\n");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            Iterator<String> iterator = map.keySet().iterator();
            int n = 0;
            while (iterator != null && iterator.hasNext()) {
                ++n;
                String string2 = iterator.next();
                if (string2.indexOf("-") == -1) {
                    arrayList.add(string2);
                    continue;
                }
                int n2 = string2.indexOf("-");
                String string3 = string2.substring(n2 + 1, string2.length());
                if (string3.indexOf("-") == -1) {
                    arrayList2.add(string2);
                    continue;
                }
                arrayList3.add(string2);
            }
            fileWriter.write("# level 0 \n");
            if (arrayList.size() >= 1) {
                PolygonCenterGenerator.writeLevelData(arrayList, map, fileWriter);
            }
            fileWriter.write("\n");
            fileWriter.write("# level 1 \n");
            if (arrayList2.size() >= 1) {
                PolygonCenterGenerator.writeLevelData(arrayList2, map, fileWriter);
            }
            fileWriter.write("\n");
            fileWriter.write("# level 2 \n");
            if (arrayList3.size() >= 1) {
                PolygonCenterGenerator.writeLevelData(arrayList3, map, fileWriter);
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("error writing file" + iOException.getMessage());
            System.exit(1);
        }
    }

    public static void writeLevelData(List<String> list, Map<String, Point> map, FileWriter fileWriter) {
        Object[] objectArray = new String[list.size()];
        int n = 0;
        while (n < list.size()) {
            objectArray[n] = list.get(n);
            ++n;
        }
        Arrays.sort(objectArray);
        try {
            n = 0;
            while (n < list.size()) {
                Point point = map.get(objectArray[n]);
                double d = point.x;
                double d2 = point.y;
                fileWriter.write(String.valueOf(objectArray[n]) + " = " + (d /= 1000000.0) + ", " + (d2 /= 1000000.0) + "\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("error writing file" + iOException.getMessage());
            System.exit(1);
        }
    }

    public static double getSqrdEdgeRange(double d, double d2, Polygon polygon) {
        double d3 = Double.MAX_VALUE;
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        int n = 0;
        while (n < nArray.length) {
            double d4 = nArray[n];
            double d5 = d - d4;
            double d6 = nArray2[n];
            double d7 = d2 - d6;
            double d8 = d5 * d5 + d7 * d7;
            if (d8 <= d3) {
                d3 = d8;
            }
            ++n;
        }
        return d3;
    }
}

