/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.presentation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.solvers.rk.presentation.RkEditorPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RkActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(RkEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                RkActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException partInitException) {
                RkEditorPlugin.INSTANCE.log((Object)partInitException);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(RkEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return RkActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (RkActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)RkActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public RkActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator("rk-settings"));
        iToolBarManager.add((IContributionItem)new Separator("rk-additions"));
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        MenuManager menuManager = new MenuManager(RkEditorPlugin.INSTANCE.getString("_UI_RkEditor_menu"), "org.eclipse.stem.solvers.rkMenuID");
        iMenuManager.insertAfter("additions", (IContributionItem)menuManager);
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new Separator("actions"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(RkEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        menuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(RkEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        menuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)menuManager);
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        this.activeEditorPart = iEditorPart;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (iEditorPart == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = iEditorPart.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection collection = null;
        Collection collection2 = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            collection = editingDomain.getNewChildDescriptors(object, null);
            collection2 = editingDomain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(collection, iSelection);
        this.createSiblingActions = this.generateCreateSiblingActions(collection2, iSelection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> collection, ISelection iSelection) {
        ArrayList<IAction> arrayList = new ArrayList<IAction>();
        if (collection != null) {
            for (Object obj : collection) {
                arrayList.add((IAction)new CreateChildAction(this.activeEditorPart, iSelection, obj));
            }
        }
        return arrayList;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> collection, ISelection iSelection) {
        ArrayList<IAction> arrayList = new ArrayList<IAction>();
        if (collection != null) {
            for (Object obj : collection) {
                arrayList.add((IAction)new CreateSiblingAction(this.activeEditorPart, iSelection, obj));
            }
        }
        return arrayList;
    }

    protected void populateManager(IContributionManager iContributionManager, Collection<? extends IAction> collection, String string) {
        if (collection != null) {
            for (IAction iAction : collection) {
                if (string != null) {
                    iContributionManager.insertBefore(string, iAction);
                    continue;
                }
                iContributionManager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager iContributionManager, Collection<? extends IAction> collection) {
        if (collection != null) {
            IContributionItem[] iContributionItemArray = iContributionManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IAction iAction;
                IContributionItem iContributionItem = iContributionItemArray[n];
                while (iContributionItem instanceof SubContributionItem) {
                    iContributionItem = ((SubContributionItem)iContributionItem).getInnerItem();
                }
                if (iContributionItem instanceof ActionContributionItem && collection.contains(iAction = ((ActionContributionItem)iContributionItem).getAction())) {
                    iContributionManager.remove(iContributionItem);
                }
                ++n;
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        super.menuAboutToShow(iMenuManager);
        MenuManager menuManager = null;
        menuManager = new MenuManager(RkEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)menuManager, this.createChildActions, null);
        iMenuManager.insertBefore("edit", (IContributionItem)menuManager);
        menuManager = new MenuManager(RkEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)menuManager, this.createSiblingActions, null);
        iMenuManager.insertBefore("edit", (IContributionItem)menuManager);
    }

    protected void addGlobalActions(IMenuManager iMenuManager) {
        iMenuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        iMenuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        iMenuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(iMenuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

