/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.data.geography;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.stem.data.geography.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeographicMapper {
    public static final String EARTH_ALPHA3_ISO_KEY = "ZZZ";
    public static final String ALPHA2_TO_ALPHA3_NAME = "level0ISOKeys.properties";
    private static final URI LEVEL_0_ISO_MAPPING_FILE_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/country/ZZZ/level0ISOKeys.properties");
    protected static final String RB_PREFIX = "org.eclipse.stem.data.geography";
    private static Properties alpha2ToAlpha3Map = null;
    private static Properties alpha3ToAlpha2Map = null;

    protected static Properties readPropertyFiles(URI uRI) {
        URIConverterImpl uRIConverterImpl = new URIConverterImpl();
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRIConverterImpl.createInputStream(uRI));
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Activator.logError(EARTH_ALPHA3_ISO_KEY, fileNotFoundException);
        }
        catch (IOException iOException) {
            Activator.logError(EARTH_ALPHA3_ISO_KEY, iOException);
        }
        return properties;
    }

    protected static int keyLevel(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("-");
        while (n3 > 0) {
            ++n;
            n3 = string.substring(n2 += n3 + 1).indexOf("-");
        }
        return n;
    }

    protected static Properties getAlpha2ToAlpha3Map() {
        if (alpha2ToAlpha3Map == null) {
            alpha2ToAlpha3Map = GeographicMapper.readPropertyFiles(LEVEL_0_ISO_MAPPING_FILE_URI);
        }
        if (alpha2ToAlpha3Map == null) {
            Activator.logError("Can't read the alpha2 to alpha3 mapping file \"level0ISOKeys.properties\"", null);
        }
        return alpha2ToAlpha3Map;
    }

    public static String getAlpha3(String string) {
        String string2 = string;
        Properties properties = GeographicMapper.getAlpha2ToAlpha3Map();
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    public static String getAlpha2(String string) {
        String string2 = string;
        Properties properties = GeographicMapper.getAlpha3toAlpha2Map();
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    private static Properties getAlpha3toAlpha2Map() {
        Properties properties;
        if (alpha3ToAlpha2Map == null && (properties = GeographicMapper.getAlpha2ToAlpha3Map()) != null) {
            alpha3ToAlpha2Map = new Properties();
            for (Object object : properties.keySet()) {
                alpha3ToAlpha2Map.put(properties.get(object), object);
            }
        }
        return alpha3ToAlpha2Map;
    }

    protected static String makeBundleName(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(".");
        stringBuilder.append(string);
        stringBuilder.append("_");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    protected static ResourceBundle readResourceBundle(String string, String string2, String string3) {
        ResourceBundle resourceBundle = null;
        Properties properties = GeographicMapper.getAlpha2ToAlpha3Map();
        if (properties != null) {
            String string4 = properties.getProperty(string);
            resourceBundle = ResourceBundle.getBundle(GeographicMapper.makeBundleName(string4, string2, string3));
        }
        return resourceBundle;
    }

    protected static ResourceBundle getResourceBundle(String string, int n, String string2, String string3, String string4, ResourceBundle resourceBundle, Map<String, ResourceBundle> map) {
        ResourceBundle resourceBundle2 = null;
        if (n == -1 || n == 0) {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(string4);
            }
            resourceBundle2 = resourceBundle;
        } else {
            String string5 = string.substring(0, 2);
            resourceBundle2 = map.get(string5);
            if (resourceBundle2 == null) {
                resourceBundle2 = GeographicMapper.readResourceBundle(string5, string2, string3);
                if (resourceBundle2 == null) {
                    Activator.logError("Could not read Resource Bundle of type " + string3 + " for \"" + string5 + "\"", null);
                } else {
                    map.put(string5, resourceBundle2);
                }
            }
        }
        return resourceBundle2;
    }
}

