/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

// Functions to update the nodes of a dynamic tree based
// on an XML dom. 

var selectedNode;
var highlightSelectedNode;

function updateTree(xml) { 
    var tocData = xml.documentElement;  
    if (tocData.tagName != "tree_data") {
        return;
    }      
    showErrors(xml);    
    var treeRoot = document.getElementById("tree_root");
    var nodes = tocData.childNodes;
    selectedNode = null;
    mergeChildren(treeRoot, nodes);
    if (selectedNode != null) {
        // Focusing on the last child will increase the chance that it is visible
        if (!highlightSelectedNode) {
            focusOnDeepestVisibleChild(selectedNode, false);
        }
        focusOnItem(selectedNode, highlightSelectedNode);
    }
 }
 
 function showErrors(xml) {
    var errorTags = xml.getElementsByTagName ("error");
    
    for (var i = 0; i < errorTags.length; i++) {
         var nextError = errorTags[i];
         var errorChildren = nextError.childNodes;
         // Is the next node a text node
         if (errorChildren.length > 0 && errorChildren[0].nodeType == 3) { 
             var message = errorChildren[0].data;
             alert(message);
         }
    }
    return errorTags.length > 0;
 }
 
function mergeChildren(treeItem, nodes) {
    var childContainer;
    if (treeItem.id == "tree_root") {
        childContainer=treeItem;
    } else {
        childContainer = findChild(treeItem, "DIV");
    }
    var childAdded = false;
    var hasPlaceholder = childContainer != null && childContainer.className == "unopened";
    if (nodes) {  
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            if (node.tagName == "node") {
                if (hasPlaceholder) {
                    // Remove the loading message
                    treeItem.removeChild(childContainer);
                    hasPlaceholder = false;
                    childContainer = null;
                }
                if (childContainer === null) {
                    childContainer = document.createElement("DIV");
                    childContainer.className = "group";              
                    setAccessibilityRole(childContainer, WAI_GROUP);
                    treeItem.appendChild(childContainer);
                }
                var title = node.getAttribute("title");
                var isLeaf = node.getAttribute("is_leaf");
                var href = node.getAttribute("href");
                var id = node.getAttribute("id");
                var openImage = null;                
                var closedImage = null; 
                var imageAltText = "";
                if (node.getAttribute("openImage")) {
                    openImage = "../topic" + node.getAttribute("openImage");
                    imageAltText = node.getAttribute("imageAlt");
                } else {
                    openImage = node.getAttribute("image");
                    if (openImage) {
                        imageAltText = getAltText(openImage);
                        openImage = imagesDirectory + "/" + openImage + ".gif";
                    }
                }              
                if (node.getAttribute("closedImage")) {
                    closedImage = "../topic" + node.getAttribute("closedImage");
                }
                var childItem = mergeChild(childContainer, id, title, href, openImage, closedImage, imageAltText, isLeaf);
                var isSelected = node.getAttribute("is_selected");
                if (!isLeaf) {
                    mergeChildren(childItem, node.childNodes);
                }
                if (isSelected) {
                    selectedNode = childItem;
                    highlightSelectedNode = node.getAttribute("is_highlighted");
                }
                childAdded = true;
            } 
        }   
     }

     if (childAdded) {
         // Expand this node if it was collapsed and has children in the xml tree        
        var childClass = getChildClass(treeItem);
        if (childClass == "hidden") {
            toggleExpandState(treeItem);
        } else {
            changeExpanderImage(treeItem, true); 
            setWAIExpansionState(treeItem, true);
        }
     }  
}

// Create a child if one with this if does not exist  
function mergeChild(treeItem, id, name, href, image, closedImage, imageAltText, isLeaf) {  
    var children = treeItem.childNodes;
    if (children !== null) {
        for (var i = 0; i < children.length; i++) {
            if (children[i].nodeid == id ) {
                return children[i];
            }
        }
    }
        
    var childItem = document.createElement("DIV");
    // roots should have a className of "root" to prevent indentation
    if (treeItem.id == "tree_root") {
        childItem.className = "root";
    } else {
        childItem.className = "visible"; 
    }
    childItem.nodeid = id;
    treeItem.appendChild(childItem);
    
    // Create a span to prevent line breaking
    var container = document.createElement("SPAN");
    container.className = "item";
    childItem.appendChild(container);
   
    var topicImage;
    if (image) {
        topicImage = document.createElement("IMG");
        //setImage(topicImage, image); 
        if (closedImage) {          
            topicImage.src = closedImage;
            topicImage.openImage = image;
            topicImage.closedImage = closedImage;
        } else {
            topicImage.src = image;
        }
        topicImage.alt = imageAltText;
    } 
    
    var topicName=document.createTextNode(name);
    
    if (showExpanders) {
        var plusMinusImage= document.createElement("IMG");
        plusMinusImage.className = "expander";
        setImage(plusMinusImage, "plus");
        if (isLeaf) {
            plusMinusImage.className = "h";
            plusMinusImage.alt = "";
        }
        container.appendChild(plusMinusImage);
    }
      
    var anchor = document.createElement("a");
    if (href === null) {
        // anchor.href = "about:blank";
        anchor.className = "nolink";
    } else {
        anchor.href = href;
    }
    anchor.title = name;
    setAccessibilityRole(anchor, WAI_TREEITEM);
    
    if (topicImage) {
        anchor.appendChild(topicImage);
    }
    anchor.appendChild(topicName);
    container.appendChild(anchor);
    
    if (!isLeaf) {
        var innerDiv = document.createElement("DIV");  
        innerDiv.className = "unopened";
        setWAIExpansionState(anchor, false);
        childItem.appendChild(innerDiv);
    }
    return childItem;
}

function setLoadingMessage(treeItem, message) {   
    var placeholderDiv = findChild(treeItem, "DIV");
    if (placeholderDiv !== null && placeholderDiv.childNodes.length == 0) {      
        var msg = document.createTextNode(message);
        placeholderDiv.appendChild(msg);
    }
}
