/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.target.ExternalFileTargetHandle;
import org.eclipse.pde.internal.core.target.LocalTargetHandle;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.AddToJavaSearchJob;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationContentProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationLabelProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetStatus;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.target.EditTargetDefinitionWizard;
import org.eclipse.pde.internal.ui.wizards.target.MoveTargetDefinitionWizard;
import org.eclipse.pde.internal.ui.wizards.target.NewTargetDefinitionWizard2;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class TargetPlatformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.pde.ui.TargetPlatformPreferencePage";
    private static final String ORG_ECLIPSE_OSGI = "org.eclipse.osgi";
    private static final String DATA_KEY_MOVED_LOCATION = "movedLocation";
    private CheckboxTableViewer fTableViewer;
    private Button fReloadButton;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fMoveButton;
    private TreeViewer fDetails;
    private List<ITargetDefinition> fTargets = new ArrayList<ITargetDefinition>();
    private List<ITargetDefinition> fRemoved = new ArrayList<ITargetDefinition>();
    private Map<Object, Object> fMoved = new HashMap<Object, Object>(1);
    private ITargetDefinition fActiveTarget;
    private ITargetDefinition fPrevious;
    private boolean isOutOfSynch = false;

    public Control createContents(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.createTargetProfilesGroup(container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.target_platform_preference_page");
        return container;
    }

    private void createTargetProfilesGroup(Composite container) {
        Composite comp = SWTFactory.createComposite(container, 1, 1, 1808, 0, 0);
        ((GridData)comp.getLayoutData()).widthHint = 350;
        SWTFactory.createWrapLabel(comp, PDEUIMessages.TargetPlatformPreferencePage2_0, 2);
        SWTFactory.createVerticalSpacer(comp, 1);
        Composite tableComposite = SWTFactory.createComposite(comp, 2, 1, 1808, 0, 0);
        SWTFactory.createLabel(tableComposite, PDEUIMessages.TargetPlatformPreferencePage2_2, 2);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2050);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fTableViewer.getControl().setLayoutData((Object)gd);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TargetLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    TargetPlatformPreferencePage.this.fTableViewer.setCheckedElements(new Object[]{event.getElement()});
                    TargetPlatformPreferencePage.this.handleActivate();
                } else {
                    TargetPlatformPreferencePage.this.handleActivate();
                }
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetPlatformPreferencePage.this.updateButtons();
                TargetPlatformPreferencePage.this.updateDetails();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TargetPlatformPreferencePage.this.handleEdit();
            }
        });
        this.fTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    TargetPlatformPreferencePage.this.handleRemove();
                }
            }
        });
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetHandle[] targets = service.getTargets(null);
            int i = 0;
            while (i < targets.length) {
                try {
                    this.fTargets.add(targets[i].getTargetDefinition());
                }
                catch (CoreException e) {
                    PDECore.log((Throwable)e);
                    this.setErrorMessage(e.getMessage());
                }
                ++i;
            }
            this.fTableViewer.setInput(this.fTargets);
        }
        this.fTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = ((TargetDefinition)e1).getName();
                String name2 = ((TargetDefinition)e2).getName();
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        Composite buttonComposite = SWTFactory.createComposite(tableComposite, 1, 1, 1042, 0, 0);
        this.fReloadButton = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.TargetPlatformPreferencePage2_16, null);
        this.fReloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleReload();
            }
        });
        SWTFactory.createVerticalSpacer(buttonComposite, 1);
        this.fAddButton = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.TargetPlatformPreferencePage2_3, null);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleAdd();
            }
        });
        this.fEditButton = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.TargetPlatformPreferencePage2_5, null);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleEdit();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.TargetPlatformPreferencePage2_7, null);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleRemove();
            }
        });
        this.fMoveButton = SWTFactory.createPushButton(buttonComposite, PDEUIMessages.TargetPlatformPreferencePage2_13, null);
        this.fMoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleMove();
            }
        });
        this.updateButtons();
        Composite detailsComposite = SWTFactory.createComposite(comp, 1, 1, 768, 0, 0);
        SWTFactory.createLabel(detailsComposite, PDEUIMessages.TargetPlatformPreferencePage2_25, 1);
        this.fDetails = new TreeViewer(detailsComposite);
        this.fDetails.setLabelProvider((IBaseLabelProvider)new TargetLocationLabelProvider(true, true));
        this.fDetails.setContentProvider((IContentProvider)new TargetLocationContentProvider());
        gd = new GridData(768);
        gd.heightHint = 50;
        this.fDetails.getControl().setLayoutData((Object)gd);
        if (service != null) {
            try {
                this.fPrevious = service.getWorkspaceTargetDefinition();
                for (ITargetDefinition target : this.fTargets) {
                    if (!target.getHandle().equals(this.fPrevious.getHandle())) continue;
                    this.fActiveTarget = target;
                    this.fTableViewer.setCheckedElements(new Object[]{this.fActiveTarget});
                    this.fTableViewer.refresh((Object)target);
                    break;
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
                this.setErrorMessage(PDEUIMessages.TargetPlatformPreferencePage2_23);
            }
            if (this.getMessage() == null && this.fActiveTarget == null) {
                this.setMessage(PDEUIMessages.TargetPlatformPreferencePage2_22, 1);
            }
        }
    }

    private void handleActivate() {
        Object[] checked = this.fTableViewer.getCheckedElements();
        if (checked.length > 0) {
            this.fActiveTarget = (ITargetDefinition)checked[0];
            this.setMessage(null);
            this.fTableViewer.refresh(true);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fActiveTarget));
        } else {
            this.setMessage(PDEUIMessages.TargetPlatformPreferencePage2_22, 1);
            this.fActiveTarget = null;
            this.fTableViewer.refresh(true);
        }
    }

    private void handleReload() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.isOutOfSynch = false;
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(PDEUIMessages.TargetPlatformPreferencePage2_12);
                }
            };
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        TargetPlatformPreferencePage.this.fActiveTarget.resolve(monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                PDEPlugin.log(e);
                this.setErrorMessage(e.getMessage());
            }
            catch (InterruptedException interruptedException) {}
            if (this.fActiveTarget.isResolved()) {
                IStatus bundleStatus = this.fActiveTarget.getStatus();
                if (bundleStatus.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage2_14, (String)PDEUIMessages.TargetPlatformPreferencePage2_15, (IStatus)bundleStatus, (int)4);
                }
                try {
                    IStatus compare;
                    if (this.fPrevious != null && bundleStatus.getSeverity() != 4 && this.fActiveTarget.getHandle().equals(this.fPrevious.getHandle()) && ((TargetDefinition)this.fPrevious).isContentEquivalent(this.fActiveTarget) && !(compare = this.getTargetService().compareWithTargetPlatform(this.fActiveTarget)).isOK()) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage2_17, (String)PDEUIMessages.TargetPlatformPreferencePage2_18);
                        this.isOutOfSynch = true;
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                    this.setErrorMessage(e.getMessage());
                }
            }
            this.fTableViewer.refresh(true);
        }
    }

    private void handleAdd() {
        NewTargetDefinitionWizard2 wizard = new NewTargetDefinitionWizard2();
        wizard.setWindowTitle(PDEUIMessages.TargetPlatformPreferencePage2_4);
        WizardDialog dialog = new WizardDialog(this.fAddButton.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            ITargetDefinition def = wizard.getTargetDefinition();
            this.fTargets.add(def);
            if (this.fTargets.size() == 1) {
                this.fActiveTarget = def;
            }
            this.fTableViewer.refresh(true);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)def));
        }
    }

    private void handleEdit() {
        if (!this.fTableViewer.getSelection().isEmpty()) {
            ITargetDefinition original = (ITargetDefinition)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
            EditTargetDefinitionWizard wizard = new EditTargetDefinitionWizard(original, true);
            wizard.setWindowTitle(PDEUIMessages.TargetPlatformPreferencePage2_6);
            WizardDialog dialog = new WizardDialog(this.fEditButton.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                ITargetDefinition newTarget = wizard.getTargetDefinition();
                int index = this.fTargets.indexOf(original);
                this.fTargets.add(index, newTarget);
                this.fTargets.remove(original);
                if (this.fMoved.containsKey(original)) {
                    Object moveLocation = this.fMoved.remove(original);
                    this.fMoved.put(newTarget, moveLocation);
                }
                if (original == this.fActiveTarget) {
                    this.fActiveTarget = newTarget;
                }
                this.fTableViewer.refresh(true);
                if (this.fActiveTarget == newTarget) {
                    this.fTableViewer.setCheckedElements(new Object[]{newTarget});
                }
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newTarget));
            }
        }
    }

    private void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (!selection.isEmpty()) {
            PDEPreferencesManager preferences;
            String choice;
            List selected = selection.toList();
            boolean isWorkspace = false;
            for (ITargetDefinition currentTarget : selected) {
                if (!(currentTarget.getHandle() instanceof WorkspaceFileTargetHandle)) continue;
                isWorkspace = true;
                break;
            }
            if (isWorkspace && !"always".equalsIgnoreCase(choice = (preferences = new PDEPreferencesManager("org.eclipse.pde.ui")).getString("Preferences.MainPage.promptRemoveTarget"))) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage2_19, (String)PDEUIMessages.TargetPlatformPreferencePage2_20, (String)PDEUIMessages.TargetPlatformPreferencePage2_21, (boolean)false, (IPreferenceStore)PDEPlugin.getDefault().getPreferenceStore(), (String)"Preferences.MainPage.promptRemoveTarget");
                preferences.savePluginPreferences();
                if (dialog.getReturnCode() != 2) {
                    return;
                }
            }
            if (this.fActiveTarget != null && selected.contains(this.fActiveTarget)) {
                this.fActiveTarget = null;
                this.setMessage(PDEUIMessages.TargetPlatformPreferencePage2_22, 1);
            }
            this.fRemoved.addAll(selected);
            this.fTargets.removeAll(selected);
            this.fTableViewer.refresh(false);
            this.fTableViewer.refresh(true);
        }
    }

    private void handleMove() {
        MoveTargetDefinitionWizard wizard = new MoveTargetDefinitionWizard(this.fMoved.values());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
        if (dialog.open() == 0) {
            TableItem ti = this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex());
            IPath newTargetLoc = wizard.getTargetFileLocation();
            IFile file = PDECore.getWorkspace().getRoot().getFile(newTargetLoc);
            ti.setData(DATA_KEY_MOVED_LOCATION, (Object)file.getFullPath().toString());
            IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
            this.fMoved.put(selection.getFirstElement(), wizard.getTargetFileLocation());
            this.fTableViewer.refresh(true);
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int size = selection.size();
        this.fEditButton.setEnabled(size == 1);
        this.fRemoveButton.setEnabled(size > 0);
        if (selection.getFirstElement() != null) {
            this.fMoveButton.setEnabled(size == 1 && ((ITargetDefinition)selection.getFirstElement()).getHandle() instanceof LocalTargetHandle);
            this.fReloadButton.setEnabled((ITargetDefinition)selection.getFirstElement() == this.fActiveTarget && this.fActiveTarget.getHandle().equals(this.fPrevious != null ? this.fPrevious.getHandle() : null) && this.fTableViewer.getChecked((Object)this.fActiveTarget));
        } else {
            this.fMoveButton.setEnabled(false);
            this.fReloadButton.setEnabled(false);
        }
    }

    protected void updateDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            ITargetDefinition selected = (ITargetDefinition)selection.getFirstElement();
            if (!selected.isResolved() && this.fPrevious != null && selected.getHandle().equals(this.fPrevious.getHandle()) && this.fPrevious.isResolved()) {
                this.fDetails.setInput((Object)this.fPrevious);
            } else {
                this.fDetails.setInput((Object)selected);
            }
        } else {
            this.fDetails.setInput(null);
        }
    }

    private ITargetPlatformService getTargetService() {
        return (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
    }

    public void init(IWorkbench workbench) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        if (!manager.isInitialized()) {
            manager.getExternalModelManager();
        }
    }

    public void performDefaults() {
        ITargetPlatformService service = this.getTargetService();
        if (service != null) {
            ITargetDefinition deflt = service.newDefaultTarget();
            Iterator<ITargetDefinition> iterator = this.fTargets.iterator();
            TargetDefinition reuse = null;
            while (iterator.hasNext()) {
                TargetDefinition existing = (TargetDefinition)iterator.next();
                if (!existing.isContentEquivalent(deflt)) continue;
                reuse = existing;
                break;
            }
            if (reuse != null) {
                deflt = reuse;
            } else {
                this.fTargets.add(deflt);
                this.fTableViewer.refresh(false);
            }
            this.fActiveTarget = deflt;
            this.fTableViewer.setCheckedElements(new Object[]{this.fActiveTarget});
            this.fTableViewer.refresh(true);
            this.handleActivate();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        ITargetPlatformService service = this.getTargetService();
        if (service == null) {
            return false;
        }
        ITargetDefinition toLoad = null;
        boolean load = false;
        ITargetHandle activeHandle = null;
        if (this.fActiveTarget != null) {
            activeHandle = this.fActiveTarget.getHandle();
        }
        if (this.fPrevious == null) {
            if (activeHandle != null) {
                toLoad = this.fActiveTarget;
                load = true;
            }
        } else if (activeHandle == null) {
            load = true;
        } else if (!this.fPrevious.getHandle().equals(activeHandle) || this.isOutOfSynch) {
            toLoad = this.fActiveTarget;
            load = true;
        } else if (((TargetDefinition)this.fPrevious).isContentEquivalent(this.fActiveTarget)) {
            load = false;
        } else {
            load = true;
            toLoad = this.fActiveTarget;
        }
        if (this.fMoved.size() > 0) {
            Iterator<Object> iterator = this.fMoved.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    ITargetDefinition target = (ITargetDefinition)iterator.next();
                    IFile targetFile = PDECore.getWorkspace().getRoot().getFile((IPath)this.fMoved.get(target));
                    WorkspaceFileTargetHandle wrkspcTargetHandle = new WorkspaceFileTargetHandle(targetFile);
                    ITargetDefinition newTarget = service.newTarget();
                    service.copyTargetDefinition(target, newTarget);
                    wrkspcTargetHandle.save(newTarget);
                    this.fRemoved.add(target);
                    this.fTargets.remove(target);
                    ITargetDefinition workspaceTarget = wrkspcTargetHandle.getTargetDefinition();
                    this.fTargets.add(workspaceTarget);
                    this.fTableViewer.refresh(false);
                    if (target != this.fActiveTarget) continue;
                    load = true;
                    toLoad = workspaceTarget;
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        }
        for (ITargetDefinition target : this.fRemoved) {
            try {
                service.deleteTarget(target.getHandle());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.TargetPlatformPreferencePage2_8, (String)PDEUIMessages.TargetPlatformPreferencePage2_11, (IStatus)e.getStatus());
                return false;
            }
        }
        for (ITargetDefinition def : this.fTargets) {
            boolean save = true;
            if (def.getHandle().exists()) {
                try {
                    ITargetDefinition original = def.getHandle().getTargetDefinition();
                    if (((TargetDefinition)original).isContentEqual(def)) {
                        save = false;
                    }
                }
                catch (CoreException e) {
                    this.setErrorMessage(e.getMessage());
                    return false;
                }
            }
            if (!save) continue;
            try {
                service.saveTargetDefinition(def);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        }
        if (load) {
            JobChangeAdapter listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().getSeverity() == 0 && TargetPlatformPreferencePage.this.fActiveTarget != null) {
                        PDEPreferencesManager pref = new PDEPreferencesManager(PDEPlugin.getPluginId());
                        if (pref.getBoolean("Preferences.MainPage.addToJavaSearch")) {
                            AddToJavaSearchJob.synchWithTarget(TargetPlatformPreferencePage.this.fActiveTarget);
                        }
                        Version platformOsgiVersion = Platform.getBundle((String)TargetPlatformPreferencePage.ORG_ECLIPSE_OSGI).getVersion();
                        platformOsgiVersion = new Version(platformOsgiVersion.getMajor(), platformOsgiVersion.getMinor(), platformOsgiVersion.getMicro());
                        TargetBundle[] bundles = TargetPlatformPreferencePage.this.fActiveTarget.getAllBundles();
                        if (bundles != null) {
                            int index = 0;
                            while (index < bundles.length) {
                                BundleInfo bundleInfo = bundles[index].getBundleInfo();
                                if (TargetPlatformPreferencePage.ORG_ECLIPSE_OSGI.equalsIgnoreCase(bundleInfo.getSymbolicName())) {
                                    Version bundleVersion = Version.parseVersion((String)bundleInfo.getVersion());
                                    if (platformOsgiVersion.compareTo(bundleVersion = new Version(bundleVersion.getMajor(), bundleVersion.getMinor(), bundleVersion.getMicro())) >= 0) break;
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.TargetPlatformPreferencePage2_28, (String)PDEUIMessages.TargetPlatformPreferencePage2_10);
                                        }
                                    });
                                    break;
                                }
                                ++index;
                            }
                        }
                    }
                }
            };
            LoadTargetDefinitionJob.load((ITargetDefinition)toLoad, (IJobChangeListener)listener);
            this.fPrevious = toLoad == null ? null : toLoad;
            this.runGC();
        } else if (this.fActiveTarget != null) {
            ((TargetPlatformService)service).setWorkspaceTargetDefinition(this.fActiveTarget);
            TargetStatus.refreshTargetStatusContent();
        }
        this.fMoved.clear();
        this.fRemoved.clear();
        if (toLoad != null) {
            this.fActiveTarget = toLoad;
        }
        this.fTableViewer.refresh(true);
        this.updateButtons();
        return super.performOk();
    }

    private void runGC() {
        Job job = new Job(PDEUIMessages.TargetPlatformPreferencePage2_26){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(PDEUIMessages.TargetPlatformPreferencePage2_27, -1);
                P2TargetUtils.garbageCollect();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private class TargetLabelProvider
    extends StyledCellLabelProvider {
        private TargetDefinition fRunningHost;
        private Font fTextFont;

        public TargetLabelProvider() {
            PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
            ITargetPlatformService service = TargetPlatformPreferencePage.this.getTargetService();
            if (service != null) {
                this.fRunningHost = (TargetDefinition)service.newDefaultTarget();
            }
        }

        private Font getBoldFont() {
            if (this.fTextFont == null) {
                Font dialogFont = JFaceResources.getDialogFont();
                FontData[] fontData = dialogFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    FontData data = fontData[i];
                    data.setStyle(1);
                    ++i;
                }
                Display display = TargetPlatformPreferencePage.this.getShell().getDisplay();
                this.fTextFont = new Font((Device)display, fontData);
            }
            return this.fTextFont;
        }

        public void update(ViewerCell cell) {
            final Object element = cell.getElement();
            StyledString.Styler style = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    if (element.equals(TargetPlatformPreferencePage.this.fActiveTarget)) {
                        textStyle.font = TargetLabelProvider.this.getBoldFont();
                    }
                }
            };
            ITargetDefinition targetDef = (ITargetDefinition)element;
            ITargetHandle targetHandle = targetDef.getHandle();
            String name = targetDef.getName();
            if (name == null || name.length() == 0) {
                name = targetHandle.toString();
            }
            if (targetDef.equals(TargetPlatformPreferencePage.this.fActiveTarget)) {
                name = String.valueOf(name) + PDEUIMessages.TargetPlatformPreferencePage2_1;
            }
            StyledString styledString = new StyledString(name, style);
            if (targetHandle instanceof WorkspaceFileTargetHandle) {
                IFile file = ((WorkspaceFileTargetHandle)targetHandle).getTargetFile();
                String location = " - " + file.getFullPath();
                styledString.append(location, StyledString.DECORATIONS_STYLER);
            } else if (targetHandle instanceof ExternalFileTargetHandle) {
                URI uri = ((ExternalFileTargetHandle)targetHandle).getLocation();
                String location = " - " + uri.toASCIIString();
                styledString.append(location, StyledString.DECORATIONS_STYLER);
            } else {
                String location = (String)cell.getItem().getData(TargetPlatformPreferencePage.DATA_KEY_MOVED_LOCATION);
                if (location != null) {
                    location = " - " + location;
                    styledString = new StyledString(name, style);
                    styledString.append(location, StyledString.QUALIFIER_STYLER);
                }
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(targetDef));
            super.update(cell);
        }

        private Image getImage(ITargetDefinition target) {
            int flag = 0;
            if (target.equals(TargetPlatformPreferencePage.this.fActiveTarget) && target.isResolved()) {
                if (target.getStatus().getSeverity() == 2) {
                    flag = 2;
                } else if (target.getStatus().getSeverity() == 4) {
                    flag = 1;
                }
            } else if (TargetPlatformPreferencePage.this.fPrevious != null && target.getHandle().equals(TargetPlatformPreferencePage.this.fPrevious.getHandle()) && TargetPlatformPreferencePage.this.fPrevious.isResolved()) {
                if (TargetPlatformPreferencePage.this.fPrevious.getStatus().getSeverity() == 2) {
                    flag = 2;
                } else if (TargetPlatformPreferencePage.this.fPrevious.getStatus().getSeverity() == 4) {
                    flag = 1;
                }
            }
            if (this.fRunningHost != null && this.fRunningHost.isContentEquivalent(target)) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_BRANDING, flag);
            }
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_TARGET_DEFINITION, flag);
        }

        public void dispose() {
            PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
            if (this.fTextFont != null) {
                this.fTextFont.dispose();
                this.fTextFont = null;
            }
            super.dispose();
        }
    }
}

