/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography.names;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stem.data.geography.Activator;
import org.osgi.framework.Bundle;

public class NameReader {
    static final String nameFilesPrefix = "src/org/eclipse/stem/data/geography/";
    static final String nameFilesSuffix = "_names.properties";
    public Map<String, String> regionNamesMap = new HashMap<String, String>();

    public Map<String, String> readNamesByCountryCode(String countryCode) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.stem.data.geography");
        Path path = new Path(nameFilesPrefix + countryCode + nameFilesSuffix);
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        return this.readNames(fileURL);
    }

    public Map<String, String> readNames(URL url) {
        String fname = url.getFile();
        BufferedReader fileReader = NameReader.openReader(fname);
        try {
            if (fileReader != null) {
                String buffer = null;
                while (!NameReader.EOF(buffer = fileReader.readLine())) {
                    if (buffer.indexOf("SOURCE") != -1 || buffer.indexOf("VALID") != -1 || buffer.indexOf("#") != -1 || buffer.indexOf("-") < 0) continue;
                    StringTokenizer tokenizer = new StringTokenizer(buffer, "=");
                    String stemID2 = tokenizer.nextToken().trim();
                    String name = tokenizer.nextToken();
                    this.regionNamesMap.put(stemID2, name);
                }
            }
        }
        catch (Exception e) {
            Activator.logInformation((String)("Error reading file" + fname), (Throwable)e);
            e.printStackTrace();
            System.exit(1);
        }
        return this.regionNamesMap;
    }

    protected static BufferedReader openReader(String file) {
        block3: {
            try {
                File f = new File(file);
                if (f.exists()) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new BufferedReader(new FileReader(file));
    }

    protected static boolean EOF(String buffer) {
        return buffer == null;
    }
}

