/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.loggers.imagewriter.Activator;
import org.eclipse.stem.loggers.imagewriter.ImageWriterLogger;
import org.eclipse.stem.loggers.imagewriter.ImagewriterPackage;
import org.eclipse.stem.loggers.imagewriter.MapViewImageWriterLogger;
import org.eclipse.stem.loggers.imagewriter.OriginDependentProjectedMapImageLogger;
import org.eclipse.stem.loggers.imagewriter.ProjectedMapImageLogger;
import org.eclipse.stem.ui.adapters.color.ColorProvider;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.SimulationLoggerPropertyEditor;
import org.eclipse.stem.ui.wizards.ImageWriterLoggerWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImagewriterLoggerPropertyEditor
extends SimulationLoggerPropertyEditor {
    private Combo colorProviderPicker;
    private List<Class<? extends ColorProvider>> colorProviders = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProviders();
    private List<String> colorProviderNames = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProvidersNames();

    public ImagewriterLoggerPropertyEditor(Composite parent, int style, Logger logger, ModifyListener projectValidator, IProject project) {
        super(parent, style, logger, projectValidator, project);
        if (logger instanceof ProjectedMapImageLogger) {
            Label label = new Label((Composite)this, 0);
            label.setText(ImageWriterLoggerWizardMessages.getString("IWLPE_ColorProviderLabel"));
            GridData labelGD = new GridData(1);
            labelGD.grabExcessHorizontalSpace = true;
            labelGD.horizontalAlignment = 4;
            labelGD.horizontalIndent = 0;
            label.setLayoutData((Object)labelGD);
            this.colorProviderPicker = new Combo((Composite)this, 8);
            GridData colorProviderGD = new GridData(3);
            colorProviderGD.grabExcessHorizontalSpace = false;
            colorProviderGD.horizontalAlignment = 4;
            colorProviderGD.horizontalSpan = 2;
            this.colorProviderPicker.setItems(this.colorProviderNames.toArray(new String[0]));
            this.colorProviderPicker.select(0);
        }
    }

    private Class<?> getSelectedColorProvider() {
        return this.colorProviders.get(this.colorProviderPicker.getSelectionIndex());
    }

    public boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        return super.isUserSpecifiedProperty(feature);
    }

    public void populate(Logger logger) {
        ImageWriterLogger obj;
        super.populate(logger);
        if (logger instanceof ImageWriterLogger) {
            obj = (ImageWriterLogger)logger;
            obj.setDataPath(((Text)this.map.get(ImagewriterPackage.Literals.IMAGE_WRITER_LOGGER__DATA_PATH)).getText());
            obj.setUseDefaultLogDirectory(((Button)this.booleanMap.get(ImagewriterPackage.Literals.IMAGE_WRITER_LOGGER__USE_DEFAULT_LOG_DIRECTORY)).getSelection());
        }
        if (logger instanceof MapViewImageWriterLogger) {
            obj = (MapViewImageWriterLogger)logger;
            obj.setOpenMapView(((Button)this.booleanMap.get(ImagewriterPackage.Literals.MAP_VIEW_IMAGE_WRITER_LOGGER__OPEN_MAP_VIEW)).getSelection());
        }
        if (logger instanceof ProjectedMapImageLogger) {
            obj = (ProjectedMapImageLogger)logger;
            try {
                Class<?> cp = this.getSelectedColorProvider();
                obj.setColorProvider(cp.asSubclass(ColorProvider.class));
            }
            catch (Exception e) {
                Activator.logWarning(ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidColorProvider"), e);
            }
            obj.setForceAspectRatio(((Button)this.booleanMap.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__FORCE_ASPECT_RATIO)).getSelection());
            obj.setFitToShapeBounds(((Button)this.booleanMap.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__FIT_TO_SHAPE_BOUNDS)).getSelection());
            obj.setLogScaling(((Button)this.booleanMap.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__LOG_SCALING)).getSelection());
            obj.setTransparentBackground(((Button)this.booleanMap.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__TRANSPARENT_BACKGROUND)).getSelection());
            obj.setGain(Float.parseFloat(((Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__GAIN)).getText()));
            obj.setBorderTransparency(Integer.parseInt(((Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__BORDER_TRANSPARENCY)).getText()));
            obj.setHeight(Integer.parseInt(((Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__HEIGHT)).getText()));
            obj.setWidth(Integer.parseInt(((Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__WIDTH)).getText()));
        }
        if (logger instanceof OriginDependentProjectedMapImageLogger) {
            obj = (OriginDependentProjectedMapImageLogger)logger;
            obj.setOriginLatitude(Double.parseDouble(((Text)this.map.get(ImagewriterPackage.Literals.ORIGIN_DEPENDENT_PROJECTED_MAP_IMAGE_LOGGER__ORIGIN_LATITUDE)).getText()));
            obj.setOriginLongitude(Double.parseDouble(((Text)this.map.get(ImagewriterPackage.Literals.ORIGIN_DEPENDENT_PROJECTED_MAP_IMAGE_LOGGER__ORIGIN_LONGITUDE)).getText()));
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Button button = (Button)this.booleanMap.get(ImagewriterPackage.Literals.IMAGE_WRITER_LOGGER__USE_DEFAULT_LOG_DIRECTORY);
        Text text = (Text)this.map.get(ImagewriterPackage.Literals.IMAGE_WRITER_LOGGER__DATA_PATH);
        if (text != null && button != null && !button.getSelection() && text.getText().equals("")) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidLogDirectory");
            return false;
        }
        text = (Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__BORDER_TRANSPARENCY);
        if (text != null && (text.getText().equals("") || !this.isValidIntValue(text.getText(), 0, 100))) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidBorderTransparencyValue");
            return false;
        }
        text = (Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__GAIN);
        if (text != null && (text.getText().equals("") || !this.isValidDoubleValue(text.getText(), 1.0E-12))) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidGainValue");
            return false;
        }
        text = (Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__HEIGHT);
        if (text != null && (text.getText().equals("") || !this.isValidIntValue(text.getText(), 1))) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidImageHeightValue");
            return false;
        }
        text = (Text)this.map.get(ImagewriterPackage.Literals.PROJECTED_MAP_IMAGE_LOGGER__WIDTH);
        if (text != null && (text.getText().equals("") || !this.isValidIntValue(text.getText(), 1))) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidImageWidthValue");
            return false;
        }
        text = (Text)this.map.get(ImagewriterPackage.Literals.ORIGIN_DEPENDENT_PROJECTED_MAP_IMAGE_LOGGER__ORIGIN_LATITUDE);
        if (text != null && (text.getText().equals("") || !this.isValidDoubleValue(text.getText(), -90.0, 90.0))) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidOriginLatitudeValue");
            return false;
        }
        text = (Text)this.map.get(ImagewriterPackage.Literals.ORIGIN_DEPENDENT_PROJECTED_MAP_IMAGE_LOGGER__ORIGIN_LONGITUDE);
        if (text != null && (text.getText().equals("") || !this.isValidDoubleValue(text.getText(), -180.0, 180.0))) {
            this.errorMessage = ImageWriterLoggerWizardMessages.getString("IWLPE_InvalidOriginLongitudeValue");
            return false;
        }
        return true;
    }
}

