/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseInitializer;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseInitializerImpl;
import org.eclipse.stem.diseasemodels.standard.impl.Messages;

public class StandardDiseaseInitializerImpl
extends DiseaseInitializerImpl
implements StandardDiseaseInitializer {
    private EList<DiseaseModelLabel> labelsToInitialize;
    protected static final String TARGET_ISO_KEY_EDEFAULT = null;
    protected String targetISOKey = TARGET_ISO_KEY_EDEFAULT;
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected EList<String> compartments;
    protected EList<Double> compartmentValues;
    protected static final boolean USE_FRACTIONS_EDEFAULT = false;
    protected boolean useFractions = false;

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_DISEASE_INITIALIZER;
    }

    @Override
    public String getTargetISOKey() {
        return this.targetISOKey;
    }

    @Override
    public void setTargetISOKey(String newTargetISOKey) {
        this.targetISOKey = newTargetISOKey;
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI newTargetURI) {
        this.targetURI = newTargetURI;
    }

    @Override
    public EList<String> getCompartments() {
        if (this.compartments == null) {
            this.compartments = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 12);
        }
        return this.compartments;
    }

    @Override
    public EList<Double> getCompartmentValues() {
        if (this.compartmentValues == null) {
            this.compartmentValues = new EDataTypeEList(Double.class, (InternalEObject)this, 13);
        }
        return this.compartmentValues;
    }

    @Override
    public boolean isUseFractions() {
        return this.useFractions;
    }

    @Override
    public void setUseFractions(boolean newUseFractions) {
        this.useFractions = newUseFractions;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getTargetISOKey();
            }
            case 11: {
                return this.getTargetURI();
            }
            case 12: {
                return this.getCompartments();
            }
            case 13: {
                return this.getCompartmentValues();
            }
            case 14: {
                return this.isUseFractions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setTargetISOKey((String)newValue);
                return;
            }
            case 11: {
                this.setTargetURI((URI)newValue);
                return;
            }
            case 12: {
                this.getCompartments().clear();
                this.getCompartments().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getCompartmentValues().clear();
                this.getCompartmentValues().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.setUseFractions((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setTargetISOKey(TARGET_ISO_KEY_EDEFAULT);
                return;
            }
            case 11: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 12: {
                this.getCompartments().clear();
                return;
            }
            case 13: {
                this.getCompartmentValues().clear();
                return;
            }
            case 14: {
                this.setUseFractions(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return TARGET_ISO_KEY_EDEFAULT == null ? this.targetISOKey != null : !TARGET_ISO_KEY_EDEFAULT.equals(this.targetISOKey);
            }
            case 11: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals(this.targetURI);
            }
            case 12: {
                return this.compartments != null && !this.compartments.isEmpty();
            }
            case 13: {
                return this.compartmentValues != null && !this.compartmentValues.isEmpty();
            }
            case 14: {
                return this.useFractions;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (targetISOKey: ");
        result.append(this.targetISOKey);
        result.append(", targetURI: ");
        result.append(this.targetURI);
        result.append(", compartments: ");
        result.append(this.compartments);
        result.append(", compartmentValues: ");
        result.append(this.compartmentValues);
        result.append(", useFractions: ");
        result.append(this.useFractions);
        result.append(')');
        return result.toString();
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        Collection allNodes;
        if (this.isGraphDecorated()) {
            return;
        }
        Graph graph = this.getGraph();
        StandardDiseaseModel diseaseModel = null;
        this.labelsToInitialize = new BasicEList();
        for (Decorator decorator : graph.getDecorators()) {
            StandardDiseaseModel model;
            if (!(decorator instanceof StandardDiseaseModel) || !(model = (StandardDiseaseModel)decorator).getDiseaseName().equals(this.getDiseaseName())) continue;
            diseaseModel = model;
            break;
        }
        if (diseaseModel == null) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.INITIALIZER_DISEASE_NOT_FOUND, (Object[])new Object[]{this.getDiseaseName(), this.getURI().toString()}), (Identifiable)this, new Exception());
        }
        URI target = null;
        if (this.getTargetURI() != null) {
            target = this.getTargetURI();
        } else if (this.getTargetISOKey() != null && !this.getTargetISOKey().isEmpty()) {
            target = RegionImpl.createRegionNodeURI((String)this.getTargetISOKey());
        }
        if (target != null) {
            Node parent = graph.getNode(target);
            allNodes = LocationUtility.getAllChildren((Node)parent);
            allNodes.add(parent);
        } else {
            allNodes = graph.getNodes().values();
        }
        block1: for (Node node : allNodes) {
            if (node == null) {
                throw new ScenarioInitializationException(NLS.bind((String)Messages.INITIALIZER_NODE_NOT_FOUND, (Object[])new Object[]{target, this.getURI().toString()}), (Identifiable)this, new Exception());
            }
            for (NodeLabel nodeLabel : node.getLabels()) {
                DiseaseModelLabel diseaseModelLabel;
                if (!(nodeLabel instanceof DiseaseModelLabel) || (diseaseModelLabel = (DiseaseModelLabel)nodeLabel).getDecorator() != diseaseModel || !diseaseModelLabel.getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                this.doInitialization(diseaseModelLabel);
                this.labelsToInitialize.add((Object)diseaseModelLabel);
                continue block1;
            }
        }
        this.setProgress(1.0);
    }

    public void resetLabels() throws ScenarioInitializationException {
        for (DiseaseModelLabel label : this.labelsToInitialize) {
            this.doInitialization(label);
        }
    }

    private void doInitialization(DiseaseModelLabel label) throws ScenarioInitializationException {
        DiseaseModelLabelValue current = (DiseaseModelLabelValue)label.getCurrentValue();
        double populationCount = current.getPopulationCount();
        EList attributes = current.eClass().getEAllAttributes();
        double populationToInitialize = 0.0;
        if (!this.isUseFractions()) {
            Iterator iterator = this.getCompartmentValues().iterator();
            while (iterator.hasNext()) {
                double v = (Double)iterator.next();
                populationToInitialize += v;
            }
        }
        if (populationToInitialize > populationCount) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.INITIALIZER_INVALID_POPULATION_COUNT, (Object[])new Object[]{populationToInitialize, populationCount, this.getURI().toString()}), (Identifiable)this, new Exception());
        }
        for (EAttribute attribute : attributes) {
            int i = 0;
            while (i < this.getCompartments().size()) {
                if (attribute.getName().equals(this.getCompartments().get(i))) {
                    if (this.isUseFractions()) {
                        current.eSet((EStructuralFeature)attribute, (Double)this.getCompartmentValues().get(i) * populationCount);
                    } else if (((String)this.getCompartments().get(i)).equals("s")) {
                        current.eSet((EStructuralFeature)attribute, populationCount - populationToInitialize);
                    } else {
                        current.eSet((EStructuralFeature)attribute, this.getCompartmentValues().get(i));
                    }
                }
                ++i;
            }
        }
    }
}

