/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeIterator
implements TreeIterator<INode> {
    private INode current;
    private INode next;
    private INode previous;
    private Set<ICompositeNode> prunedComposites = Sets.newHashSet();

    public NodeIterator(INode node) {
        this.current = node;
        this.next = this.findNext(node);
        this.previous = this.findPrevious(node);
    }

    private INode findPrevious(INode node) {
        ICompositeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        INode predecessor = node.getPreviousSibling();
        if (predecessor != null) {
            while (predecessor instanceof ICompositeNode && !this.prunedComposites.contains(predecessor)) {
                INode lastChild = ((ICompositeNode)predecessor).getLastChild();
                if (lastChild == null) {
                    return predecessor;
                }
                predecessor = lastChild;
            }
            return predecessor;
        }
        return parent;
    }

    private INode findNext(INode node) {
        INode firstChild;
        if (node instanceof ICompositeNode && !this.prunedComposites.contains(node) && (firstChild = ((ICompositeNode)node).getFirstChild()) != null) {
            return firstChild;
        }
        return this.findNextSibling(node);
    }

    protected INode findNextSibling(INode node) {
        ICompositeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        INode successor = node.getNextSibling();
        if (successor != null) {
            return successor;
        }
        return this.findNextSibling(parent);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public INode next() {
        this.previous = this.current;
        this.current = this.next;
        this.next = this.findNext(this.next);
        return this.current;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public INode previous() {
        this.next = this.current;
        this.current = this.previous;
        this.previous = this.findPrevious(this.previous);
        return this.current;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void prune() {
        if (this.current instanceof ICompositeNode) {
            this.prunedComposites.add((ICompositeNode)this.current);
            this.next = this.findNext(this.current);
            this.previous = this.findPrevious(this.current);
        }
    }
}

