/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.typesystem.conformance.SuperTypeAcceptor;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownTypeReference
extends LightweightTypeReference {
    private String name;

    public UnknownTypeReference(ITypeReferenceOwner owner, String name) {
        super(owner);
        this.name = Strings.isEmpty((String)name) ? "Object" : name;
    }

    public UnknownTypeReference(ITypeReferenceOwner owner) {
        this(owner, null);
    }

    @Override
    public int getKind() {
        return 7;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        return true;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmUnknownTypeReference result = this.getTypesFactory().createJvmUnknownTypeReference();
        if (this.name != null) {
            result.setQualifiedName(this.name);
        }
        return result;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        return this.toTypeReference();
    }

    @Override
    public JvmType getType() {
        return null;
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        return Collections.emptyList();
    }

    @Override
    protected LightweightTypeReference doCopyInto(ITypeReferenceOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return this.getSimpleName();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.getSimpleName();
    }

    @Override
    public String getJavaIdentifier() {
        return this.name;
    }

    @Override
    public boolean isType(Class<?> clazz) {
        return false;
    }

    @Override
    public void collectSuperTypes(SuperTypeAcceptor acceptor) {
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitUnknownTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitUnknownTypeReference(this, param);
    }

    @Override
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitUnknownTypeReference(this);
    }

    @Override
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitUnknownTypeReference(this, param);
    }
}

