/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.internal.ui.launcher.FeatureBlock;
import org.eclipse.pde.internal.ui.launcher.OSGiBundleBlock;
import org.eclipse.pde.internal.ui.launcher.PluginBlock;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BlockAdapter {
    private AbstractPluginBlock fPluginBlock;
    private FeatureBlock fFeatureBlock;
    private StackLayout fLayout;
    private Composite fPluginBlockComposite;
    private Composite fFeatureBlockComposite;
    private Composite fParent;
    private ILaunchConfiguration fLaunchConfig;
    private int fActiveIndex;
    private int fSpan = 1;
    private int fIndent = 0;
    private static final int PLUGINS_BLOCK = 1;
    private static final int FEATURES_BLOCK = 2;

    public BlockAdapter(AbstractPluginBlock pluginBlock, FeatureBlock featureBlock) {
        Assert.isNotNull((Object)pluginBlock);
        Assert.isNotNull((Object)featureBlock);
        this.fPluginBlock = pluginBlock;
        this.fFeatureBlock = featureBlock;
    }

    public void createControl(Composite parent, int span, int indent) {
        Composite blockComposite = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.fSpan = span;
        this.fIndent = indent;
        this.fLayout = new StackLayout();
        blockComposite.setLayout((Layout)this.fLayout);
        this.fLayout.topControl = this.fPluginBlockComposite;
        this.fParent = blockComposite;
    }

    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        this.fLaunchConfig = config;
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.initializeFrom(config);
        } else {
            this.fPluginBlock.initializeFrom(config, enableTable);
        }
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.fLaunchConfig = config;
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.initializeFrom(config);
        } else if (this.fPluginBlock instanceof OSGiBundleBlock) {
            ((OSGiBundleBlock)this.fPluginBlock).initializeFrom(config);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.performApply(config);
        } else {
            this.fPluginBlock.performApply(config);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.setDefaults(config);
        } else {
            this.fPluginBlock.setDefaults(config);
        }
    }

    public void enableViewer(boolean enable) {
    }

    public void dispose() {
        this.fPluginBlock.dispose();
        this.fFeatureBlock.dispose();
    }

    public void initialize(boolean enable) throws CoreException {
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.initialize();
        } else if (this.fPluginBlock instanceof PluginBlock) {
            ((PluginBlock)this.fPluginBlock).initialize(enable);
        }
    }

    public void setActiveBlock(int index) {
        try {
            if (index == 2) {
                this.fPluginBlock.setVisible(false);
                if (this.fFeatureBlockComposite == null) {
                    this.fFeatureBlockComposite = SWTFactory.createComposite(this.fParent, 7, 1, 1808, 0, 0);
                    this.fFeatureBlock.createControl(this.fFeatureBlockComposite, 6, 10);
                    if (this.fLaunchConfig != null) {
                        this.fFeatureBlock.initializeFrom(this.fLaunchConfig);
                    }
                }
                this.fLayout.topControl = this.fFeatureBlockComposite;
            } else {
                this.fFeatureBlock.setVisible(false);
                if (this.fActiveIndex != index) {
                    this.fPluginBlock.setVisible(false);
                }
                if (this.fPluginBlockComposite == null) {
                    this.fPluginBlockComposite = SWTFactory.createComposite(this.fParent, this.fSpan, 1, 1808, 0, 0);
                    this.fPluginBlock.createControl(this.fPluginBlockComposite, this.fSpan, this.fIndent);
                    if (this.fLaunchConfig != null) {
                        if (this.fPluginBlock instanceof PluginBlock) {
                            this.fPluginBlock.initializeFrom(this.fLaunchConfig, index == 1);
                        } else if (this.fPluginBlock instanceof OSGiBundleBlock) {
                            ((OSGiBundleBlock)this.fPluginBlock).initializeFrom(this.fLaunchConfig);
                        }
                    }
                }
                this.fLayout.topControl = this.fPluginBlockComposite;
            }
            this.fActiveIndex = index;
        }
        catch (CoreException ex) {
            PDEPlugin.log(ex);
        }
    }
}

