/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Javac;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.JavacTableLabelProvider;
import org.eclipse.ant.internal.ui.datatransfer.ProjectCreator;
import org.eclipse.ant.internal.ui.model.AntModelContentProvider;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class AntNewJavaProjectPage
extends WizardPage {
    private Text fProjectNameField;
    private Text fLocationPathField;
    private Button fBrowseButton;
    private Button fLinkButton;
    private IAntModel fAntModel;
    private ModifyListener fLocationModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AntProjectNode projectNode;
            AntNewJavaProjectPage.this.fAntModel = AntUtil.getAntModel(AntNewJavaProjectPage.this.getProjectLocationFieldValue(), false, false, true);
            AntProjectNode antProjectNode = projectNode = AntNewJavaProjectPage.this.fAntModel == null ? null : AntNewJavaProjectPage.this.fAntModel.getProjectNode();
            if (AntNewJavaProjectPage.this.fAntModel != null && projectNode != null) {
                AntNewJavaProjectPage.this.setProjectName();
                ArrayList javacNodes = new ArrayList();
                AntNewJavaProjectPage.this.getJavacNodes(javacNodes, projectNode);
                AntNewJavaProjectPage.this.fTableViewer.setInput((Object)javacNodes.toArray());
                if (!javacNodes.isEmpty()) {
                    AntNewJavaProjectPage.this.fTableViewer.setSelection((ISelection)new StructuredSelection(javacNodes.get(0)));
                }
                AntNewJavaProjectPage.this.fTableViewer.getControl().setEnabled(true);
            } else {
                AntNewJavaProjectPage.this.fTableViewer.setInput((Object)new Object[0]);
                AntNewJavaProjectPage.this.fTableViewer.getControl().setEnabled(false);
            }
            AntNewJavaProjectPage.this.setPageComplete(AntNewJavaProjectPage.this.validatePage());
        }
    };
    private ModifyListener fNameModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AntNewJavaProjectPage.this.setPageComplete(AntNewJavaProjectPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private TableViewer fTableViewer;

    public AntNewJavaProjectPage() {
        super("newPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.AntNewJavaProjectPage_9);
        this.setDescription(DataTransferMessages.AntNewJavaProjectPage_10);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.createTargetsTable(composite);
        this.fLinkButton = new Button(composite, 32);
        this.fLinkButton.setText(DataTransferMessages.AntNewJavaProjectPage_24);
        this.fLinkButton.setFont(parent.getFont());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 2;
        this.fLinkButton.setLayoutData((Object)gd);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Label projectContentsLabel = new Label(parent, 0);
        projectContentsLabel.setText(DataTransferMessages.AntNewJavaProjectPage_11);
        projectContentsLabel.setFont(parent.getFont());
        this.createUserSpecifiedProjectLocationGroup(parent);
    }

    private final void createProjectNameGroup(Composite parent) {
        Font dialogFont = parent.getFont();
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText(DataTransferMessages.AntNewJavaProjectPage_12);
        projectLabel.setFont(dialogFont);
        GridData gd = new GridData(256);
        projectLabel.setLayoutData((Object)gd);
        this.fProjectNameField = new Text(parent, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 2;
        this.fProjectNameField.setLayoutData((Object)gd);
        this.fProjectNameField.setFont(dialogFont);
        this.fProjectNameField.addModifyListener(this.fNameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup) {
        Font dialogFont = projectGroup.getFont();
        this.fLocationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fLocationPathField.setLayoutData((Object)data);
        this.fLocationPathField.setFont(dialogFont);
        this.fBrowseButton = new Button(projectGroup, 8);
        this.fBrowseButton.setText(DataTransferMessages.AntNewJavaProjectPage_13);
        this.fBrowseButton.setFont(dialogFont);
        this.setButtonLayoutData(this.fBrowseButton);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AntNewJavaProjectPage.this.handleBrowseButtonPressed();
            }
        });
        this.fLocationPathField.addModifyListener(this.fLocationModifyListener);
    }

    private String getProjectName(AntProjectNode projectNode) {
        String projectName = projectNode.getLabel();
        if (projectName == null) {
            projectName = DataTransferMessages.AntNewJavaProjectPage_14;
        }
        return projectName;
    }

    private String getProjectNameFieldValue() {
        if (this.fProjectNameField == null) {
            return "";
        }
        return this.fProjectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        return this.fLocationPathField.getText().trim();
    }

    private void handleBrowseButtonPressed() {
        String lastUsedPath = "";
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        Path filterPath = new Path(dialog.getFilterPath());
        String buildFileName = dialog.getFileName();
        IPath path = filterPath.append(buildFileName).makeAbsolute();
        this.fLocationPathField.setText(path.toOSString());
    }

    private boolean validatePage() {
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(DataTransferMessages.AntNewJavaProjectPage_15);
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_16);
            return false;
        }
        if (this.fAntModel == null) {
            if (this.getBuildFile(locationFieldContents) == null) {
                this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_0);
                return false;
            }
            this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_17);
            return false;
        }
        if (this.fAntModel.getProjectNode() == null) {
            this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_2);
            return false;
        }
        if (this.getProjectNameFieldValue().length() == 0) {
            this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_18);
            return false;
        }
        try {
            IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
            if (existingProject.exists()) {
                this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_19);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(NLS.bind((String)DataTransferMessages.AntNewJavaProjectPage_23, (Object)e.getLocalizedMessage()));
            return false;
        }
        if (this.fTableViewer.getTable().getItemCount() == 0) {
            this.setErrorMessage(DataTransferMessages.AntNewJavaProjectPage_1);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private void setProjectName() {
        AntProjectNode node = this.fAntModel.getProjectNode();
        String projectName = this.getProjectName(node);
        this.fProjectNameField.setText(projectName);
    }

    private File getBuildFile(String locationFieldContents) {
        File buildFile = new File(locationFieldContents);
        if (!buildFile.isFile() || !buildFile.exists()) {
            return null;
        }
        return buildFile;
    }

    protected IJavaProject createProject() {
        final IJavaProject[] result = new IJavaProject[1];
        final String projectName = this.getProjectNameFieldValue();
        final File buildFile = this.getBuildFile(this.getProjectLocationFieldValue());
        final List selectedJavacs = ((IStructuredSelection)this.fTableViewer.getSelection()).toList();
        final boolean link = this.fLinkButton.getSelection();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                List javacTasks = AntNewJavaProjectPage.this.resolveJavacTasks(selectedJavacs);
                ProjectCreator creator = new ProjectCreator();
                for (Javac javacTask : javacTasks) {
                    IJavaProject javaProject = creator.createJavaProjectFromJavacNode(projectName, javacTask, monitor);
                    AntNewJavaProjectPage.this.importBuildFile(monitor, javaProject, buildFile, link);
                    result[0] = javaProject;
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            IStatus status = null;
            if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
            } else {
                status = new Status(4, "org.eclipse.ant.ui", 0, "Error occurred. Check log for details ", t);
                AntUIPlugin.log(t);
            }
            ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.AntNewJavaProjectPage_21, null, (IStatus)status);
        }
        return result[0];
    }

    protected void importBuildFile(IProgressMonitor monitor, IJavaProject javaProject, File buildFile, boolean link) {
        block8: {
            if (link) {
                IProject project = javaProject.getProject();
                IFile iBuildFile = project.getFile(buildFile.getName());
                if (!iBuildFile.exists()) {
                    try {
                        iBuildFile.createLink((IPath)new Path(buildFile.getAbsolutePath()), 16, monitor);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.AntNewJavaProjectPage_22, null, (IStatus)e.getStatus());
                    }
                }
            } else {
                FileSystemStructureProvider structureProvider = FileSystemStructureProvider.INSTANCE;
                File rootDir = buildFile.getParentFile();
                try {
                    ImportOperation op = new ImportOperation(javaProject.getPath(), (Object)rootDir, (IImportStructureProvider)structureProvider, (IOverwriteQuery)new ImportOverwriteQuery(), Collections.singletonList(buildFile));
                    op.setCreateContainerStructure(false);
                    op.run(monitor);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof CoreException)) break block8;
                    ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.AntNewJavaProjectPage_22, null, (IStatus)((CoreException)t).getStatus());
                }
            }
        }
    }

    private List<?> resolveJavacTasks(List<?> javacNodes) {
        ArrayList<Object> resolvedJavacTasks = new ArrayList<Object>(javacNodes.size());
        for (AntTaskNode taskNode : javacNodes) {
            Task javacTask = taskNode.getTask();
            if (javacTask instanceof UnknownElement) {
                if (((UnknownElement)javacTask).getRealThing() == null) {
                    javacTask.maybeConfigure();
                }
                resolvedJavacTasks.add(((UnknownElement)javacTask).getRealThing());
                continue;
            }
            resolvedJavacTasks.add(javacTask);
        }
        return resolvedJavacTasks;
    }

    private void getJavacNodes(List<AntTaskNode> javacNodes, IAntElement parent) {
        if (!parent.hasChildren()) {
            return;
        }
        List<IAntElement> children = parent.getChildNodes();
        for (IAntElement node : children) {
            AntTaskNode task;
            if (node instanceof AntTargetNode) {
                this.getJavacNodes(javacNodes, node);
                continue;
            }
            if (!(node instanceof AntTaskNode) || !"javac".equals((task = (AntTaskNode)node).getName())) continue;
            javacNodes.add(task);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fLocationPathField.setFocus();
        }
    }

    private void createTargetsTable(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setFont(font);
        label.setText(DataTransferMessages.AntNewJavaProjectPage_3);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        Table table = new Table(parent, 67588);
        GridData data = new GridData(1808);
        int availableRows = this.availableRows(parent);
        data.heightHint = table.getItemHeight() * (availableRows / 20);
        data.widthHint = 250;
        data.horizontalSpan = 3;
        table.setLayoutData((Object)data);
        table.setFont(font);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new JavacTableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new AntModelContentProvider());
        this.fTableViewer.getControl().setEnabled(false);
    }

    private int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            return "ALL";
        }
    }
}

