/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.MetamodelResourceFactory;

public class MetamodelPackageManager {
    private static MetamodelPackageManager INSTANCE;
    private final Map<URI, Package> loadedPackages = new HashMap<URI, Package>();
    private Map<IProject, List<IFile>> workspaceMetamodels;
    private boolean isInitialized = false;
    private ResourceSet resourceSet = new ResourceSetImpl();

    private MetamodelPackageManager() {
        this.resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("metamodel", new MetamodelResourceFactory());
    }

    public static synchronized MetamodelPackageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetamodelPackageManager();
        }
        return INSTANCE;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    private URI getPluginResourceURI(String container, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(container);
        sb.append("/");
        sb.append(path);
        return URI.createPlatformPluginURI((String)sb.toString(), (boolean)true);
    }

    public void loadAll(IProgressMonitor monitor) {
        monitor.beginTask("Loading Metamodels", 2);
        this.loadWorkspaceMetamodels((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.loadExtensionPointMetamodels((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
        this.isInitialized = true;
    }

    public void loadExtensionPointMetamodels(IProgressMonitor monitor) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stem.model.metamodel");
        monitor.beginTask("Loading Metamodels from Extensions", elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String resourcePath = element.getAttribute("path");
                if (resourcePath != null) {
                    try {
                        URI uri = this.getPluginResourceURI(element.getContributor().getName(), resourcePath);
                        this.load(uri);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                        monitor.worked(1);
                        break block9;
                    }
                    catch (IOException iOException) {
                        try {
                            break block9;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            monitor.worked(1);
                        }
                    }
                    monitor.worked(1);
                }
            }
            ++n2;
        }
        monitor.done();
    }

    public Map<URI, Package> getLoadedPackages() {
        return this.loadedPackages;
    }

    private void load(URI uri, Package pkg) {
        this.loadedPackages.put(uri, pkg);
    }

    private Package load(URI uri) throws IOException {
        Resource resource = this.resourceSet.createResource(uri);
        resource.load(null);
        if (resource.getContents().size() > 0) {
            EObject obj = (EObject)resource.getContents().get(0);
            EcoreUtil.resolveAll((EObject)obj);
            if (obj instanceof Package) {
                this.load(uri, (Package)obj);
                return (Package)obj;
            }
        }
        return null;
    }

    public Package load(IFile file) throws IOException {
        URI ecoreURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return this.load(ecoreURI);
    }

    private Map<IProject, List<IFile>> groupFilesByProject(List<IFile> files) {
        HashMap<IProject, List<IFile>> projectsMap = new HashMap<IProject, List<IFile>>();
        if (files != null && files.size() > 0) {
            for (IFile file : files) {
                IProject project = file.getProject();
                ArrayList<IFile> projectFiles = (ArrayList<IFile>)projectsMap.get(project);
                if (projectFiles == null) {
                    projectFiles = new ArrayList<IFile>();
                    projectsMap.put(project, projectFiles);
                }
                projectFiles.add(file);
            }
        }
        return projectsMap;
    }

    public void loadWorkspaceMetamodels(IProgressMonitor monitor) {
        this.loadWorkspaceMetamodels(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), monitor);
    }

    public void loadWorkspaceMetamodels(List<IProject> projects, IProgressMonitor monitor) {
        if (this.workspaceMetamodels == null) {
            this.workspaceMetamodels = this.findMetamodelsInWorkspace(monitor);
        }
        monitor.beginTask("Loading Workspacing Metamodels", this.workspaceMetamodels.size());
        for (Map.Entry<IProject, List<IFile>> projectEntry : this.workspaceMetamodels.entrySet()) {
            for (IFile metamodel : projectEntry.getValue()) {
                if (!projects.contains(metamodel.getProject())) continue;
                try {
                    URI ecoreURI = URI.createPlatformResourceURI((String)metamodel.getFullPath().toString(), (boolean)true);
                    Package package_ = this.load(ecoreURI);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    monitor.worked(1);
                    continue;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                monitor.worked(1);
            }
        }
        monitor.done();
    }

    public void loadContainerMetamodels(IResource container, IProgressMonitor monitor) {
        for (IFile metamodelFile : this.findMetamodelsInContainer(container, monitor)) {
            try {
                this.load(URI.createPlatformResourceURI((String)metamodelFile.getFullPath().toString(), (boolean)true));
            }
            catch (IOException iOException) {}
        }
    }

    public Map<IProject, List<IFile>> findMetamodelsInWorkspace(IProgressMonitor monitor) {
        return this.groupFilesByProject(this.findMetamodelsInContainer((IResource)ResourcesPlugin.getWorkspace().getRoot(), monitor));
    }

    private List<IFile> findMetamodelsInContainer(IResource container, IProgressMonitor monitor) {
        return this.findFilesInContainer(".metamodel", container, monitor);
    }

    private List<IFile> findFilesInContainer(final String extension, IResource container, final IProgressMonitor monitor) {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IResource file;
                    if (monitor.isCanceled() || proxy.getName().startsWith(".")) {
                        return false;
                    }
                    if (proxy.getName().endsWith(extension) && (file = proxy.requestResource()) instanceof IFile) {
                        files.add((IFile)file);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
        return files;
    }
}

