/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditorContributor;
import org.eclipse.pde.internal.ui.editor.feature.OpenReferenceAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginSection
extends TableSection
implements IPluginModelListener {
    private OpenReferenceAction fOpenAction;
    private TableViewer fPluginViewer;
    private Action fNewAction;
    private Action fDeleteAction;
    private SortAction fSortAction;

    public PluginSection(PDEFormPage page, Composite parent) {
        String[] stringArray = new String[3];
        stringArray[0] = PDEUIMessages.FeatureEditor_PluginSection_new;
        stringArray[2] = PDEUIMessages.FeatureEditor_SpecSection_synchronize;
        super(page, parent, 128, stringArray);
        this.getSection().setText(PDEUIMessages.FeatureEditor_PluginSection_pluginTitle);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_PluginSection_pluginDesc);
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fPluginViewer = tablePart.getTableViewer();
        this.fPluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginViewer.setComparator(ListUtil.NAME_COMPARATOR);
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fSortAction = new SortAction(this.getStructuredViewerPart().getViewer(), PDEUIMessages.FeatureEditor_PluginSection_sortAlpha, ListUtil.NAME_COMPARATOR, null, null);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.fOpenAction.run();
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
        if (index == 2) {
            this.handleSynchronize();
        }
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        super.dispose();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IFeaturePlugin) {
            this.fPluginViewer.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fOpenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fNewAction);
        manager.add((IAction)this.fDeleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleNew() {
        BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IPluginModelBase[] allModels = PluginRegistry.getActiveModels();
                ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
                int i = 0;
                while (i < allModels.length) {
                    if (PluginSection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
                PluginSelectionDialog dialog = new PluginSelectionDialog(PluginSection.this.fPluginViewer.getTable().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        PluginSection.this.doAdd(models);
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
            }
        });
    }

    private void doAdd(Object[] candidates) throws CoreException {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeaturePlugin[] added = new IFeaturePlugin[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IPluginModelBase candidate = (IPluginModelBase)candidates[i];
            FeaturePlugin fplugin = (FeaturePlugin)model.getFactory().createPlugin();
            fplugin.loadFrom(candidate.getPluginBase());
            fplugin.setVersion("0.0.0");
            fplugin.setUnpack(CoreUtility.guessUnpack((BundleDescription)candidate.getBundleDescription()));
            added[i] = fplugin;
            ++i;
        }
        feature.addPlugins(added);
    }

    private boolean canAdd(IPluginModelBase candidate) {
        IPluginBase plugin = candidate.getPluginBase();
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeaturePlugin[] fplugins = model.getFeature().getPlugins();
        int i = 0;
        while (i < fplugins.length) {
            if (fplugins[i].getId().equals(plugin.getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.fPluginViewer.getContentProvider();
        Object[] elements = provider.getElements(this.fPluginViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.fPluginViewer.setSelection((ISelection)ssel);
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fPluginViewer.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        try {
            IFeaturePlugin[] removed = new IFeaturePlugin[ssel.size()];
            int i = 0;
            for (IFeaturePlugin iobj : ssel) {
                removed[i++] = iobj;
            }
            feature.removePlugins(removed);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleSynchronize() {
        final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getPage().getPDEEditor().getContributor();
        BusyIndicator.showWhile((Display)this.fPluginViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                contributor.getSynchronizeAction().run();
            }
        });
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    PluginSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    PluginSection.this.handleSelectAll();
                }
            });
            return true;
        }
        return false;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        this.getTablePart().setButtonEnabled(2, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof IFeaturePlugin) {
            if (e.getChangeType() == 3) {
                this.fPluginViewer.update(obj, null);
            } else if (e.getChangeType() == 1) {
                this.fPluginViewer.add(e.getChangedObjects());
                if (e.getChangedObjects().length > 0) {
                    this.fPluginViewer.setSelection((ISelection)new StructuredSelection(e.getChangedObjects()[0]));
                }
            } else if (e.getChangeType() == 2) {
                this.fPluginViewer.remove(e.getChangedObjects());
            }
        }
    }

    private void makeActions() {
        IModel model = (IModel)this.getPage().getModel();
        this.fNewAction = new Action(){

            public void run() {
                PluginSection.this.handleNew();
            }
        };
        this.fNewAction.setText(PDEUIMessages.Menus_new_label);
        this.fNewAction.setEnabled(model.isEditable());
        this.fDeleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)PluginSection.this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PluginSection.this.handleDelete();
                    }
                });
            }
        };
        this.fDeleteAction.setText(PDEUIMessages.Actions_delete_label);
        this.fDeleteAction.setEnabled(model.isEditable());
        this.fOpenAction = new OpenReferenceAction((ISelectionProvider)this.fPluginViewer);
    }

    public void modelsChanged(final PluginModelDelta delta) {
        this.getSection().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PluginSection.this.getSection().isDisposed()) {
                    return;
                }
                ModelEntry[] added = delta.getAddedEntries();
                ModelEntry[] removed = delta.getRemovedEntries();
                ModelEntry[] changed = delta.getChangedEntries();
                if (PluginSection.this.hasPluginModels(added) || PluginSection.this.hasPluginModels(removed) || PluginSection.this.hasPluginModels(changed)) {
                    PluginSection.this.markStale();
                }
            }
        });
    }

    private boolean hasPluginModels(ModelEntry[] entries) {
        return entries != null;
    }

    @Override
    public void setFocus() {
        if (this.fPluginViewer != null) {
            this.fPluginViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fPluginViewer.setInput((Object)feature);
        super.refresh();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeaturePlugin)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void doPaste() {
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && this.canPaste(null, objects)) {
            this.doPaste(null, objects);
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        FeaturePlugin[] fPlugins = new FeaturePlugin[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                FeaturePlugin fPlugin = (FeaturePlugin)objects[i];
                fPlugin.setModel(model);
                fPlugin.setParent((IFeatureObject)feature);
                fPlugins[i] = fPlugin;
                ++i;
            }
            feature.addPlugins((IFeaturePlugin[])fPlugins);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    void fireSelection() {
        ISelection sel = this.fPluginViewer.getSelection();
        if (!sel.isEmpty()) {
            this.fPluginViewer.setSelection(this.fPluginViewer.getSelection());
        } else if (this.fPluginViewer.getElementAt(0) != null) {
            this.fPluginViewer.setSelection((ISelection)new StructuredSelection(this.fPluginViewer.getElementAt(0)));
        }
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                return ((IFeature)parent).getPlugins();
            }
            return new Object[0];
        }
    }
}

