/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.multipopulation.presentation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.common.CommonFactory;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSEIRDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSIDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSIRDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSeasonalDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultipopulationPackage;
import org.eclipse.stem.diseasemodels.multipopulation.presentation.MultipopulationDiseaseWizardMessages;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.widgets.MatrixEditorDialog;
import org.eclipse.stem.ui.widgets.MatrixEditorWidget;
import org.eclipse.stem.ui.wizards.StandardDiseaseModelPropertyEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MultiPopulationDiseaseModelPropertyEditor
extends StandardDiseaseModelPropertyEditor {
    protected final Map<EStructuralFeature, String[]> matrixMap = new HashMap<EStructuralFeature, String[]>();

    public MultiPopulationDiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, diseaseModel, projectValidator, project);
        final PropertyStringProviderAdapter pspa = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)diseaseModel, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)diseaseModel, IItemPropertySource.class);
        List properties = propertySource.getPropertyDescriptors((Object)diseaseModel);
        for (final IItemPropertyDescriptor descriptor : properties) {
            final EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            final EClassifier type = feature.getEType();
            if (type != CommonPackage.Literals.STRING_VALUE_LIST && type != CommonPackage.Literals.DOUBLE_VALUE_LIST && type != CommonPackage.Literals.DOUBLE_VALUE_MATRIX) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(pspa.getPropertyName(descriptor));
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button button = new Button((Composite)this, 0);
            if (type.getClassifierID() == 4 || type.getClassifierID() == 7) {
                button.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stem.ui", (String)"/icons/full/customobj16/List.gif").createImage());
            } else {
                button.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stem.ui", (String)"/icons/full/customobj16/Matrix.gif").createImage());
            }
            button.setLayoutData((Object)new GridData(3));
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    Shell shell;
                    MatrixEditorDialog dialog;
                    String[] res;
                    String title = pspa.getPropertyName(descriptor);
                    String[] existingVals = MultiPopulationDiseaseModelPropertyEditor.this.matrixMap.get(feature);
                    short cols = MultiPopulationDiseaseModelPropertyEditor.this.getColCount(feature);
                    short rows = MultiPopulationDiseaseModelPropertyEditor.this.getRowCount(feature);
                    String[] rownames = MultiPopulationDiseaseModelPropertyEditor.this.getRowNames(feature);
                    String[] colnames = MultiPopulationDiseaseModelPropertyEditor.this.getColNames(feature);
                    boolean fixedSize = MultiPopulationDiseaseModelPropertyEditor.this.getFixedSize(feature);
                    MatrixEditorWidget.MatrixEditorValidator validator = MultiPopulationDiseaseModelPropertyEditor.this.getValidator(feature);
                    if (existingVals == null && (type.getClassifierID() == 4 || type.getClassifierID() == 5)) {
                        existingVals = new String[cols * rows];
                        int i = 0;
                        while (i < cols * rows) {
                            existingVals[i] = "0.0";
                            ++i;
                        }
                    }
                    if ((res = (dialog = new MatrixEditorDialog(shell = MultiPopulationDiseaseModelPropertyEditor.this.getShell(), 0, title, rows, cols, rownames, colnames, existingVals, fixedSize, validator)).open()) != null) {
                        MultiPopulationDiseaseModelPropertyEditor.this.matrixMap.put(feature, res);
                    }
                    MultiPopulationDiseaseModelPropertyEditor.this.resizeListsAndMatrices();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(pspa.getPropertyUnits(descriptor));
            unitLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        }
    }

    public void populate(DiseaseModel diseaseModel) {
        DoubleValue dval;
        Object dval2;
        int r;
        double[] dvals;
        String[] svals;
        MultiPopulationSIDiseaseModel model;
        super.populate(diseaseModel);
        if (diseaseModel instanceof MultiPopulationSIDiseaseModel) {
            model = (MultiPopulationSIDiseaseModel)diseaseModel;
            svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
            if (svals != null) {
                model.setPopulationGroups(CommonFactory.eINSTANCE.createStringValueList());
                String[] stringArray = svals;
                int n = svals.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    StringValue sval = CommonFactory.eINSTANCE.createStringValue();
                    sval.setValue(s);
                    model.getPopulationGroups().getValues().add((Object)sval);
                    ++n2;
                }
            }
            if ((svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE)) != null) {
                dvals = this.getDoubleArray(svals);
                int groups = (int)Math.sqrt(dvals.length);
                model.setTransmissionRate(CommonFactory.eINSTANCE.createDoubleValueMatrix());
                r = 0;
                while (r < groups) {
                    DoubleValueList nl = CommonFactory.eINSTANCE.createDoubleValueList();
                    model.getTransmissionRate().getValueLists().add((Object)nl);
                    int c = 0;
                    while (c < groups) {
                        dval2 = CommonFactory.eINSTANCE.createDoubleValue();
                        dval2.setValue(dvals[r * groups + c]);
                        nl.getValues().add(dval2);
                        ++c;
                    }
                    ++r;
                }
            }
            if ((svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__INFECTIOUS_MORTALITY_RATE)) != null) {
                dvals = this.getDoubleArray(svals);
                model.setInfectiousMortalityRate(CommonFactory.eINSTANCE.createDoubleValueList());
                dval2 = dvals;
                int c = dvals.length;
                int nl = 0;
                while (nl < c) {
                    double d = dval2[nl];
                    dval = CommonPackage.eINSTANCE.getCommonFactory().createDoubleValue();
                    dval.setValue(d);
                    model.getInfectiousMortalityRate().getValues().add((Object)dval);
                    ++nl;
                }
            }
            if ((svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__RECOVERY_RATE)) != null) {
                dvals = this.getDoubleArray(svals);
                model.setRecoveryRate(CommonFactory.eINSTANCE.createDoubleValueList());
                dval2 = dvals;
                int c = dvals.length;
                int nl = 0;
                while (nl < c) {
                    double d = dval2[nl];
                    dval = CommonFactory.eINSTANCE.createDoubleValue();
                    dval.setValue(d);
                    ((MultiPopulationSIDiseaseModel)diseaseModel).getRecoveryRate().getValues().add((Object)dval);
                    ++nl;
                }
            }
        }
        if (diseaseModel instanceof MultiPopulationSEIRDiseaseModel) {
            model = (MultiPopulationSEIRDiseaseModel)diseaseModel;
            svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SEIR_DISEASE_MODEL__INCUBATION_RATE);
            if (svals != null) {
                dvals = this.getDoubleArray(svals);
                model.setIncubationRate(CommonFactory.eINSTANCE.createDoubleValueList());
                dval2 = dvals;
                int c = dvals.length;
                int nl = 0;
                while (nl < c) {
                    double d = dval2[nl];
                    dval = CommonFactory.eINSTANCE.createDoubleValue();
                    dval.setValue(d);
                    model.getIncubationRate().getValues().add((Object)dval);
                    ++nl;
                }
            }
        }
        if (diseaseModel instanceof MultiPopulationSIRDiseaseModel) {
            model = (MultiPopulationSIRDiseaseModel)diseaseModel;
            svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SIR_DISEASE_MODEL__IMMUNITY_LOSS_RATE);
            if (svals != null) {
                dvals = this.getDoubleArray(svals);
                model.setImmunityLossRate(CommonFactory.eINSTANCE.createDoubleValueList());
                dval2 = dvals;
                int c = dvals.length;
                int nl = 0;
                while (nl < c) {
                    double d = dval2[nl];
                    dval = CommonFactory.eINSTANCE.createDoubleValue();
                    dval.setValue(d);
                    model.getImmunityLossRate().getValues().add((Object)dval);
                    ++nl;
                }
            }
        }
        if (diseaseModel instanceof MultiPopulationSeasonalDiseaseModel) {
            model = (MultiPopulationSeasonalDiseaseModel)diseaseModel;
            model.setUseSplineInterpolation(((Button)this.booleanMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__USE_SPLINE_INTERPOLATION)).getSelection());
            svals = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS);
            if (svals != null) {
                dvals = this.getDoubleArray(svals);
                int points = dvals.length / 2;
                model.setModulationPoints(CommonFactory.eINSTANCE.createDoubleValueMatrix());
                r = 0;
                while (r < points) {
                    DoubleValueList nl = CommonPackage.eINSTANCE.getCommonFactory().createDoubleValueList();
                    model.getModulationPoints().getValueLists().add((Object)nl);
                    int c = 0;
                    while (c < 2) {
                        dval2 = CommonPackage.eINSTANCE.getCommonFactory().createDoubleValue();
                        dval2.setValue(dvals[r * 2 + c]);
                        nl.getValues().add(dval2);
                        ++c;
                    }
                    ++r;
                }
            }
        }
        if (((MultiPopulationSIDiseaseModel)diseaseModel).getPopulationGroups() != null) {
            String[] groups = new String[((MultiPopulationSIDiseaseModel)diseaseModel).getPopulationGroups().getValues().size()];
            int i = 0;
            for (StringValue sv : ((MultiPopulationSIDiseaseModel)diseaseModel).getPopulationGroups().getValues()) {
                groups[i++] = sv.getValue();
            }
            i = 0;
            DoubleValueList dvl = ((MultiPopulationSIDiseaseModel)diseaseModel).getInfectiousMortalityRate();
            if (dvl != null) {
                for (DoubleValue dv : dvl.getValues()) {
                    dv.setIdentifier(groups[i++]);
                }
            }
            i = 0;
            dvl = ((MultiPopulationSIDiseaseModel)diseaseModel).getRecoveryRate();
            if (dvl != null) {
                for (DoubleValue dv : dvl.getValues()) {
                    dv.setIdentifier(groups[i++]);
                }
            }
            i = 0;
            DoubleValueMatrix dvm = ((MultiPopulationSIDiseaseModel)diseaseModel).getTransmissionRate();
            if (dvm != null) {
                for (DoubleValueList dvl2 : dvm.getValueLists()) {
                    dvl2.setIdentifier(groups[i++]);
                    int j = 0;
                    for (DoubleValue dv : dvl2.getValues()) {
                        dv.setIdentifier(groups[j++]);
                    }
                }
            }
            if (diseaseModel instanceof MultiPopulationSIRDiseaseModel) {
                i = 0;
                dvl = ((MultiPopulationSIRDiseaseModel)diseaseModel).getImmunityLossRate();
                if (dvl != null) {
                    for (DoubleValue dv : dvl.getValues()) {
                        dv.setIdentifier(groups[i++]);
                    }
                }
            }
            if (diseaseModel instanceof MultiPopulationSEIRDiseaseModel) {
                i = 0;
                dvl = ((MultiPopulationSEIRDiseaseModel)diseaseModel).getIncubationRate();
                if (dvl != null) {
                    for (DoubleValue dv : dvl.getValues()) {
                        dv.setIdentifier(groups[i++]);
                    }
                }
            }
            if (diseaseModel instanceof MultiPopulationSeasonalDiseaseModel) {
                i = 0;
                dvm = ((MultiPopulationSeasonalDiseaseModel)diseaseModel).getModulationPoints();
                if (dvm != null) {
                    for (DoubleValueList dvl2 : dvm.getValueLists()) {
                        dvl2.setIdentifier("p" + i++);
                        ((DoubleValue)dvl2.getValues().get(0)).setIdentifier("x");
                        ((DoubleValue)dvl2.getValues().get(1)).setIdentifier("y");
                    }
                }
            }
        }
    }

    private double[] getDoubleArray(String[] svals) {
        double[] res = new double[svals.length];
        int i = 0;
        while (i < res.length) {
            res[i] = Double.parseDouble(svals[i]);
            ++i;
        }
        return res;
    }

    public boolean validate() {
        return super.validate();
    }

    public short getRowCount(EStructuralFeature feature) {
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS) {
            String[] points = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS);
            if (points != null) {
                return (short)(points.length / 2);
            }
            return 0;
        }
        String[] groups = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
        if (groups != null) {
            return (short)groups.length;
        }
        return 0;
    }

    public short getColCount(EStructuralFeature feature) {
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE) {
            String[] groups = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
            if (groups != null) {
                return (short)groups.length;
            }
            return 0;
        }
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS) {
            return 2;
        }
        return 1;
    }

    public boolean getFixedSize(EStructuralFeature feature) {
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS) {
            return false;
        }
        return feature != MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS;
    }

    public String[] getRowNames(EStructuralFeature feature) {
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS) {
            return null;
        }
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE) {
            String[] groups = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
            if (groups != null) {
                groups = (String[])groups.clone();
                int i = 0;
                while (i < groups.length) {
                    groups[i] = String.valueOf(MultipopulationDiseaseWizardMessages.getString("transmissionTo")) + " " + groups[i];
                    ++i;
                }
            }
            return groups;
        }
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS) {
            return null;
        }
        return this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
    }

    public String[] getColNames(EStructuralFeature feature) {
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE) {
            String[] groups = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
            if (groups != null) {
                groups = (String[])groups.clone();
                int i = 0;
                while (i < groups.length) {
                    groups[i] = String.valueOf(MultipopulationDiseaseWizardMessages.getString("transmissionFrom")) + " " + groups[i];
                    ++i;
                }
            }
            return groups;
        }
        if (feature == MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL__MODULATION_POINTS) {
            return new String[]{MultipopulationDiseaseWizardMessages.getString("dayOfTheYear"), MultipopulationDiseaseWizardMessages.getString("transmissionFactor")};
        }
        return new String[]{""};
    }

    public MatrixEditorWidget.MatrixEditorValidator getValidator(EStructuralFeature feature) {
        EClassifier type = feature.getEType();
        Object validator = null;
        if (type == CommonPackage.Literals.DOUBLE_VALUE_LIST || type == CommonPackage.Literals.DOUBLE_VALUE_MATRIX) {
            validator = new MatrixEditorWidget.MatrixEditorValidator(){

                public boolean validateValue(String val) {
                    if (val == null || val.trim().equals("")) {
                        return false;
                    }
                    try {
                        Double.parseDouble(val.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public boolean validateAllValues(List<Text> vals) {
                    return true;
                }
            };
        } else if (type == CommonPackage.Literals.STRING_VALUE_LIST) {
            validator = new MatrixEditorWidget.MatrixEditorValidator(){

                public boolean validateValue(String val) {
                    return val != null && !val.trim().equals("");
                }

                public boolean validateAllValues(List<Text> vals) {
                    return true;
                }
            };
        }
        return validator;
    }

    private void resizeListsAndMatrices() {
        String[] groups = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__POPULATION_GROUPS);
        if (groups == null) {
            this.matrixMap.remove(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE);
            this.matrixMap.remove(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__INFECTIOUS_MORTALITY_RATE);
            this.matrixMap.remove(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__RECOVERY_RATE);
            this.matrixMap.remove(MultipopulationPackage.Literals.MULTI_POPULATION_SIR_DISEASE_MODEL__IMMUNITY_LOSS_RATE);
            this.matrixMap.remove(MultipopulationPackage.Literals.MULTI_POPULATION_SEIR_DISEASE_MODEL__INCUBATION_RATE);
        } else {
            Object[] incubation;
            Object[] immunity;
            Object[] recovery;
            Object[] mortality;
            int n = groups.length;
            Object[] transmission = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE);
            if (transmission == null || transmission.length != n * n) {
                transmission = new String[n * n];
                Arrays.fill(transmission, "0.0");
                this.matrixMap.put((EStructuralFeature)MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__TRANSMISSION_RATE, (String[])transmission);
            }
            if ((mortality = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__INFECTIOUS_MORTALITY_RATE)) == null || mortality.length != n) {
                mortality = new String[n];
                Arrays.fill(mortality, "0.0");
                this.matrixMap.put((EStructuralFeature)MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__INFECTIOUS_MORTALITY_RATE, (String[])mortality);
            }
            if ((recovery = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__RECOVERY_RATE)) == null || recovery.length != n) {
                recovery = new String[n];
                Arrays.fill(recovery, "0.0");
                this.matrixMap.put((EStructuralFeature)MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL__RECOVERY_RATE, (String[])recovery);
            }
            if ((immunity = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SIR_DISEASE_MODEL__IMMUNITY_LOSS_RATE)) == null || immunity.length != n) {
                immunity = new String[n];
                Arrays.fill(immunity, "0.0");
                this.matrixMap.put((EStructuralFeature)MultipopulationPackage.Literals.MULTI_POPULATION_SIR_DISEASE_MODEL__IMMUNITY_LOSS_RATE, (String[])immunity);
            }
            if ((incubation = this.matrixMap.get(MultipopulationPackage.Literals.MULTI_POPULATION_SEIR_DISEASE_MODEL__INCUBATION_RATE)) == null || incubation.length != n) {
                incubation = new String[n];
                Arrays.fill(incubation, "0.0");
                this.matrixMap.put((EStructuralFeature)MultipopulationPackage.Literals.MULTI_POPULATION_SEIR_DISEASE_MODEL__INCUBATION_RATE, (String[])incubation);
            }
        }
    }
}

