/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.ui.migration.MigrationTask;
import org.eclipse.stem.ui.migration.MigrationV1V2Task;
import org.osgi.framework.Version;

public class MigrationTasksScheduler {
    static MigrationTasksScheduler instance = null;
    static ArrayList<MigrationTask> allTasks;

    private MigrationTasksScheduler() {
        allTasks = new ArrayList();
        allTasks.add(MigrationV1V2Task.INSTANCE);
    }

    public static MigrationTasksScheduler getInstance() {
        if (instance == null) {
            instance = new MigrationTasksScheduler();
        }
        return instance;
    }

    public List<MigrationTask> getTasks(Version from, Version to) {
        ArrayList<MigrationTask> result = new ArrayList<MigrationTask>();
        if (from.compareTo(to) == 0) {
            return result;
        }
        for (MigrationTask mt : allTasks) {
            Version taskFromV = mt.getFromVersion();
            Version taskToV = mt.getToVersion();
            taskFromV.compareTo(from);
            int compFromEnd = taskToV.compareTo(from);
            int compToStart = taskFromV.compareTo(to);
            taskToV.compareTo(to);
            if (compFromEnd < 0 || compToStart > 0) continue;
            result.add(mt);
        }
        return result;
    }
}

