/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.BBoxInfo;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.NetworkLink;
import org.eclipse.stem.ui.ge.servlet.VerifyClient;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.swt.program.Program;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StemKml {
    public static final String CONTEXT = "STEM";
    private static boolean _started = false;
    private static boolean _failed = false;
    private static String _baseurl = null;
    private static String tmpFolder = null;
    static final int MAX = 5;
    static final int MIN = 0;
    static String servletId = null;
    static final String CONTROL_FN = "control.kml";
    static final String DISPLAYAREA_FN = "displayarea.kml";
    private static boolean waitForKML = true;
    static int interval = 2;
    static boolean validKML = true;
    private IKmlDisplay display = null;

    public StemKml() {
        try {
            String kmlDisplayClass = Aspect.getKmlDisplayClass();
            this.display = (IKmlDisplay)Class.forName(kmlDisplayClass).newInstance();
        }
        catch (Throwable t) {
            GELog.error("Failed to create instance for KmlDisplay", t);
        }
    }

    public void init() {
    }

    public static boolean verifyGE() {
        String extension = ".kml";
        Program p = Program.findProgram((String)extension);
        if (p != null) {
            GELog.debug("StemKml.verifyGE", "KML handler: " + p.getName());
        } else {
            validKML = false;
        }
        return validKML;
    }

    public static void launchGE() throws DOMException {
        try {
            String fn = StemKml.getControlFile();
            KmlDoc kml = new KmlDoc();
            kml.setRoot(null);
            kml.getDocument();
            kml.writeFile(fn);
            GELog.debug("StemKml.launchGE", fn);
            StemKml.launch(fn);
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            String msg = "Error launching initial GoogleEarth control file.";
            GELog.error(msg, e);
        }
    }

    public static String getControlFile() {
        String fn = null;
        if (tmpFolder == null) {
            tmpFolder = StemKml.getTmpFolder();
        }
        if (tmpFolder == null) {
            GELog.error("Unable to generate KML Control file.", null);
        } else {
            fn = String.valueOf(tmpFolder) + File.separator + CONTROL_FN;
        }
        return fn;
    }

    public static String getTmpFolder() {
        String tmp = null;
        String slash = File.separator;
        try {
            File tmpFile = File.createTempFile("control", ".kml", null);
            tmp = tmpFile.getParent();
            tmpFile.delete();
        }
        catch (IOException iOException) {
            GELog.error("System Temporary Directory not defined: ", null);
            tmp = StemKml.getLogFolder();
            tmp = String.valueOf(tmp) + slash + "tmp";
            File tmpFile = new File(tmp);
            tmpFile.mkdirs();
        }
        catch (Exception e) {
            GELog.error("Failure getting TMP folder.", e);
        }
        return tmp;
    }

    public static String getLogFolder() {
        String log = null;
        try {
            log = GEPreferencePage.getFolder();
            File logFolder = new File(log);
            if (logFolder.exists()) {
                if (logFolder.isDirectory()) {
                    return log;
                }
                throw new RuntimeException("Log Folder " + log + " is not valid");
            }
            boolean ok = logFolder.mkdirs();
            if (ok) {
                return log;
            }
            throw new RuntimeException("Log Folder " + log + " cannot be created ");
        }
        catch (Exception e) {
            GELog.error("Failed to get LOG folder: " + log, e);
            log = null;
            return log;
        }
    }

    public static String getDisplayAreaFile() {
        String fn = null;
        try {
            if (tmpFolder == null) {
                File tmpFile = File.createTempFile("displayarea", ".kml");
                tmpFolder = tmpFile.getParent();
                tmpFile.delete();
            }
            fn = String.valueOf(tmpFolder) + "/" + DISPLAYAREA_FN;
        }
        catch (IOException e) {
            GELog.error("Unable to generate KML DisplayArea file.", e);
        }
        return fn;
    }

    public static void clearDisplayArea() {
        String fn = String.valueOf(tmpFolder) + "/" + DISPLAYAREA_FN;
        KmlDoc kml = new KmlDoc();
        kml.setRoot(null);
        kml.getDocument();
        kml.writeFile(fn);
        StemKml.launch(fn);
    }

    public static String launchNetworkLink(String folder, String file) {
        String url = null;
        StemKml.launchGE();
        try {
            String fn = StemKml.getControlFile();
            long time = new Date().getTime();
            servletId = Long.toHexString(time);
            String wait = "n";
            if (waitForKML) {
                wait = "y";
            }
            url = String.valueOf(_baseurl) + "/" + CONTEXT + "/slideshow?id=" + servletId + "&folder=" + folder + "&wait=" + wait;
            if (file != null) {
                url = String.valueOf(url) + "&file=" + file;
            }
            GELog.debug(StemKml.class, "launchNetworkLink url=" + url);
            StemKml.writeNetLink(fn, interval, url);
            String bboxurl = String.valueOf(_baseurl) + "/" + CONTEXT + "/bbox?id=" + servletId;
            if (GEPreferencePage.isBBOX()) {
                BBoxInfo bbox = new BBoxInfo(bboxurl, servletId);
                Thread t = new Thread(bbox);
                t.start();
            }
            try {
                Program.launch((String)fn);
                GELog.debug(StemKml.class, "Launched networkLink file " + fn);
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                GELog.error("Launch failure", e);
            }
        }
        catch (Exception e) {
            GELog.error("Failure launching NetworkLink.kml file", e);
        }
        return url;
    }

    public static void writeNetLink(String fn, int interval, String url) throws DOMException {
        KmlDoc kml = new KmlDoc();
        Document doc = kml.getDocument();
        Element root = kml.setRoot(null);
        NetworkLink netLink = new NetworkLink(doc);
        String mode = "onInterval";
        netLink.setUrl(url, interval, mode);
        kml.appendAttr(netLink.getElement(), "flyToView", false);
        root.appendChild(netLink.getElement());
        kml.writeFile(fn);
    }

    public void generatePolygons(String controlFileName, Map<String, GEData> geData, Aspect aspect, long cycle) {
        this.display.generatePolygons(controlFileName, geData, aspect);
    }

    public static String getHex(int v) {
        String hex = Integer.toHexString(v);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static void launch(String controlFileName) {
        try {
            if (!validKML) {
                GELog.debug("launch: KML is unknown filetype");
                return;
            }
            File controlFile = new File(controlFileName);
            Program.launch((String)controlFile.getAbsolutePath());
            GELog.debug("StemKml.launch", "Launched file " + controlFileName);
        }
        catch (Throwable e) {
            GELog.error("StemKml: Launch failure", e);
        }
    }

    public static String initWebServer() {
        String host;
        if (GEPreferencePage.isInternalServer()) {
            _baseurl = StemKml.startWebServer();
        }
        if (_baseurl == null && (host = GEPreferencePage.getServerHost()) != null && host.length() > 0) {
            _baseurl = "http://" + host;
        }
        if (_baseurl != null) {
            GELog.debug(StemKml.class, "VerifyClient " + _baseurl);
            VerifyClient vc = new VerifyClient();
            boolean test = vc.verify(String.valueOf(_baseurl) + "/" + CONTEXT + "/verify");
            if (!test) {
                GELog.info(vc.getError());
                GELog.error("StemKml: Unable to communicate with web server @ " + _baseurl, null);
                if (GEPreferencePage.isInternalServer()) {
                    _failed = true;
                }
                _baseurl = null;
            }
        }
        if (_baseurl == null) {
            GELog.error("GoogleEarth Servlet support disabled", null);
        }
        return _baseurl;
    }

    public static String startWebServer() {
        String url = null;
        if (!_started && !_failed) {
            try {
                GELog.debug(StemKml.class, "Start webServer");
                WebappManager.start((String)"Google Earth Map View");
                String internalHost = String.valueOf(WebappManager.getHost()) + ":" + WebappManager.getPort();
                url = "http://" + internalHost;
                GELog.debug(StemKml.class, "Started webServer " + url);
            }
            catch (Exception e) {
                GELog.error(e.getMessage(), e);
                _failed = true;
                url = null;
            }
        } else if (!_failed) {
            String internalHost = String.valueOf(WebappManager.getHost()) + ":" + WebappManager.getPort();
            url = "http://" + internalHost;
        }
        GELog.debug(StemKml.class, "embedded web server at: " + url);
        if (!_failed) {
            _started = true;
        }
        return url;
    }

    public static String getServerUrl() {
        return _baseurl;
    }

    public static String getControlFN(String folder, String template, Aspect aspect, long cycle) {
        String controlFN = "";
        String seq = "0000" + cycle;
        if (cycle > 9L) {
            seq = "000" + cycle;
        }
        if (cycle > 99L) {
            seq = "00" + cycle;
        }
        if (cycle > 999L) {
            seq = "0" + cycle;
        }
        if (cycle > 9999L) {
            seq = "" + cycle;
        }
        controlFN = String.valueOf(folder) + "/" + template;
        controlFN = controlFN.replaceAll("&T", aspect.toString());
        controlFN = controlFN.replaceAll("&N", seq);
        GELog.debug(StemKml.class, "Output file=" + controlFN);
        return controlFN;
    }

    public static boolean isWaitForKML() {
        return waitForKML;
    }

    public static void setWaitForKML(boolean waitForKML) {
        StemKml.waitForKML = waitForKML;
    }
}

