/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabelValue;

public class LocationUtility {
    static Map<String, Set<String>>[] treeISOKeyMaps = new Map[4];
    static Map<String, URI> isoKeyURIMap = new HashMap<String, URI>();
    static List<Model> processedModels = new ArrayList<Model>();
    static boolean loaded = false;

    public static void reset() {
        treeISOKeyMaps = new Map[4];
        isoKeyURIMap.clear();
        processedModels.clear();
        loaded = false;
    }

    public static Set<String> getKeys(IProject project, int level, String parent) {
        if (!loaded) {
            int i = 0;
            while (i < 4) {
                LocationUtility.treeISOKeyMaps[i] = new HashMap<String, Set<String>>();
                ++i;
            }
            IFolder modelFolder = project.getFolder("models");
            IResource[] models = null;
            try {
                models = modelFolder.members();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (models != null) {
                IResource[] iResourceArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (!r.getName().startsWith(".")) {
                        try {
                            URI uri = URI.createURI((String)r.getLocationURI().toString());
                            Identifiable id = Utility.getIdentifiable((URI)uri);
                            if (id instanceof Model) {
                                LocationUtility.processModel((Model)id);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            IFolder graphsFolder = project.getFolder("graphs");
            IResource[] graphs = null;
            try {
                graphs = graphsFolder.members();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (graphs != null) {
                IResource[] iResourceArray = graphs;
                int n = graphs.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource r = iResourceArray[n3];
                    if (!r.getName().startsWith(".")) {
                        try {
                            URI uri = URI.createURI((String)r.getLocationURI().toString());
                            Identifiable id = Utility.getIdentifiable((URI)uri);
                            if (id instanceof Graph) {
                                LocationUtility.processGraph((Graph)id);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n3;
                }
            }
            loaded = true;
        }
        Set<String> result = null;
        result = parent != null ? treeISOKeyMaps[level - 1].get(parent) : treeISOKeyMaps[level].keySet();
        if (result != null) {
            return result;
        }
        return new HashSet<String>();
    }

    private static void processModel(Model m) {
        processedModels.add(m);
        for (Model m2 : m.getModels()) {
            if (processedModels.contains(m2)) continue;
            LocationUtility.processModel(m2);
        }
        EList graphs = m.getGraphs();
        for (Graph g : graphs) {
            LocationUtility.processGraph(g);
        }
    }

    private static void processGraph(Graph g) {
        for (Edge e : g.getEdges().values()) {
            TreeSet<String> nl;
            if (!(e.getLabel().getCurrentValue() instanceof RelativePhysicalRelationshipLabelValue)) continue;
            int sourceLevel = Utility.keyLevel((String)e.getNodeAURI().lastSegment());
            int targetLevel = Utility.keyLevel((String)e.getNodeBURI().lastSegment());
            String sourceKey = e.getNodeAURI().lastSegment();
            String targetKey = e.getNodeBURI().lastSegment();
            if (treeISOKeyMaps[sourceLevel].containsKey(sourceKey)) {
                treeISOKeyMaps[sourceLevel].get(sourceKey).add(targetKey);
            } else {
                nl = new TreeSet<String>();
                treeISOKeyMaps[sourceLevel].put(sourceKey, nl);
                nl.add(targetKey);
            }
            if (!treeISOKeyMaps[targetLevel].containsKey(targetKey)) {
                nl = new TreeSet();
                treeISOKeyMaps[targetLevel].put(targetKey, nl);
            }
            isoKeyURIMap.put(sourceKey, e.getNodeAURI());
            isoKeyURIMap.put(targetKey, e.getNodeBURI());
        }
        EMap map = g.getNodes();
        for (URI u : map.keySet()) {
            String key;
            int l = Utility.keyLevel((String)u.lastSegment());
            if (l == -1 || treeISOKeyMaps[l].containsKey(key = u.lastSegment())) continue;
            TreeSet nl = new TreeSet();
            treeISOKeyMaps[l].put(key, nl);
            isoKeyURIMap.put(key, u);
        }
    }

    public static Set<Edge> getCommonBorderEdges(IProject project, URI location) {
        HashMap<String, Edge> cbEdges = new HashMap<String, Edge>();
        IFolder modelFolder = project.getFolder("models");
        IResource[] models = null;
        try {
            models = modelFolder.members();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (models != null) {
            IResource[] iResourceArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (!r.getName().startsWith(".")) {
                    try {
                        URI uri = URI.createURI((String)r.getLocationURI().toString());
                        Identifiable id = Utility.getIdentifiable((URI)uri);
                        Graph g = ((Model)id).getCanonicalGraphNoDecorate(STEMURI.createURI((String)""), null, null);
                        if (id instanceof Model) {
                            cbEdges.putAll(LocationUtility.getGraphCommonBorderEdges(g, location));
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        if (location == null || location.toString().trim().equals("")) {
            IFolder graphsFolder = project.getFolder("graphs");
            IResource[] graphs = null;
            try {
                graphs = graphsFolder.members();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (graphs != null) {
                IResource[] iResourceArray = graphs;
                int n = graphs.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource r = iResourceArray[n3];
                    if (!r.getName().startsWith(".")) {
                        try {
                            URI uri = URI.createURI((String)r.getLocationURI().toString());
                            Identifiable id = Utility.getIdentifiable((URI)uri);
                            if (id instanceof Graph) {
                                cbEdges.putAll(LocationUtility.getGraphCommonBorderEdges((Graph)id, location));
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n3;
                }
            }
        }
        HashSet<Edge> retVal = new HashSet<Edge>();
        retVal.addAll(cbEdges.values());
        return retVal;
    }

    private static Map<String, Edge> getGraphCommonBorderEdges(Graph g, URI location) {
        HashMap<String, Edge> cbEdges = new HashMap<String, Edge>();
        for (Edge e : g.getEdges().values()) {
            if (!(e.getLabel().getCurrentValue() instanceof CommonBorderRelationshipLabelValue)) continue;
            String uriKey = e.getURI().lastSegment();
            if (location != null && !location.toString().trim().equals("") && LocationUtility.isSelfOrChild(e.getA(), location.lastSegment()) && LocationUtility.isSelfOrChild(e.getB(), location.lastSegment())) {
                cbEdges.put(uriKey, e);
                continue;
            }
            if (location != null && !location.toString().trim().equals("")) continue;
            cbEdges.put(uriKey, e);
        }
        return cbEdges;
    }

    public static Set<Node> getNodes(IProject project, URI location) {
        HashSet<Node> allNodes = new HashSet<Node>();
        IFolder modelFolder = project.getFolder("models");
        IResource[] models = null;
        try {
            models = modelFolder.members();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (models != null) {
            IResource[] iResourceArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (!r.getName().startsWith(".")) {
                    try {
                        URI uri = URI.createURI((String)r.getLocationURI().toString());
                        Model mod = (Model)Utility.getIdentifiable((URI)uri);
                        Graph g = mod.getCanonicalGraphNoDecorate(STEMURI.createURI((String)""), null, null);
                        LocationUtility.addGraphNodes(g, allNodes, location);
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        return allNodes;
    }

    public static Node getNode(IProject project, URI location) {
        Node retNode = null;
        IFolder modelFolder = project.getFolder("models");
        IResource[] models = null;
        try {
            models = modelFolder.members();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (models != null) {
            IResource[] iResourceArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (!r.getName().startsWith(".")) {
                    try {
                        URI uri = URI.createURI((String)r.getLocationURI().toString());
                        Model mod = (Model)Utility.getIdentifiable((URI)uri);
                        Graph g = mod.getCanonicalGraphNoDecorate(STEMURI.createURI((String)""), null, null);
                        retNode = LocationUtility.getGraphNode(g, location);
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        return retNode;
    }

    private static void addGraphNodes(Graph g, Set<Node> allNodes, URI location) {
        for (Node n : g.getNodes().values()) {
            n.getURI().lastSegment();
            if (location != null && !location.toString().trim().equals("") && LocationUtility.isSelfOrChild(n, location.lastSegment()) && !LocationUtility.containsNodeURI(n.getURI(), allNodes)) {
                allNodes.add(n);
                continue;
            }
            if (location != null && (!location.toString().trim().equals("") || allNodes.contains(n) || LocationUtility.containsNodeURI(n.getURI(), allNodes))) continue;
            allNodes.add(n);
        }
    }

    private static Node getGraphNode(Graph g, URI location) {
        for (Node n : g.getNodes().values()) {
            URI nodeURI = n.getURI();
            nodeURI.toString();
            location.toString();
            if (!nodeURI.equals(location)) continue;
            return n;
        }
        return null;
    }

    private static boolean containsNodeURI(URI uri, Set<Node> nodes) {
        for (Node n : nodes) {
            if (!n.getURI().equals(uri)) continue;
            return true;
        }
        return false;
    }

    public static URI getURIFromISOKey(String key) {
        return isoKeyURIMap.get(key);
    }

    protected static boolean isSelfOrChild(Node n, String parent) {
        if (n.getURI().lastSegment().equals(parent)) {
            return true;
        }
        return LocationUtility.hasParent(n, parent);
    }

    protected static boolean hasParent(Node n, String key) {
        for (Edge e : n.getEdges()) {
            boolean phys = e.getLabel() instanceof RelativePhysicalRelationshipLabel;
            if (!phys) continue;
            if (e.getA().getURI().lastSegment().equals(key)) {
                return true;
            }
            if (Utility.keyLevel((String)e.getA().getURI().lastSegment()) >= Utility.keyLevel((String)n.getURI().lastSegment())) continue;
            return LocationUtility.hasParent(e.getA(), key);
        }
        return false;
    }

    public static Set<Node> getAllChildren(Node parent) {
        HashSet<Node> allChildren = new HashSet<Node>();
        Set<Node> toDoSet = LocationUtility.getChildSet(parent);
        toDoSet.remove(parent);
        HashSet<Node> directChildren = new HashSet<Node>();
        while (toDoSet.size() >= 1) {
            directChildren.addAll(toDoSet);
            Iterator iter = directChildren.iterator();
            while (iter != null && iter.hasNext()) {
                Node next = (Node)iter.next();
                allChildren.add(next);
                Set<Node> nextSet = LocationUtility.getChildSet(next);
                nextSet.removeAll(allChildren);
                toDoSet.addAll(nextSet);
            }
            toDoSet.removeAll(directChildren);
            directChildren.clear();
        }
        return allChildren;
    }

    public static Set<Node> getChildSet(Node parent) {
        HashSet<Node> children = new HashSet<Node>();
        if (parent == null) {
            return children;
        }
        String parentID = parent.getURI().lastSegment();
        EList allEdges = parent.getEdges();
        int i = 0;
        while (i < allEdges.size()) {
            Edge e = (Edge)allEdges.get(i);
            LabelValue lv = e.getLabel().getCurrentValue();
            if (lv instanceof RelativePhysicalRelationshipLabelValue) {
                RelativePhysicalRelationshipLabelValue cfr_ignored_0 = (RelativePhysicalRelationshipLabelValue)lv;
                Node neighborNode = e.getOtherNode(parent);
                String neighborID = neighborNode.getURI().lastSegment();
                if (neighborID.length() > parentID.length() || parentID.equals("ZZZ")) {
                    children.add(neighborNode);
                }
            }
            ++i;
        }
        children.remove(parent);
        return children;
    }
}

