/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.xtext;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.codegen.STEMGenFeature;
import org.eclipse.stem.model.ctdl.CTDLRuntimeModule;
import org.eclipse.stem.model.ctdl.generator.CTDLGenerator;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.xtext.ExpressionMethodDefinition;
import org.eclipse.stem.model.xtext.XtextUtils;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;

public class ExpressionMethodGenerator {
    private Injector injector;
    private IGenerator generator;
    private GenClass modelGenClass;
    private GenClass labelValueGenClass;

    public ExpressionMethodGenerator(GenClass modelGenClass, GenClass labelValueGenClass) {
        this.modelGenClass = modelGenClass;
        this.labelValueGenClass = labelValueGenClass;
        this.init();
    }

    private void init() {
        this.injector = Guice.createInjector((Module[])new Module[]{new CTDLRuntimeModule()});
        this.generator = (IGenerator)this.injector.getInstance(IGenerator.class);
    }

    private CTDLGenerator getExpressionMethodGenerator() {
        return (CTDLGenerator)this.generator;
    }

    public ExpressionMethodDefinition generateExpressionMethod(Transition transition, STEMGenFeature sourceFeature, STEMGenFeature targetFeature, List<STEMGenFeature> forIncidenceFeatures) {
        XtextResource r = XtextUtils.loadAndResolveXtextResourceForTransition(transition);
        if (r == null) {
            return null;
        }
        InMemoryFileSystemAccess fsa = new InMemoryFileSystemAccess();
        CTDLGenerator gen = this.getExpressionMethodGenerator();
        gen.setModelGenClass(this.modelGenClass);
        gen.setLabelValueGenClass(this.labelValueGenClass);
        try {
            gen.doGenerate((Resource)r, (IFileSystemAccess)fsa);
        }
        catch (Throwable t0) {
            t0.printStackTrace();
        }
        ExpressionMethodDefinition definition = null;
        if (fsa.getTextFiles().size() > 0) {
            String methodBody = ((CharSequence)fsa.getTextFiles().values().iterator().next()).toString();
            definition = new ExpressionMethodDefinition(transition, methodBody);
        }
        definition.setSourceFeature(sourceFeature);
        definition.setTargetFeature(targetFeature);
        definition.setForIncidenceFeatures(forIncidenceFeatures);
        return definition;
    }
}

