/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.util.ArrayList;

public class TileBlock {
    int occX;
    int occY;
    int occW;
    int occH;
    int xOff;
    int yOff;
    int w;
    int h;
    int benefit;
    boolean[] occupied;

    TileBlock(int occX, int occY, int occW, int occH, boolean[] occupied, int xOff, int yOff, int w, int h) {
        this.occX = occX;
        this.occY = occY;
        this.occW = occW;
        this.occH = occH;
        this.xOff = xOff;
        this.yOff = yOff;
        this.w = w;
        this.h = h;
        this.occupied = occupied;
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                if (!occupied[x + xOff + occW * (y + yOff)]) {
                    ++this.benefit;
                }
                ++x;
            }
            ++y;
        }
    }

    public String toString() {
        String ret = "";
        int y = 0;
        while (y < this.occH) {
            int x = 0;
            while (x < this.occW + 1) {
                ret = x == this.xOff || x == this.xOff + this.w ? (y == this.yOff || y == this.yOff + this.h - 1 ? ret + "+" : (y > this.yOff && y < this.yOff + this.h - 1 ? ret + "|" : ret + " ")) : (y == this.yOff && x > this.xOff && x < this.xOff + this.w ? ret + "-" : (y == this.yOff + this.h - 1 && x > this.xOff && x < this.xOff + this.w ? ret + "_" : ret + " "));
                if (x != this.occW) {
                    ret = this.occupied[x + y * this.occW] ? ret + "*" : ret + ".";
                }
                ++x;
            }
            ret = ret + "\n";
            ++y;
        }
        return ret;
    }

    int getXLoc() {
        return this.occX + this.xOff;
    }

    int getYLoc() {
        return this.occY + this.yOff;
    }

    int getWidth() {
        return this.w;
    }

    int getHeight() {
        return this.h;
    }

    int getBenefit() {
        return this.benefit;
    }

    int getWork() {
        return this.w * this.h + 1;
    }

    static int getWork(TileBlock[] blocks) {
        int ret = 0;
        int i = 0;
        while (i < blocks.length) {
            ret += blocks[i].getWork();
            ++i;
        }
        return ret;
    }

    TileBlock[] getBestSplit() {
        if (this.simplify()) {
            return null;
        }
        if (this.benefit == this.w * this.h) {
            return new TileBlock[]{this};
        }
        return this.splitOneGo();
    }

    public TileBlock[] splitOneGo() {
        boolean[] filled = (boolean[])this.occupied.clone();
        ArrayList<TileBlock> items = new ArrayList<TileBlock>();
        int y = this.yOff;
        while (y < this.yOff + this.h) {
            int x = this.xOff;
            while (x < this.xOff + this.w) {
                if (!filled[x + y * this.occW]) {
                    int cw = this.xOff + this.w - x;
                    int cx = x;
                    while (cx < x + cw) {
                        if (filled[cx + y * this.occW]) {
                            cw = cx - x;
                        } else {
                            filled[cx + y * this.occW] = true;
                        }
                        ++cx;
                    }
                    int ch = 1;
                    int cy = y + 1;
                    while (cy < this.yOff + this.h) {
                        int cx2 = x;
                        while (cx2 < x + cw) {
                            if (filled[cx2 + cy * this.occW]) break;
                            ++cx2;
                        }
                        if (cx2 != x + cw) break;
                        cx2 = x;
                        while (cx2 < x + cw) {
                            filled[cx2 + cy * this.occW] = true;
                            ++cx2;
                        }
                        ++ch;
                        ++cy;
                    }
                    items.add(new TileBlock(this.occX, this.occY, this.occW, this.occH, this.occupied, x, y, cw, ch));
                    x += cw - 1;
                }
                ++x;
            }
            ++y;
        }
        TileBlock[] ret = new TileBlock[items.size()];
        items.toArray(ret);
        return ret;
    }

    public boolean simplify() {
        int x;
        boolean[] workOccupied = this.occupied;
        int y = 0;
        while (y < this.h) {
            int x2 = 0;
            while (x2 < this.w) {
                if (!workOccupied[x2 + this.xOff + this.occW * (y + this.yOff)]) break;
                ++x2;
            }
            if (x2 != this.w) break;
            ++this.yOff;
            --y;
            --this.h;
            ++y;
        }
        if (this.h == 0) {
            return true;
        }
        int y2 = this.h - 1;
        while (y2 >= 0) {
            x = 0;
            while (x < this.w) {
                if (!workOccupied[x + this.xOff + this.occW * (y2 + this.yOff)]) break;
                ++x;
            }
            if (x != this.w) break;
            --this.h;
            --y2;
        }
        x = 0;
        while (x < this.w) {
            int y3 = 0;
            while (y3 < this.h) {
                if (!workOccupied[x + this.xOff + this.occW * (y3 + this.yOff)]) break;
                ++y3;
            }
            if (y3 != this.h) break;
            ++this.xOff;
            --x;
            --this.w;
            ++x;
        }
        int x3 = this.w - 1;
        while (x3 >= 0) {
            int y4 = 0;
            while (y4 < this.h) {
                if (!workOccupied[x3 + this.xOff + this.occW * (y4 + this.yOff)]) break;
                ++y4;
            }
            if (y4 != this.h) break;
            --this.w;
            --x3;
        }
        return false;
    }
}

