/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.ui.editor.VisualModelReconciler;
import org.eclipse.stem.model.ui.editor.vismodel.CanvasPackage;
import org.eclipse.stem.model.xtext.XtextUtils;
import org.eclipse.ui.IFileEditorInput;

public class VisualModelLoader {
    private ResourceSet rs = new ResourceSetImpl();
    private IFileEditorInput input;
    private Package metamodel;
    private CanvasPackage vismodel;
    private IPath metamodelFile;
    private IPath vismodelFile;
    private Resource metamodelResource;
    private Resource vismodelResource;

    public VisualModelLoader(IFileEditorInput input) {
        this.input = input;
    }

    public void destroy() {
        for (Resource r : this.rs.getResources()) {
            r.unload();
        }
        this.rs = null;
        this.input = null;
        this.metamodel = null;
        this.vismodel = null;
        this.vismodelResource = null;
        this.metamodelResource = null;
    }

    public Package getMetamodel() {
        return this.metamodel;
    }

    public CanvasPackage getVisualModel() {
        return this.vismodel;
    }

    public void load() throws ModelLoadException {
        IFile file = this.input.getFile();
        if (file.getName().endsWith(".metamodel")) {
            this.metamodelFile = file.getFullPath();
            this.loadForMetamodel();
        }
        if (file.getName().endsWith(".vmm")) {
            this.loadForVismodel(file);
        }
    }

    private static URI getUriForPath(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    private void initializeXtextExpressions(Package pkg) {
        TreeIterator iterator = pkg.eAllContents();
        while (iterator.hasNext()) {
            EObject obj = (EObject)iterator.next();
            if (!(obj instanceof Transition)) continue;
            XtextUtils.loadAndResolveXtextResourceForTransition((Transition)((Transition)obj));
        }
    }

    private Package loadMetamodel(IPath file) throws ModelLoadException {
        URI mmURI = VisualModelLoader.getUriForPath(file);
        try {
            this.metamodelResource = this.rs.getResource(mmURI, true);
        }
        catch (Exception ioe) {
            throw new ModelLoadException("Error loading metamodel for " + mmURI.toString(), this.metamodelResource, ioe);
        }
        if (this.metamodelResource.getContents().size() > 0) {
            EObject obj = (EObject)this.metamodelResource.getContents().get(0);
            EcoreUtil.resolveAll((EObject)obj);
            if (obj instanceof Package) {
                this.initializeXtextExpressions((Package)obj);
                return (Package)obj;
            }
        }
        throw new ModelLoadException("The metamodel file did not contain a model package.  Check for parse errors.", this.metamodelResource);
    }

    private CanvasPackage loadVisualModel(URI visualModelUri) throws ModelLoadException {
        this.vismodelResource = this.rs.createResource(visualModelUri);
        try {
            this.vismodelResource.load(null);
        }
        catch (IOException ioe) {
            throw new ModelLoadException("Error loading visual model for " + visualModelUri.toString(), this.vismodelResource, ioe);
        }
        if (this.vismodelResource.getContents().size() > 0) {
            EObject obj = (EObject)this.vismodelResource.getContents().get(0);
            EcoreUtil.resolveAll((EObject)obj);
            if (obj instanceof CanvasPackage) {
                return (CanvasPackage)obj;
            }
        }
        throw new ModelLoadException("The visual model file did not contain a canvas package.  Check for parse errors.", this.vismodelResource);
    }

    private CanvasPackage loadVisualModel(IFile file) throws ModelLoadException {
        return this.loadVisualModel(VisualModelLoader.getUriForPath(file.getFullPath()));
    }

    private IPath[] getVisualModelSearchPaths(IPath metamodelFile) {
        IPath[] paths = new IPath[2];
        paths[0] = metamodelFile.removeFileExtension().addFileExtension("vmm");
        String hiddenVmmFile = "." + paths[0].lastSegment();
        paths[1] = metamodelFile.removeLastSegments(1).append(hiddenVmmFile);
        return paths;
    }

    private void findAndLoadVisualModelForMetamodel() {
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        IPath[] iPathArray = this.getVisualModelSearchPaths(this.metamodelFile);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IResource resource = wsr.findMember(path);
            if (resource instanceof IFile) {
                try {
                    CanvasPackage vismodel = this.loadVisualModel((IFile)resource);
                    if (vismodel != null) {
                        this.vismodelFile = resource.getFullPath();
                        this.vismodel = vismodel;
                    }
                }
                catch (ModelLoadException modelLoadException) {}
            }
            ++n2;
        }
    }

    private void initializeVisualModelForMetamodel() throws ModelLoadException {
        this.vismodel = VisualModelReconciler.initializeForMetamodel(this.metamodel);
        this.vismodelFile = this.getDefaultVisualModelPath();
        try {
            if (this.vismodelFile == null) {
                throw new IOException("Coldn't find serialization path for the visual model file");
            }
            this.vismodelResource = this.rs.createResource(VisualModelLoader.getUriForPath(this.vismodelFile));
            this.vismodelResource.getContents().add((Object)this.vismodel);
            this.saveVisualModel();
            VisualModelLoader.print(this.vismodelResource);
        }
        catch (IOException ioe) {
            throw new ModelLoadException("Unable to initialize the visual model", null, ioe);
        }
    }

    private IPath getDefaultVisualModelPath() {
        if (this.metamodelFile != null) {
            IPath path = this.metamodelFile;
            String filename = path.removeFileExtension().lastSegment();
            return path.removeLastSegments(1).append("." + filename + ".vmm");
        }
        if (this.input != null && this.metamodel != null) {
            return this.input.getFile().getFullPath().removeLastSegments(1).append("." + this.metamodel.getName() + ".vmm");
        }
        return null;
    }

    private void loadForMetamodel() throws ModelLoadException {
        this.metamodel = this.loadMetamodel(this.metamodelFile);
        this.findAndLoadVisualModelForMetamodel();
        if (this.vismodel == null) {
            this.initializeVisualModelForMetamodel();
        } else {
            this.reconcileVisualModel();
            VisualModelLoader.print(this.vismodelResource);
        }
    }

    private void reconcileVisualModel() throws ModelLoadException {
        VisualModelReconciler reconciler = new VisualModelReconciler(this.metamodel, this.vismodel);
        reconciler.reconcile();
        if (reconciler.isVismodelChanged()) {
            try {
                this.saveVisualModel();
            }
            catch (IOException ioe) {
                throw new ModelLoadException("Error saving reconciled visual model", null, ioe);
            }
        }
    }

    private void loadForVismodel(IFile file) throws ModelLoadException {
    }

    public void save() throws IOException {
        this.saveMetamodel();
        this.saveVisualModel();
    }

    private void saveMetamodel() throws IOException {
        if (this.metamodelResource != null) {
            this.metamodelResource.save(Collections.EMPTY_MAP);
        }
    }

    private void saveVisualModel() throws IOException {
        if (this.vismodelResource != null) {
            this.vismodelResource.save(Collections.EMPTY_MAP);
        }
    }

    private static void print(Resource r) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            r.save((OutputStream)baos, Collections.EMPTY_MAP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static class ModelLoadException
    extends Exception {
        Resource resource;
        private static final long serialVersionUID = -3367244339543539764L;

        public ModelLoadException(String message) {
            this(message, null, null);
        }

        public ModelLoadException(String message, Resource resource) {
            this(message, resource, null);
        }

        public ModelLoadException(String message, Resource resource, Throwable cause) {
            super(message, cause);
            this.resource = resource;
        }
    }
}

