/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceValidatorImpl
implements IResourceValidator {
    private static final Logger log = Logger.getLogger(ResourceValidatorImpl.class);
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private IDiagnosticConverter converter;

    /*
     * Exception decompiling
     */
    @Override
    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void collectResourceDiagnostics(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        int i = 0;
        while (i < resource.getErrors().size()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), Severity.ERROR, acceptor);
            ++i;
        }
        i = 0;
        while (i < resource.getWarnings().size()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), Severity.WARNING, acceptor);
            ++i;
        }
    }

    protected void validate(Resource resource, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        for (EObject ele : resource.getContents()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.validate(resource, ele, mode, monitor, acceptor);
        }
    }

    protected void validate(Resource resource, EObject element, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        try {
            Diagnostic diagnostic;
            HashMap options = Maps.newHashMap();
            options.put("check.mode", mode);
            options.put(CancelableDiagnostician.CANCEL_INDICATOR, monitor);
            options.put(ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, Boolean.TRUE);
            options.put(EValidator.class, this.diagnostician);
            if (resource instanceof XtextResource) {
                options.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ((XtextResource)resource).getLanguageName());
            }
            if (!(diagnostic = this.diagnostician.validate(element, (Map)options)).getChildren().isEmpty()) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                }
            } else {
                this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void resolveProxies(Resource resource, CancelIndicator monitor) {
        EcoreUtil2.resolveLazyCrossReferences(resource, monitor);
    }

    protected IAcceptor<Issue> createAcceptor(List<Issue> result) {
        return new ListBasedMarkerAcceptor(result);
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(string) + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI()));
        }
    }

    protected void issueFromXtextResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
        this.converter.convertResourceDiagnostic(diagnostic, severity, acceptor);
    }

    protected void issueFromEValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        this.converter.convertValidatorDiagnostic(diagnostic, acceptor);
    }

    public void setDiagnostician(Diagnostician diagnostician) {
        this.diagnostician = diagnostician;
    }

    public Diagnostician getDiagnostician() {
        return this.diagnostician;
    }

    public void setDiagnosticConverter(IDiagnosticConverter converter) {
        this.converter = converter;
    }

    public IDiagnosticConverter getDiagnosticConverter() {
        return this.converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListBasedMarkerAcceptor
    implements IAcceptor<Issue> {
        private final List<Issue> result;

        protected ListBasedMarkerAcceptor(List<Issue> result) {
            this.result = result;
        }

        public void accept(Issue issue) {
            if (issue != null) {
                this.result.add(issue);
            }
        }
    }
}

