/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.batch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.jobs.batch.Batch;
import org.eclipse.stem.jobs.batch.BatchEvent;
import org.eclipse.stem.jobs.batch.BatchManagerEvent;
import org.eclipse.stem.jobs.batch.BatchState;
import org.eclipse.stem.jobs.batch.IBatch;
import org.eclipse.stem.jobs.batch.IBatchListener;
import org.eclipse.stem.jobs.batch.IBatchListenerSync;
import org.eclipse.stem.jobs.batch.IBatchManagerListener;
import org.eclipse.stem.jobs.batch.IBatchManagerListenerSync;
import org.eclipse.stem.jobs.batch.Messages;
import org.eclipse.stem.jobs.execution.ExecutableManager;

public class BatchManager
extends ExecutableManager
implements IBatchListener {
    public static BatchManager INSTANCE = new BatchManager();
    private static int sequenceNumber = 0;
    public static final IBatch[] NONE = new Batch[0];
    private final List<IBatchManagerListener> listeners = new CopyOnWriteArrayList<IBatchManagerListener>();
    private final List<IBatchManagerListenerSync> listenersSync = new CopyOnWriteArrayList<IBatchManagerListenerSync>();
    private final List<IBatch> batches = new ArrayList<IBatch>();

    private BatchManager() {
    }

    private static final synchronized int getAndIncrementBatchSequenceNumber() {
        return sequenceNumber++;
    }

    public List<IBatch> getActiveBatches() {
        return this.batches;
    }

    private void addActiveBatch(IBatch batch) {
        this.batches.add(batch);
        batch.addBatchListener(this);
        this.fireBatchManagerChanged(new IBatch[]{batch}, NONE);
    }

    private final void removeActiveBatch(IBatch batch) {
        this.batches.remove(batch);
        batch.removeBatchListener(this);
        this.fireBatchManagerChanged(NONE, new IBatch[]{batch});
    }

    public IBatch createBatch(Experiment experiment) {
        Experiment copyExperiment = (Experiment)EcoreUtil.copy((EObject)experiment);
        copyExperiment.getModifiers().clear();
        copyExperiment.getModifiers().addAll(EcoreUtil.copyAll((Collection)experiment.getModifiers()));
        Batch batch = new Batch(copyExperiment, BatchManager.getAndIncrementBatchSequenceNumber());
        batch.setPriority(30);
        BatchAdapter retValue = new BatchAdapter(batch);
        this.addActiveBatch(retValue);
        return retValue;
    }

    protected IBatch createBatch(IConfigurationElement configurationElement, IProgressMonitor monitor) {
        IBatch retValue = null;
        String experimentURIString = configurationElement.getAttribute("identifier");
        try {
            retValue = this.createBatch(URI.createURI((String)experimentURIString), monitor);
        }
        catch (Exception e) {
            Activator.logError(MessageFormat.format(Messages.getString("BatchMgr.Deserialization_Error"), experimentURIString), e);
            retValue = null;
        }
        return retValue;
    }

    private IBatch createBatch(URI experimentURI, IProgressMonitor monitor) {
        IBatch retValue = null;
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(experimentURI, true);
            monitor.subTask("Reading Experiment from file");
            resource.load(null);
            monitor.subTask("Creating Batch from Experiment");
            retValue = this.createBatch((Experiment)resource.getContents().get(0));
        }
        catch (Exception e) {
            Activator.logError(MessageFormat.format(Messages.getString("BatchMgr.Deserialization_Error"), experimentURI.toString()), e);
            retValue = null;
        }
        return retValue;
    }

    public void createAndRunBatch(final Experiment experiment) {
        new Job(Messages.getString("BatchMgr.StartBatch")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBatch batch = BatchManager.this.createBatch(experiment);
                    monitor.subTask(Messages.getString("BatchMgr.Run"));
                    batch.run();
                }
                catch (Exception exception) {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndRunBatch(final IConfigurationElement configurationElement) {
        new Job(Messages.getString("BatchMgr.StartBatch")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("BatchMgr.CrtSim"), -1);
                try {
                    IBatch batch = BatchManager.this.createBatch(configurationElement, monitor);
                    monitor.subTask(Messages.getString("BatchMgr.Run"));
                    batch.run();
                }
                catch (NullPointerException nullPointerException) {
                    monitor.done();
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public final int getSequenceNumber() {
        return sequenceNumber;
    }

    public void addBatchManagerListener(IBatchManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addBatchManagerListenerSync(IBatchManagerListenerSync listenerSync) {
        if (!this.listenersSync.contains(listenerSync)) {
            this.listenersSync.add(listenerSync);
        }
    }

    public void removeListener(IBatchManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListenerSync(IBatchManagerListenerSync listenerSync) {
        this.listenersSync.remove(listenerSync);
    }

    private void fireBatchManagerChanged(IBatch[] batchesAdded, IBatch[] batchesRemoved) {
        final BatchManagerEvent event = new BatchManagerEvent(this, batchesAdded, batchesRemoved);
        for (final IBatchManagerListener listener : this.listeners) {
            DisplaySafeExecutor.executeAsync(new Runnable(){

                @Override
                public void run() {
                    listener.batchesChanged(event);
                }
            });
        }
        for (final IBatchManagerListenerSync listenerSync : this.listenersSync) {
            DisplaySafeExecutor.executeSync(new Runnable(){

                @Override
                public void run() {
                    listenerSync.batchesChangedSync(event);
                }
            });
        }
    }

    @Override
    public void batchChanged(BatchEvent event) {
        if (event.getBatchState().equals((Object)BatchState.STOPPED)) {
            this.removeActiveBatch(event.getBatch());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IBatch batch : this.batches) {
            sb.append(batch.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void resetBatchManager() {
        INSTANCE = new BatchManager();
    }

    protected static class BatchAdapter
    implements IBatch,
    IBatchListener,
    IBatchListenerSync {
        private final List<IBatchListener> listeners = new CopyOnWriteArrayList<IBatchListener>();
        private final List<IBatchListenerSync> listenersSync = new CopyOnWriteArrayList<IBatchListenerSync>();
        private final IBatch batch;

        protected BatchAdapter(IBatch batch) {
            this.batch = batch;
            batch.addBatchListener(this);
            batch.addBatchListenerSync(this);
        }

        @Override
        public String getName() {
            return this.batch.getName();
        }

        @Override
        public String getNameWithSequenceNumber() {
            return this.batch.getNameWithSequenceNumber();
        }

        @Override
        public Experiment getExperiment() {
            return this.batch.getExperiment();
        }

        @Override
        public Date getCreationTime() {
            return this.batch.getCreationTime();
        }

        @Override
        public String getUniqueIDString() {
            return this.batch.getUniqueIDString();
        }

        @Override
        public BatchState getBatchState() {
            return this.batch.getBatchState();
        }

        @Override
        public int getSequenceNumber() {
            return this.batch.getSequenceNumber();
        }

        @Override
        public boolean isRunningInBackground() {
            return this.batch.isRunningInBackground();
        }

        @Override
        public boolean isRunningSimulationsSequentially() {
            return this.batch.isRunningSimulationsSequentially();
        }

        @Override
        public void setRunningInBackground(boolean runningInBackground) {
            this.batch.setRunningInBackground(runningInBackground);
        }

        @Override
        public void setRunningSimulationsSequentially(boolean runningSimulationsSequentially) {
            this.batch.setRunningSimulationsSequentially(runningSimulationsSequentially);
        }

        @Override
        public void run() {
            this.batch.run();
        }

        @Override
        public void pause() {
            this.batch.pause();
        }

        @Override
        public void step() {
            this.batch.step();
        }

        @Override
        public void reset() throws ScenarioInitializationException {
            this.batch.reset();
        }

        @Override
        public void stop() {
            this.batch.stop();
        }

        @Override
        public boolean isRunning() {
            return this.batch.isRunning();
        }

        @Override
        public boolean isStoppable() {
            return this.batch.isStoppable();
        }

        @Override
        public boolean cancel() {
            return this.batch.cancel();
        }

        @Override
        public void addBatchListener(IBatchListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removeBatchListener(IBatchListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void addBatchListenerSync(IBatchListenerSync listener) {
            if (!this.listenersSync.contains(listener)) {
                this.listenersSync.add(listener);
            }
        }

        @Override
        public void removeBatchListenerSync(IBatchListenerSync listener) {
            this.listenersSync.remove(listener);
        }

        protected void fireBatchChanged(BatchState batchState) {
            final BatchEvent event = new BatchEvent(this, batchState);
            for (final IBatchListener listener : this.listeners) {
                DisplaySafeExecutor.executeAsync(new Runnable(){

                    @Override
                    public void run() {
                        listener.batchChanged(event);
                    }
                });
            }
        }

        protected void fireBatchChangedSync(BatchState batchState) {
            final BatchEvent event = new BatchEvent(this, batchState);
            for (final IBatchListenerSync listener : this.listenersSync) {
                DisplaySafeExecutor.executeSync(new Runnable(){

                    @Override
                    public void run() {
                        listener.batchChangedSync(event);
                    }
                });
            }
        }

        @Override
        public void batchChanged(BatchEvent event) {
            this.fireBatchChanged(event.getBatchState());
        }

        @Override
        public void batchChangedSync(BatchEvent event) {
            this.fireBatchChangedSync(event.getBatchState());
        }

        public String toString() {
            return this.batch.toString();
        }
    }
}

