/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen.xtext;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.codegen.xtext.ModelExpressionGenerator;
import org.eclipse.stem.model.ctdl.ContextSensitiveResourceWrapper;
import org.eclipse.stem.model.ctdl.ctdl.AbsoluteCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.BooleanLiteral;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentTransitionDefinitions;
import org.eclipse.stem.model.ctdl.ctdl.DefStatement;
import org.eclipse.stem.model.ctdl.ctdl.Div;
import org.eclipse.stem.model.ctdl.ctdl.Evaluation;
import org.eclipse.stem.model.ctdl.ctdl.Expression;
import org.eclipse.stem.model.ctdl.ctdl.ExternalFunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.FunctionCall;
import org.eclipse.stem.model.ctdl.ctdl.FunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.GlobalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.LocalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.MetamodelResource;
import org.eclipse.stem.model.ctdl.ctdl.Minus;
import org.eclipse.stem.model.ctdl.ctdl.ModelParamReference;
import org.eclipse.stem.model.ctdl.ctdl.Multi;
import org.eclipse.stem.model.ctdl.ctdl.NumberLiteral;
import org.eclipse.stem.model.ctdl.ctdl.Plus;
import org.eclipse.stem.model.ctdl.ctdl.PrimaryExpression;
import org.eclipse.stem.model.ctdl.ctdl.RelativeCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.ScopedVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.StringLiteral;
import org.eclipse.stem.model.ctdl.ctdl.TransitionBlock;
import org.eclipse.stem.model.ctdl.ctdl.VariableReference;
import org.eclipse.stem.model.ctdl.functions.FunctionArgumentReference;
import org.eclipse.stem.model.ctdl.functions.JavaMethodArgument;
import org.eclipse.stem.model.ctdl.functions.SystemArgumentReference;
import org.eclipse.stem.model.ctdl.serializer.ITypeSerializer;
import org.eclipse.stem.model.ctdl.serializer.TypeSerializerFactory;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ExpressionsClassGenerator
extends ModelExpressionGenerator {
    @Override
    public void doGenerate(List<XtextResource> resources, IFileSystemAccess fsa) {
        String _name = this.modelGenClass.getName();
        String fileName = String.valueOf(_name) + "Expressions.java";
        fsa.generateFile(fileName, this.build(resources));
    }

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), CompartmentTransitionDefinitions.class));
        MetamodelResource mm = ctd.getMetamodel();
        Transition trans = mm.getTransition();
        String _name = trans.getSource().getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = trans.getTarget().getName();
        String fname = String.valueOf(_plus) + _name_1;
        fsa.generateFile(fname, this.compile((Notifier)resource));
    }

    public CharSequence build(List<XtextResource> r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _classPackageName = this.modelGenClass.getGenPackage().getClassPackageName();
        _builder.append(_classPackageName);
        _builder.append(";");
        String pkg = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("\t\t");
        _builder_1.append("/**");
        _builder_1.newLine();
        _builder_1.append("\t\t ");
        _builder_1.append("* Generated expressions class for  ");
        String _name = this.modelGenClass.getName();
        _builder_1.append(_name, "\t\t ");
        _builder_1.append(".");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t\t ");
        _builder_1.append("* DO NOT EDIT DIRECTLY.  Use extended class and override methods for transitions as desired.");
        _builder_1.newLine();
        _builder_1.append("\t\t ");
        _builder_1.append("* @generated");
        _builder_1.newLine();
        _builder_1.append("\t\t ");
        _builder_1.append("*/");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("public class ");
        String _name_1 = this.modelGenClass.getName();
        _builder_1.append(_name_1, "\t\t");
        _builder_1.append("Expressions {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("public void calculate(double t, long timeDelta, ");
        String _importedName = this.getImportedName("org.eclipse.stem.core.model.STEMTime");
        _builder_1.append(_importedName, "\t");
        _builder_1.append(" time, ");
        String _importGenClassInterface = this.importGenClassInterface(this.modelGenClass);
        _builder_1.append(_importGenClassInterface, "\t");
        _builder_1.append(" model, ");
        String _importGenClassInterface_1 = this.importGenClassInterface(this.labelGenClass);
        _builder_1.append(_importGenClassInterface_1, "\t");
        _builder_1.append(" label, ");
        String _importGenClassInterface_2 = this.importGenClassInterface(this.labelValueGenClass);
        _builder_1.append(_importGenClassInterface_2, "\t");
        _builder_1.append(" labelValue, ");
        String _importedName_1 = this.getImportedName("org.eclipse.stem.core.graph.Node");
        _builder_1.append(_importedName_1, "\t");
        _builder_1.append(" node, ");
        String _importGenClassInterface_3 = this.importGenClassInterface(this.labelValueGenClass);
        _builder_1.append(_importGenClassInterface_3, "\t");
        _builder_1.append(" deltaValue) {");
        _builder_1.newLineIfNotEmpty();
        Set<Compartment> _affectedCompartments = this.getAffectedCompartments(r);
        for (Compartment compartment : _affectedCompartments) {
            _builder_1.append("\t\t");
            _builder_1.append("double delta");
            String _accessorName = this.getAccessorName(compartment);
            _builder_1.append(_accessorName, "\t\t");
            _builder_1.append(" = 0.0;");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("\t\t");
        _builder_1.newLine();
        Iterable _filter = Iterables.filter(r, ContextSensitiveResourceWrapper.class);
        for (ContextSensitiveResourceWrapper contextSensitiveResourceWrapper : _filter) {
            _builder_1.append("\t\t");
            _builder_1.append("// Calculate delta for transition ");
            String _formattedName = this.getFormattedName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_formattedName, "\t\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("double generated_");
            String _methodName = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName, "\t\t");
            _builder_1.append(" = ");
            String _methodName_1 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_1, "\t\t");
            _builder_1.append("(t,timeDelta,time,model,label,labelValue,label.getNode());");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("delta");
            String _accessorName_1 = this.getAccessorName(contextSensitiveResourceWrapper.getTransition().getSource());
            _builder_1.append(_accessorName_1, "\t\t");
            _builder_1.append(" -= generated_");
            String _methodName_2 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_2, "\t\t");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("delta");
            String _accessorName_2 = this.getAccessorName(contextSensitiveResourceWrapper.getTransition().getTarget());
            _builder_1.append(_accessorName_2, "\t\t");
            _builder_1.append(" += generated_");
            String _methodName_3 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_3, "\t\t");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            EList _forIncidence = contextSensitiveResourceWrapper.getTransition().getForIncidence();
            for (Compartment c : _forIncidence) {
                _builder_1.append("\t\t");
                _builder_1.append("\t");
                _builder_1.append("delta");
                String _accessorName_3 = this.getAccessorName(c);
                _builder_1.append(_accessorName_3, "\t\t\t");
                _builder_1.append(" += generated_");
                String _methodName_4 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
                _builder_1.append(_methodName_4, "\t\t\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t\t");
            _builder_1.newLine();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            _builder_1.append("// Stochastic exchange for ");
            String _formattedName_1 = this.getFormattedName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_formattedName_1, "\t\t\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            String _importedName_2 = this.getImportedName("org.eclipse.stem.core.graph.Exchange");
            _builder_1.append(_importedName_2, "\t\t\t");
            _builder_1.append(" exchange_");
            String _methodName_5 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_5, "\t\t\t");
            _builder_1.append(" = (");
            String _importedName_3 = this.getImportedName("org.eclipse.stem.core.graph.Exchange");
            _builder_1.append(_importedName_3, "\t\t\t");
            _builder_1.append(")");
            String _importedName_4 = this.getImportedName("org.eclipse.stem.core.graph.ExchangePool");
            _builder_1.append(_importedName_4, "\t\t\t");
            _builder_1.append(".POOL.get();");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            _builder_1.append("deltaValue.getDepartures().add(exchange_");
            String _methodName_6 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_6, "\t\t\t");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            _builder_1.append("exchange_");
            String _methodName_7 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_7, "\t\t\t");
            _builder_1.append(".setType(");
            String _importedName_5 = this.getImportedName("org.eclipse.stem.core.graph.ExchangeType");
            _builder_1.append(_importedName_5, "\t\t\t");
            _builder_1.append(".COMPARTMENT_TRANSITION);");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            _builder_1.append("exchange_");
            String _methodName_8 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_8, "\t\t\t");
            _builder_1.append(".setSource(");
            String _packageAccessorName = this.getPackageAccessorName(this.getGenFeature(contextSensitiveResourceWrapper.getTransition().getSource()));
            _builder_1.append(_packageAccessorName, "\t\t\t");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            _builder_1.append("exchange_");
            String _methodName_9 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_9, "\t\t\t");
            _builder_1.append(".setTarget(");
            String _packageAccessorName_1 = this.getPackageAccessorName(this.getGenFeature(contextSensitiveResourceWrapper.getTransition().getTarget()));
            _builder_1.append(_packageAccessorName_1, "\t\t\t");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
            _builder_1.append("\t");
            _builder_1.append("exchange_");
            String _methodName_10 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_10, "\t\t\t");
            _builder_1.append(".setCount(generated_");
            String _methodName_11 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
            _builder_1.append(_methodName_11, "\t\t\t");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
            EList _forIncidence_1 = contextSensitiveResourceWrapper.getTransition().getForIncidence();
            for (Compartment c_1 : _forIncidence_1) {
                _builder_1.append("\t\t");
                _builder_1.append("\t");
                _builder_1.append("exchange_");
                String _methodName_12 = this.getMethodName(contextSensitiveResourceWrapper.getTransition());
                _builder_1.append(_methodName_12, "\t\t\t");
                _builder_1.append(".getForIncidence().add(");
                String _packageAccessorName_2 = this.getPackageAccessorName(this.getGenFeature(c_1));
                _builder_1.append(_packageAccessorName_2, "\t\t\t");
                _builder_1.append(");");
                _builder_1.newLineIfNotEmpty();
            }
        }
        _builder_1.append("\t\t");
        _builder_1.newLine();
        Set<Compartment> _affectedCompartments_1 = this.getAffectedCompartments(r);
        for (Compartment compartment : _affectedCompartments_1) {
            _builder_1.append("\t\t");
            _builder_1.append("deltaValue.set");
            String _accessorName_4 = this.getAccessorName(compartment);
            _builder_1.append(_accessorName_4, "\t\t");
            _builder_1.append("(delta");
            String _accessorName_5 = this.getAccessorName(compartment);
            _builder_1.append(_accessorName_5, "\t\t");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("\t");
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("\t\t\t");
        _builder_1.newLine();
        for (XtextResource e : r) {
            CharSequence _compile = this.compile((Notifier)e);
            _builder_1.append((Object)_compile);
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("} //");
        String body = _builder_1.toString();
        String string = this.getSortedImports();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(pkg);
        _builder_2.newLineIfNotEmpty();
        _builder_2.newLine();
        _builder_2.append(string);
        _builder_2.newLineIfNotEmpty();
        _builder_2.newLine();
        _builder_2.append(body);
        return _builder_2;
    }

    protected CharSequence _compile(Resource r) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile((Notifier)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)r.getAllContents()), TransitionBlock.class)));
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compile(TransitionBlock t) {
        EObject _eContainer = t.eContainer();
        CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)_eContainer;
        Transition transition = ctd.getMetamodel().getTransition();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Computes delta for transition ");
        String _name = transition.getSource().getName();
        _builder.append(_name, " ");
        _builder.append(" -> ");
        String _name_1 = transition.getTarget().getName();
        _builder.append(_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("protected double ");
        String _name_2 = transition.getSource().getName();
        _builder.append(_name_2);
        _builder.append("_");
        String _name_3 = transition.getTarget().getName();
        _builder.append(_name_3);
        _builder.append(" (double t, long timeDelta, ");
        String _importedName = this.getImportedName("org.eclipse.stem.core.model.STEMTime");
        _builder.append(_importedName);
        _builder.append(" time, ");
        String _importGenClassInterface = this.importGenClassInterface(this.modelGenClass);
        _builder.append(_importGenClassInterface);
        _builder.append(" model, ");
        String _importGenClassInterface_1 = this.importGenClassInterface(this.labelGenClass);
        _builder.append(_importGenClassInterface_1);
        _builder.append(" label, ");
        String _importGenClassInterface_2 = this.importGenClassInterface(this.labelValueGenClass);
        _builder.append(_importGenClassInterface_2);
        _builder.append(" labelValue, ");
        String _importedName_1 = this.getImportedName("org.eclipse.stem.core.graph.Node");
        _builder.append(_importedName_1);
        _builder.append(" node) {");
        _builder.newLineIfNotEmpty();
        EList _statements = t.getBlock().getStatements();
        for (DefStatement s : _statements) {
            CharSequence _compile = this.compile((Notifier)s);
            _builder.append((Object)_compile);
        }
        _builder.newLineIfNotEmpty();
        _builder.append("return ");
        CharSequence _compile_1 = this.compile((Notifier)t.getBlock().getRet());
        _builder.append((Object)_compile_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compile(DefStatement d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("double ");
        String _varname = d.getVarname();
        _builder.append(_varname);
        _builder.append("=");
        CharSequence _compile = this.compile((Notifier)d.getExpr());
        _builder.append((Object)_compile);
        _builder.append(";");
        return _builder;
    }

    protected CharSequence _compile(Evaluation e) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(e.getExpression(), Double.TYPE);
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compile(PrimaryExpression pe, Class<?> expectedType) {
        String neg = "";
        boolean _isNegate = pe.isNegate();
        if (_isNegate) {
            neg = "-";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        _builder.append(neg);
        CharSequence _compile = this.compile(pe.getExp(), expectedType);
        _builder.append((Object)_compile);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _compile(Plus p, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _compile = this.compile(p.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("+");
        CharSequence _compile_1 = this.compile(p.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compile(Minus m, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _compile = this.compile(m.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("-");
        CharSequence _compile_1 = this.compile(m.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compile(Multi m, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(m.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("*");
        CharSequence _compile_1 = this.compile(m.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        return _builder;
    }

    protected CharSequence _compile(Div d, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(d.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("/");
        CharSequence _compile_1 = this.compile(d.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        return _builder;
    }

    protected CharSequence _compileReference(GlobalVariableReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rf.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _compileReference(LocalVariableReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rf.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _compileReference(AbsoluteCompartmentValueReference rf, Class<?> expectedType) {
        ITypeSerializer serializer = TypeSerializerFactory.getSerializer((EObject)rf, expectedType, (GenClass)this.labelValueGenClass);
        if (serializer != null) {
            return serializer.serialize();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("labelValue.get");
        String _firstUpper = StringExtensions.toFirstUpper((String)rf.getObj().getName());
        _builder.append(_firstUpper);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _compileReference(RelativeCompartmentValueReference rf, Class<?> expectedType) {
        ITypeSerializer serializer = TypeSerializerFactory.getSerializer((EObject)rf, expectedType, (GenClass)this.labelValueGenClass);
        if (serializer != null) {
            return serializer.serialize();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(labelValue.getPopulationCount() > 0)? (labelValue.get");
        String _firstUpper = StringExtensions.toFirstUpper((String)rf.getObj().getName());
        _builder.append(_firstUpper);
        _builder.append("()/labelValue.getPopulationCount()):0");
        return _builder;
    }

    protected CharSequence _compileReference(ModelParamReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("model.get");
        String _firstUpper = StringExtensions.toFirstUpper((String)rf.getObj().getName());
        _builder.append(_firstUpper);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _compile(VariableReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compileReference = this.compileReference(rf.getRef(), expectedType);
        _builder.append((Object)_compileReference);
        return _builder;
    }

    protected CharSequence _compile(NumberLiteral nl, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        double _value = nl.getValue();
        _builder.append((Object)_value);
        return _builder;
    }

    protected CharSequence _compile(StringLiteral sl, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _value = sl.getValue();
        _builder.append(_value);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _compile(BooleanLiteral bl, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isValue = bl.isValue();
        _builder.append((Object)_isValue);
        return _builder;
    }

    protected CharSequence _compile(Expression exp, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(exp.getExp(), expectedType);
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compileArgument(SystemArgumentReference arg, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _mapsFrom = arg.getMapsFrom();
        _builder.append(_mapsFrom);
        return _builder;
    }

    protected CharSequence _compileArgument(FunctionArgumentReference arg, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile((Expression)fc.getArgs().get(arg.getArgIndex()), arg.getJavaType());
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compileFunction(ExternalFunctionReference fcr, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _importedName = this.getImportedName(fcr.getFunc().getClassName());
        _builder.append(_importedName);
        _builder.append(".");
        String _methodName = fcr.getFunc().getMethodName();
        _builder.append(_methodName);
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        EList _javaMethodArguments = fcr.getFunc().getJavaMethodArguments();
        for (JavaMethodArgument arg : _javaMethodArguments) {
            boolean _notEquals;
            _builder.append("\t\t");
            JavaMethodArgument _head = (JavaMethodArgument)IterableExtensions.head((Iterable)fcr.getFunc().getJavaMethodArguments());
            boolean bl = _notEquals = !Objects.equal((Object)arg, (Object)_head);
            if (_notEquals) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            CharSequence _compileArgument = this.compileArgument(arg, fc);
            _builder.append((Object)_compileArgument, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compileFunction(FunctionReference fcr, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = fcr.getName();
        _builder.append(_name);
        _builder.append("(");
        EList _args = fc.getArgs();
        for (Expression e : _args) {
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
            Expression _head = (Expression)IterableExtensions.head((Iterable)fc.getArgs());
            boolean _equals = Objects.equal((Object)e, (Object)_head);
            if (_equals) {
                CharSequence _compile = this.compile((Notifier)e);
                _builder.append((Object)_compile);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append(",");
                CharSequence _compile_1 = this.compile((Notifier)e);
                _builder.append((Object)_compile_1);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t\t");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compile(FunctionCall fc, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compileFunction = this.compileFunction(fc.getRef(), fc);
        _builder.append((Object)_compileFunction);
        return _builder;
    }

    public CharSequence compile(Notifier e) {
        if (e instanceof Evaluation) {
            return this._compile((Evaluation)e);
        }
        if (e instanceof DefStatement) {
            return this._compile((DefStatement)e);
        }
        if (e instanceof TransitionBlock) {
            return this._compile((TransitionBlock)e);
        }
        if (e instanceof Resource) {
            return this._compile((Resource)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public CharSequence compile(Expression bl, Class<?> expectedType) {
        if (bl instanceof BooleanLiteral) {
            return this._compile((BooleanLiteral)bl, expectedType);
        }
        if (bl instanceof Div) {
            return this._compile((Div)bl, expectedType);
        }
        if (bl instanceof FunctionCall) {
            return this._compile((FunctionCall)bl, expectedType);
        }
        if (bl instanceof Minus) {
            return this._compile((Minus)bl, expectedType);
        }
        if (bl instanceof Multi) {
            return this._compile((Multi)bl, expectedType);
        }
        if (bl instanceof NumberLiteral) {
            return this._compile((NumberLiteral)bl, expectedType);
        }
        if (bl instanceof Plus) {
            return this._compile((Plus)bl, expectedType);
        }
        if (bl instanceof PrimaryExpression) {
            return this._compile((PrimaryExpression)bl, expectedType);
        }
        if (bl instanceof StringLiteral) {
            return this._compile((StringLiteral)bl, expectedType);
        }
        if (bl instanceof VariableReference) {
            return this._compile((VariableReference)bl, expectedType);
        }
        if (bl != null) {
            return this._compile(bl, expectedType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(bl, expectedType).toString());
    }

    public CharSequence compileReference(ScopedVariableReference rf, Class<?> expectedType) {
        if (rf instanceof AbsoluteCompartmentValueReference) {
            return this._compileReference((AbsoluteCompartmentValueReference)rf, expectedType);
        }
        if (rf instanceof RelativeCompartmentValueReference) {
            return this._compileReference((RelativeCompartmentValueReference)rf, expectedType);
        }
        if (rf instanceof GlobalVariableReference) {
            return this._compileReference((GlobalVariableReference)rf, expectedType);
        }
        if (rf instanceof LocalVariableReference) {
            return this._compileReference((LocalVariableReference)rf, expectedType);
        }
        if (rf instanceof ModelParamReference) {
            return this._compileReference((ModelParamReference)rf, expectedType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rf, expectedType).toString());
    }

    public CharSequence compileArgument(JavaMethodArgument arg, FunctionCall fc) {
        if (arg instanceof FunctionArgumentReference) {
            return this._compileArgument((FunctionArgumentReference)arg, fc);
        }
        if (arg instanceof SystemArgumentReference) {
            return this._compileArgument((SystemArgumentReference)arg, fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(arg, fc).toString());
    }

    public CharSequence compileFunction(FunctionReference fcr, FunctionCall fc) {
        if (fcr instanceof ExternalFunctionReference) {
            return this._compileFunction((ExternalFunctionReference)fcr, fc);
        }
        if (fcr != null) {
            return this._compileFunction(fcr, fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fcr, fc).toString());
    }
}

