/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.TransformationDecorator;
import org.eclipse.stem.core.solver.SolverException;
import org.eclipse.stem.core.solver.impl.SolverImpl;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.solvers.rk.FastRungeKutta;
import org.eclipse.stem.solvers.rk.RkPackage;
import org.eclipse.stem.solvers.rk.impl.FastRkJob;
import org.eclipse.stem.ui.Activator;

public class FastRungeKuttaImpl
extends SolverImpl
implements FastRungeKutta {
    private short num_threads = (short)2;
    private FastRkJob[] jobs;
    static double a2 = 0.2;
    static double a3 = 0.3;
    static double a4 = 0.6;
    static double a5 = 1.0;
    static double a6 = 0.875;
    static double b21 = 0.2;
    static double b31 = 0.075;
    static double b32 = 0.225;
    static double b41 = 0.3;
    static double b42 = -0.9;
    static double b43 = 1.2;
    static double b51 = -0.2037037037037037;
    static double b52 = 2.5;
    static double b53 = -2.5925925925925926;
    static double b54 = 1.2962962962962963;
    static double b61 = 0.029495804398148147;
    static double b62 = 0.341796875;
    static double b63 = 0.041594328703703706;
    static double b64 = 0.40034541377314814;
    static double b65 = 0.061767578125;
    static double c1 = 0.09788359788359788;
    static double c3 = 0.4025764895330113;
    static double c4 = 0.21043771043771045;
    static double c6 = 0.2891022021456804;
    static double dc5 = -0.019321986607142856;
    static double dc1 = c1 - 0.10217737268518519;
    static double dc3 = c3 - 0.38390790343915343;
    static double dc4 = c4 - 0.24459273726851852;
    static double dc6 = c6 - 0.25;
    static double SAFETY = 0.9;
    static double PGROW = -0.2;
    static double PSHRNK = -0.25;
    static double ERRCON = 1.89E-4;
    static double TINY = 1.0E-30;
    ArrayList<IntegrationDecorator> iDecorators = new ArrayList();
    protected static final double RELATIVE_TOLERANCE_EDEFAULT = 1.0E-9;
    protected double relativeTolerance = 1.0E-9;
    protected static final double MIN_STEP_EDEFAULT = 1.0E-15;
    protected double minStep = 1.0E-15;

    public boolean step(STEMTime time, long timeDelta, int cycle) throws SolverException {
        Activator act = Activator.getDefault();
        if (act != null) {
            IPreferenceStore preferenceStore = act.getPreferenceStore();
            this.num_threads = (short)preferenceStore.getInt("simulationThreads");
        } else {
            this.num_threads = (short)2;
        }
        this.partitioner.setNumProcesses((int)this.num_threads);
        int c = cycle;
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (!(decorator instanceof Trigger) && !(decorator instanceof TransformationDecorator)) continue;
            decorator.updateLabels(time, timeDelta, cycle);
        }
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            EList allLabels = this.partitioner.partitionDecoratorLabels(decorator);
            Iterator currentStateLabelIter = allLabels.iterator();
            while (currentStateLabelIter.hasNext()) {
                if (decorator instanceof IntegrationDecorator) {
                    IntegrationLabel iLabel = (IntegrationLabel)currentStateLabelIter.next();
                    ((IntegrationLabelValue)iLabel.getCurrentValue()).prepareCycle();
                    iLabel.getProbeValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    continue;
                }
                currentStateLabelIter.next();
            }
        }
        if (this.jobs == null || this.jobs.length != this.num_threads) {
            this.jobs = new FastRkJob[this.num_threads];
            short i = 0;
            while (i < this.num_threads) {
                short threadnum = i;
                this.jobs[i] = new FastRkJob("Worker " + i, threadnum, this);
                this.jobs[i].setSystem(true);
                i = (short)(i + 1);
            }
        }
        FastRkJob[] fastRkJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            FastRkJob j = fastRkJobArray[n2];
            j.cycle = c;
            j.time = time;
            j.timeDelta = timeDelta;
            ++n2;
        }
        fastRkJobArray = this.jobs;
        n = this.jobs.length;
        n2 = 0;
        while (n2 < n) {
            FastRkJob j = fastRkJobArray[n2];
            j.schedule();
            ++n2;
        }
        fastRkJobArray = this.jobs;
        n = this.jobs.length;
        n2 = 0;
        while (n2 < n) {
            FastRkJob j = fastRkJobArray[n2];
            try {
                j.join();
                if (j.getResult().getException() != null) {
                    throw new SolverException(j.getResult().getException().getMessage(), null, j.getResult().getException());
                }
            }
            catch (InterruptedException ie) {
                Activator.logError((String)ie.getMessage(), (Throwable)ie);
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double _step(STEMTime time, long timeDelta, int cycle, short threadnum, double h) {
        ArrayList<IntegrationDecorator> arrayList = this.iDecorators;
        synchronized (arrayList) {
            IntegrationLabel diseaseLabel;
            EList labs;
            Decorator sdm;
            if (this.iDecorators.isEmpty()) {
                ArrayList<Decorator> transDecorators = new ArrayList<Decorator>();
                for (Decorator d : this.getCanonicalGraph().getDecorators()) {
                    if (d instanceof IntegrationDecorator) {
                        this.iDecorators.add((IntegrationDecorator)d);
                    }
                    if (!(d instanceof TransformationDecorator)) continue;
                    transDecorators.add(d);
                }
            }
            double x = (double)cycle - 1.0;
            double end = x + 1.0;
            boolean workToDo = false;
            int i = 0;
            while (i < this.iDecorators.size()) {
                Decorator sdm2 = (Decorator)this.iDecorators.get(i);
                if (this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum).size() > 0) {
                    workToDo = true;
                    break;
                }
                ++i;
            }
            if (!workToDo) {
                return h;
            }
            HashMap<IntegrationLabel, IntegrationLabelValue> k1map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            HashMap<IntegrationLabel, IntegrationLabelValue> k2map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            HashMap<IntegrationLabel, IntegrationLabelValue> k3map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            HashMap<IntegrationLabel, IntegrationLabelValue> k4map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            HashMap<IntegrationLabel, IntegrationLabelValue> k5map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            HashMap<IntegrationLabel, IntegrationLabelValue> k6map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            HashMap<EClass, Object> _k1Placeholdes = new HashMap<EClass, Object>();
            HashMap<EClass, Object> _k2Placeholdes = new HashMap<EClass, Object>();
            HashMap<EClass, Object> _k3Placeholdes = new HashMap<EClass, Object>();
            HashMap<EClass, Object> _k4Placeholdes = new HashMap<EClass, Object>();
            HashMap<EClass, Object> _k5Placeholdes = new HashMap<EClass, Object>();
            HashMap<EClass, Object> _k6Placeholdes = new HashMap<EClass, Object>();
            HashMap<IntegrationLabel, IntegrationLabelValue> finalEstimate = new HashMap<IntegrationLabel, IntegrationLabelValue>();
            double delta = 0.0;
            int i2 = 0;
            while (i2 < this.iDecorators.size()) {
                sdm = (Decorator)this.iDecorators.get(i2);
                Iterator iter = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum).iterator();
                if (!iter.hasNext()) {
                    Activator.logError((String)("Problem detected: Decorator " + sdm + " had no labels to update. Please check your scenario."), (Throwable)new Exception());
                } else if (sdm instanceof DiseaseModel) {
                    DiseaseModel diseaseModel = (DiseaseModel)sdm;
                    for (String id : diseaseModel.getAllLabelIdentifiers()) {
                        DiseaseModelLabel label = diseaseModel.createDiseaseModelLabel(id);
                        if (!_k1Placeholdes.containsKey(label.eClass())) {
                            _k1Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                        }
                        if (!_k2Placeholdes.containsKey(label.eClass())) {
                            _k2Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                        }
                        if (!_k3Placeholdes.containsKey(label.eClass())) {
                            _k3Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                        }
                        if (!_k4Placeholdes.containsKey(label.eClass())) {
                            _k4Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                        }
                        if (!_k5Placeholdes.containsKey(label.eClass())) {
                            _k5Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                        }
                        if (_k6Placeholdes.containsKey(label.eClass())) continue;
                        _k6Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                    }
                } else {
                    IntegrationLabel firstLabel = (IntegrationLabel)iter.next();
                    if (!_k1Placeholdes.containsKey(firstLabel.eClass())) {
                        _k1Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                    }
                    if (!_k2Placeholdes.containsKey(firstLabel.eClass())) {
                        _k2Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                    }
                    if (!_k3Placeholdes.containsKey(firstLabel.eClass())) {
                        _k3Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                    }
                    if (!_k4Placeholdes.containsKey(firstLabel.eClass())) {
                        _k4Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                    }
                    if (!_k5Placeholdes.containsKey(firstLabel.eClass())) {
                        _k5Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                    }
                    if (!_k6Placeholdes.containsKey(firstLabel.eClass())) {
                        _k6Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                    }
                }
                ++i2;
            }
            while (x < end) {
                IntegrationLabel diseaseLabel2;
                EList labs2;
                Decorator sdm3;
                IntegrationLabelValue k4;
                IntegrationLabelValue k3;
                IntegrationLabelValue k2;
                IntegrationLabelValue k1;
                IntegrationLabelValue deltaLabel;
                k1map.clear();
                k2map.clear();
                k3map.clear();
                k4map.clear();
                k5map.clear();
                k6map.clear();
                finalEstimate.clear();
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).calculateDeltas(time, x, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).applyExternalDeltas(time, x, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        IntegrationLabelValue scale = diseaseLabel.getErrorScale();
                        scale.set((IntegrationLabelValue)diseaseLabel.getCurrentValue());
                        IntegrationLabelValue dt = diseaseLabel.getDeltaValue().copy();
                        dt.scale(h);
                        dt.abs();
                        dt.add(TINY);
                        scale.abs();
                        scale.add(dt);
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        deltaLabel = diseaseLabel.getDeltaValue();
                        IntegrationLabelValue copyVal = deltaLabel.copy();
                        k1map.put(diseaseLabel, copyVal);
                        deltaLabel.scale(h);
                        deltaLabel.scale(b21);
                        diseaseLabel.getProbeValue().set(deltaLabel.add((IntegrationLabelValue)diseaseLabel.getCurrentValue()));
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).calculateDeltas(time, x + a2 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).applyExternalDeltas(time, x + a2 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        deltaLabel = diseaseLabel.getDeltaValue();
                        k2map.put(diseaseLabel, deltaLabel.copy());
                        k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel.eClass());
                        k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel.eClass());
                        k1.set((IntegrationLabelValue)k1map.get(diseaseLabel));
                        k2.set(deltaLabel);
                        IntegrationLabelValue estDelta = k1.scale(b31);
                        k2.scale(b32);
                        estDelta.add(k2);
                        estDelta.scale(h);
                        diseaseLabel.getProbeValue().set(estDelta.add((IntegrationLabelValue)diseaseLabel.getCurrentValue()));
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).calculateDeltas(time, x + a3 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).applyExternalDeltas(time, x + a3 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        deltaLabel = diseaseLabel.getDeltaValue();
                        k3map.put(diseaseLabel, deltaLabel.copy());
                        k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel.eClass());
                        k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel.eClass());
                        k3 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel.eClass());
                        k1.set((IntegrationLabelValue)k1map.get(diseaseLabel));
                        k2.set((IntegrationLabelValue)k2map.get(diseaseLabel));
                        k3.set(deltaLabel);
                        k1.scale(b41);
                        k2.scale(b42);
                        k3.scale(b43);
                        IntegrationLabelValue estDelta = k1;
                        estDelta.add(k2);
                        estDelta.add(k3);
                        estDelta.scale(h);
                        diseaseLabel.getProbeValue().set(estDelta.add((IntegrationLabelValue)diseaseLabel.getCurrentValue()));
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).calculateDeltas(time, x + a4 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).applyExternalDeltas(time, x + a4 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        deltaLabel = diseaseLabel.getDeltaValue();
                        k4map.put(diseaseLabel, deltaLabel.copy());
                        k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel.eClass());
                        k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel.eClass());
                        k3 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel.eClass());
                        k4 = (IntegrationLabelValue)_k4Placeholdes.get(diseaseLabel.eClass());
                        k1.set((IntegrationLabelValue)k1map.get(diseaseLabel));
                        k2.set((IntegrationLabelValue)k2map.get(diseaseLabel));
                        k3.set((IntegrationLabelValue)k3map.get(diseaseLabel));
                        k4.set(deltaLabel);
                        k1.scale(b51);
                        k2.scale(b52);
                        k3.scale(b53);
                        k4.scale(b54);
                        IntegrationLabelValue estDelta = k1;
                        estDelta.add(k2);
                        estDelta.add(k3);
                        estDelta.add(k4);
                        estDelta.scale(h);
                        diseaseLabel.getProbeValue().set(estDelta.add((IntegrationLabelValue)diseaseLabel.getCurrentValue()));
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).calculateDeltas(time, x + a5 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).applyExternalDeltas(time, x + a5 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        deltaLabel = diseaseLabel.getDeltaValue();
                        k5map.put(diseaseLabel, deltaLabel.copy());
                        k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel.eClass());
                        k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel.eClass());
                        k3 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel.eClass());
                        k4 = (IntegrationLabelValue)_k4Placeholdes.get(diseaseLabel.eClass());
                        IntegrationLabelValue k5 = (IntegrationLabelValue)_k5Placeholdes.get(diseaseLabel.eClass());
                        k1.set((IntegrationLabelValue)k1map.get(diseaseLabel));
                        k2.set((IntegrationLabelValue)k2map.get(diseaseLabel));
                        k3.set((IntegrationLabelValue)k3map.get(diseaseLabel));
                        k4.set((IntegrationLabelValue)k4map.get(diseaseLabel));
                        k5.set(deltaLabel);
                        k1.scale(b61);
                        k2.scale(b62);
                        k3.scale(b63);
                        k4.scale(b64);
                        k5.scale(b65);
                        IntegrationLabelValue estDelta = k1;
                        estDelta.add(k2);
                        estDelta.add(k3);
                        estDelta.add(k4);
                        estDelta.add(k5);
                        estDelta.scale(h);
                        diseaseLabel.getProbeValue().set(estDelta.add((IntegrationLabelValue)diseaseLabel.getCurrentValue()));
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).calculateDeltas(time, x + a6 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    ((IntegrationDecorator)sdm).applyExternalDeltas(time, x + a6 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum));
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.iDecorators.size()) {
                    sdm = (Decorator)this.iDecorators.get(i2);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j = 0;
                    while (j < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j);
                        deltaLabel = diseaseLabel.getDeltaValue();
                        k6map.put(diseaseLabel, deltaLabel.copy());
                        ++j;
                    }
                    ++i2;
                }
                boolean success = true;
                double maxerror = 0.0;
                int i3 = 0;
                while (i3 < this.iDecorators.size()) {
                    sdm3 = (Decorator)this.iDecorators.get(i3);
                    labs2 = this.partitioner.partitionDecoratorLabels(sdm3, (int)threadnum);
                    int j = 0;
                    while (j < labs2.size()) {
                        diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                        IntegrationLabelValue currentValue = (IntegrationLabelValue)diseaseLabel2.getCurrentValue();
                        IntegrationLabelValue k12 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel2.eClass());
                        IntegrationLabelValue k32 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel2.eClass());
                        IntegrationLabelValue k42 = (IntegrationLabelValue)_k4Placeholdes.get(diseaseLabel2.eClass());
                        IntegrationLabelValue k5 = (IntegrationLabelValue)_k5Placeholdes.get(diseaseLabel2.eClass());
                        IntegrationLabelValue k6 = (IntegrationLabelValue)_k6Placeholdes.get(diseaseLabel2.eClass());
                        k12.set((IntegrationLabelValue)k1map.get(diseaseLabel2));
                        k32.set((IntegrationLabelValue)k3map.get(diseaseLabel2));
                        k42.set((IntegrationLabelValue)k4map.get(diseaseLabel2));
                        k5.set((IntegrationLabelValue)k5map.get(diseaseLabel2));
                        k6.set((IntegrationLabelValue)k6map.get(diseaseLabel2));
                        k12.scale(c1);
                        k32.scale(c3);
                        k42.scale(c4);
                        k6.scale(c6);
                        IntegrationLabelValue yout = k12.add(k32).add(k42).add(k6).copy();
                        yout.scale(h);
                        yout.add(currentValue);
                        k12.set((IntegrationLabelValue)k1map.get(diseaseLabel2));
                        k32.set((IntegrationLabelValue)k3map.get(diseaseLabel2));
                        k42.set((IntegrationLabelValue)k4map.get(diseaseLabel2));
                        k5.set((IntegrationLabelValue)k5map.get(diseaseLabel2));
                        k6.set((IntegrationLabelValue)k6map.get(diseaseLabel2));
                        k12.scale(dc1);
                        k32.scale(dc3);
                        k42.scale(dc4);
                        k5.scale(dc5);
                        k6.scale(dc6);
                        IntegrationLabelValue yerror = k12.add(k32).add(k42).add(k5).add(k6).copy();
                        yerror.scale(h);
                        yerror.divide(diseaseLabel2.getErrorScale());
                        yerror.abs();
                        double error = yerror.max();
                        error /= this.getRelativeTolerance();
                        if (h < this.getMinStep()) {
                            error = ERRCON;
                        }
                        if (error > maxerror) {
                            maxerror = error;
                        }
                        if (error <= 1.0) {
                            finalEstimate.put(diseaseLabel2, yout.copy());
                        } else {
                            success = false;
                        }
                        ++j;
                    }
                    ++i3;
                }
                this.jobs[threadnum].h = h;
                if (success) {
                    x += h;
                    h = maxerror > ERRCON ? SAFETY * h * Math.pow(maxerror, PGROW) : (h *= 5.0);
                    if (h > 1.0) {
                        h = 1.0;
                    }
                    if (x < end && x + h > end) {
                        h = end - x;
                    }
                    i3 = 0;
                    while (i3 < this.iDecorators.size()) {
                        sdm3 = (Decorator)this.iDecorators.get(i3);
                        labs2 = this.partitioner.partitionDecoratorLabels(sdm3, (int)threadnum);
                        int j = 0;
                        while (j < labs2.size()) {
                            diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                            ((IntegrationLabelValue)diseaseLabel2.getCurrentValue()).set((IntegrationLabelValue)finalEstimate.get(diseaseLabel2));
                            diseaseLabel2.getProbeValue().set((IntegrationLabelValue)finalEstimate.get(diseaseLabel2));
                            ++j;
                        }
                        ++i3;
                    }
                    continue;
                }
                delta = SAFETY * h * Math.pow(maxerror, PSHRNK);
                h = h > 0.0 ? (delta > 0.1 * h ? delta : 0.1 * h) : (delta > 0.1 * h ? 0.1 * h : delta);
                i3 = 0;
                while (i3 < this.iDecorators.size()) {
                    sdm3 = (Decorator)this.iDecorators.get(i3);
                    labs2 = this.partitioner.partitionDecoratorLabels(sdm3, (int)threadnum);
                    int j = 0;
                    while (j < labs2.size()) {
                        diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                        diseaseLabel2.getProbeValue().set((IntegrationLabelValue)diseaseLabel2.getCurrentValue());
                        ++j;
                    }
                    ++i3;
                }
            }
            this.jobs[threadnum].t = x;
            this.jobs[threadnum].h = h;
            i2 = 0;
            while (i2 < this.iDecorators.size()) {
                sdm = this.iDecorators.get(i2);
                labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                int j = 0;
                while (j < labs.size()) {
                    diseaseLabel = (IntegrationLabel)labs.get(j);
                    IntegrationLabelValue nextState = (IntegrationLabelValue)diseaseLabel.getNextValue();
                    IntegrationLabelValue newValue = (IntegrationLabelValue)finalEstimate.get(diseaseLabel);
                    nextState.set(newValue);
                    if (sdm.isAddStochasticNoise()) {
                        sdm.doStochasticProcess(diseaseLabel, timeDelta);
                    }
                    diseaseLabel.setNextValueValid(true);
                    ++j;
                }
                ++i2;
            }
        }
        return h;
    }

    public void reset() {
        this.setInitialized(false);
        this.iDecorators.clear();
    }

    protected EClass eStaticClass() {
        return RkPackage.Literals.FAST_RUNGE_KUTTA;
    }

    @Override
    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    @Override
    public void setRelativeTolerance(double newRelativeTolerance) {
        double oldRelativeTolerance = this.relativeTolerance;
        this.relativeTolerance = newRelativeTolerance;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldRelativeTolerance, this.relativeTolerance));
        }
    }

    @Override
    public double getMinStep() {
        return this.minStep;
    }

    @Override
    public void setMinStep(double newMinStep) {
        double oldMinStep = this.minStep;
        this.minStep = newMinStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldMinStep, this.minStep));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getRelativeTolerance();
            }
            case 6: {
                return this.getMinStep();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setRelativeTolerance((Double)newValue);
                return;
            }
            case 6: {
                this.setMinStep((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setRelativeTolerance(1.0E-9);
                return;
            }
            case 6: {
                this.setMinStep(1.0E-15);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.relativeTolerance != 1.0E-9;
            }
            case 6: {
                return this.minStep != 1.0E-15;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (relativeTolerance: ");
        result.append(this.relativeTolerance);
        result.append(", minStep: ");
        result.append(this.minStep);
        result.append(')');
        return result.toString();
    }
}

