/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.List;
import org.eclipse.stem.ui.widgets.MatrixEditorWidget;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MatrixEditorDialog
extends Dialog {
    private short rows;
    private short columns;
    private String[] rowNames;
    private String[] colNames;
    private boolean fixedSize;
    private String title;
    MatrixEditorWidget.MatrixEditorValidator validator = null;
    boolean cancelPressed = false;
    String[] existingVals = null;

    public MatrixEditorDialog(Shell parent, int style, String title, short rows, short columns, String[] rownames, String[] columnNames, String[] existingVals, boolean fixedSize, MatrixEditorWidget.MatrixEditorValidator validator) {
        super(parent, style);
        this.rows = rows;
        this.columns = columns;
        this.rowNames = rownames;
        this.colNames = columnNames;
        this.validator = validator;
        this.title = title;
        this.fixedSize = fixedSize;
        this.existingVals = existingVals;
    }

    public String[] open() {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67680);
        shell.setText(this.title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        shell.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        MatrixEditorWidget widget = new MatrixEditorWidget((Composite)shell, 0, this.rows, this.columns, this.rowNames, this.colNames, this.existingVals, this.fixedSize, this.validator);
        widget.setLayoutData(gd);
        final Button okayButton = new Button((Composite)shell, 0);
        gd = new GridData();
        okayButton.setText(Messages.getString("Matrix.dialog.okay"));
        okayButton.setLayoutData((Object)gd);
        Button cancelButton = new Button((Composite)shell, 0);
        gd = new GridData();
        cancelButton.setText(Messages.getString("Matrix.dialog.cancel"));
        cancelButton.setLayoutData((Object)gd);
        shell.pack();
        shell.open();
        widget.addListener(new MatrixEditorWidget.MatrixEditorListener(){

            @Override
            public void eventReceived(MatrixEditorWidget.MatrixEditorEvent event) {
                if (event.status == MatrixEditorWidget.STATUS.INVALID_VALUE) {
                    okayButton.setEnabled(false);
                } else {
                    okayButton.setEnabled(true);
                }
            }
        });
        okayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                MatrixEditorDialog.this.cancelPressed = false;
                shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                MatrixEditorDialog.this.cancelPressed = true;
                shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.cancelPressed) {
            String[] res = new String[widget.getTextValues().size()];
            int i = 0;
            for (String t : widget.getTextValues()) {
                res[i++] = t;
            }
            return res;
        }
        return null;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        String[] cn = new String[]{"Population Group"};
        MatrixEditorDialog dialog = new MatrixEditorDialog(shell, 8, "Enter stuff", 1, 1, null, cn, null, false, new MatrixEditorWidget.MatrixEditorValidator(){

            @Override
            public boolean validateValue(String val) {
                if (val == null || val.trim().equals("")) {
                    return true;
                }
                try {
                    Double.parseDouble(val.trim());
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                return true;
            }

            @Override
            public boolean validateAllValues(List<Text> vals) {
                return true;
            }
        });
        dialog.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

