/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.Calendar;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.EarthScienceLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.populationmodels.standard.MosquitoPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.PopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelValueImpl;

public class MosquitoPopulationModelImpl
extends PopulationModelImpl
implements MosquitoPopulationModel {
    static final double TRAP_AREA = 0.007853981633974483;
    static double MAX_BITE_RATE = 0.0;
    static final double MISSING_DATA = 99999.0;
    static final int REPEAT_ES_YEAR_CYCLES = 10;
    protected static final double SCALING_FACTOR_EDEFAULT = 1.0;
    static double maxPerPersonDen = 0.0;
    static double maxAreaTrapCount = 0.0;
    static double maxPop = 0.0;
    static double maxHumans = 1.0;
    protected double scalingFactor = 1.0;
    protected static final double MORTALITY_RATE_EDEFAULT = 0.05;
    protected double mortalityRate = 0.05;
    protected static final String HOST_EDEFAULT = "human";
    protected String host = "human";
    SortedSet<Double> densities = new TreeSet<Double>();
    double totalTemp;
    double totalRainfal;
    int totalRegions;

    @Override
    public PopulationModelLabel createPopulationModelLabel(String populationIdentifier) {
        StandardPopulationModelLabel retValue = StandardFactory.eINSTANCE.createStandardPopulationModelLabel();
        retValue.setTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        return retValue;
    }

    @Override
    public PopulationModelLabelValue createPopulationModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createStandardPopulationModelLabelValue();
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int year;
        this.totalRainfal = 0.0;
        this.totalRegions = 0;
        this.totalTemp = 0.0;
        Calendar c = Calendar.getInstance();
        long iPart = (long)t;
        double fPart = t - (double)iPart;
        long fracMillis = (long)((double)timeDelta * fPart);
        STEMTime actualTime = time.addIncrement(fracMillis);
        c.setTime(actualTime.getTime());
        int month = c.get(2);
        int nextMonth = month + 1;
        int nextMonthYear = year = c.get(1);
        if (nextMonth > 11) {
            nextMonth = 0;
            nextMonthYear = year + 1;
        }
        double dayOfMonth = c.get(5);
        double hourOfDay = c.get(11);
        double minOfHour = c.get(12);
        double secondOfMinute = c.get(13);
        double daysInMonth = c.getActualMaximum(5);
        double preciseDayInMonth = dayOfMonth + hourOfDay / 24.0 + minOfHour / 1440.0 + secondOfMinute / 86400.0;
        double fraction = (preciseDayInMonth -= 1.0) / daysInMonth;
        for (DynamicLabel label : labels) {
            double births;
            StandardPopulationModelLabelImpl slabel = (StandardPopulationModelLabelImpl)label;
            if (this.checkAndAdjustForNegative(slabel)) continue;
            StandardPopulationModelLabelValueImpl delta = (StandardPopulationModelLabelValueImpl)slabel.getDeltaValue();
            StandardPopulationModelLabelValue current = (StandardPopulationModelLabelValue)slabel.getProbeValue();
            double currentPopulation = current.getCount();
            Node n = slabel.getNode();
            double elevation = 0.0;
            double temperature = 0.0;
            double rainfall = 0.0;
            double vegetation = 0.0;
            double temperature0 = 0.0;
            double rainfall0 = 0.0;
            double vegetation0 = 0.0;
            double temperature1 = 0.0;
            double rainfall1 = 0.0;
            double vegetation1 = 0.0;
            double area = -1.0;
            HashMap<Integer, EarthScienceLabel> tempES = new HashMap<Integer, EarthScienceLabel>();
            HashMap<Integer, EarthScienceLabel> rainES = new HashMap<Integer, EarthScienceLabel>();
            HashMap<Integer, EarthScienceLabel> vegES = new HashMap<Integer, EarthScienceLabel>();
            EarthScienceLabel firstTempES = null;
            EarthScienceLabel firstRainES = null;
            EarthScienceLabel firstVegES = null;
            for (NodeLabel nl : n.getLabels()) {
                if (nl instanceof AreaLabel) {
                    area = ((AreaLabel)nl).getCurrentAreaValue().getArea();
                    continue;
                }
                if (nl instanceof PopulationLabel) {
                    String popType = ((PopulationLabel)nl).getPopulationIdentifier();
                    popType.equalsIgnoreCase(HOST_EDEFAULT);
                    continue;
                }
                if (nl instanceof EarthScienceLabel && ((EarthScienceLabel)nl).getCurrentEarthScienceValue().getDataType().equals("elevation")) {
                    elevation = (Double)((EarthScienceLabel)nl).getCurrentEarthScienceValue().getMean().get(0);
                    continue;
                }
                if (nl instanceof EarthScienceLabel && ((EarthScienceLabel)nl).getCurrentEarthScienceValue().getDataType().equals("nighttemp")) {
                    if (firstTempES == null) {
                        firstTempES = (EarthScienceLabel)nl;
                    }
                    tempES.put(((EarthScienceLabel)nl).getCurrentEarthScienceValue().getValidYear() % 10, (EarthScienceLabel)nl);
                    continue;
                }
                if (nl instanceof EarthScienceLabel && ((EarthScienceLabel)nl).getCurrentEarthScienceValue().getDataType().equals("rainfall")) {
                    if (firstRainES == null) {
                        firstRainES = (EarthScienceLabel)nl;
                    }
                    rainES.put(((EarthScienceLabel)nl).getCurrentEarthScienceValue().getValidYear() % 10, (EarthScienceLabel)nl);
                    continue;
                }
                if (!(nl instanceof EarthScienceLabel) || !((EarthScienceLabel)nl).getCurrentEarthScienceValue().getDataType().equals("vegetation")) continue;
                if (firstVegES == null) {
                    firstVegES = (EarthScienceLabel)nl;
                }
                vegES.put(((EarthScienceLabel)nl).getCurrentEarthScienceValue().getValidYear() % 10, (EarthScienceLabel)nl);
            }
            int modYear = year % 10;
            int modNextMonthYear = nextMonthYear % 10;
            EarthScienceLabel eslYear = (EarthScienceLabel)tempES.get(modYear);
            EarthScienceLabel eslNextMonthYear = (EarthScienceLabel)tempES.get(modNextMonthYear);
            if (eslYear == null) {
                eslYear = firstTempES;
            }
            if (eslNextMonthYear == null) {
                eslNextMonthYear = firstTempES;
            }
            if (eslYear != null && eslNextMonthYear != null) {
                temperature0 = (Double)eslYear.getCurrentEarthScienceValue().getMean().get(month);
                temperature1 = (Double)eslNextMonthYear.getCurrentEarthScienceValue().getMean().get(nextMonth);
                temperature = fraction * temperature1 + (1.0 - fraction) * temperature0;
            }
            eslYear = (EarthScienceLabel)rainES.get(modYear);
            eslNextMonthYear = (EarthScienceLabel)rainES.get(modNextMonthYear);
            if (eslYear == null) {
                eslYear = firstRainES;
            }
            if (eslNextMonthYear == null) {
                eslNextMonthYear = firstRainES;
            }
            if (eslYear != null && eslNextMonthYear != null) {
                rainfall0 = (Double)eslYear.getCurrentEarthScienceValue().getMean().get(month);
                rainfall1 = (Double)eslNextMonthYear.getCurrentEarthScienceValue().getMean().get(nextMonth);
                rainfall = fraction * rainfall1 + (1.0 - fraction) * rainfall0;
            }
            eslYear = (EarthScienceLabel)vegES.get(modYear);
            eslNextMonthYear = (EarthScienceLabel)vegES.get(modNextMonthYear);
            if (eslYear == null) {
                eslYear = firstVegES;
            }
            if (eslNextMonthYear == null) {
                eslNextMonthYear = firstVegES;
            }
            if (eslYear != null && eslNextMonthYear != null) {
                vegetation0 = (Double)eslYear.getCurrentEarthScienceValue().getMean().get(month);
                vegetation1 = (Double)eslNextMonthYear.getCurrentEarthScienceValue().getMean().get(nextMonth);
                vegetation = fraction * vegetation1 + (1.0 - fraction) * vegetation0;
            }
            double ElEVATION_PEAK = 400.0;
            double eFactor = 0.0;
            if (elevation <= 400.0) {
                eFactor = 1.0;
            } else {
                double ELEVATION_DOWN_SLOPE = -0.00125;
                eFactor = Math.max(0.0, 1.0 + -0.00125 * (elevation - 400.0));
            }
            double rFactor = rainfall;
            double tFactor = (-4.4 + 1.31 * temperature - 0.03 * Math.pow(temperature, 2.0)) * (0.00554 * temperature - 0.06737);
            tFactor = temperature < 16.0 || temperature > 40.0 ? 0.0 : tFactor;
            double vFactor = Math.max(0.0, vegetation - 0.3);
            vFactor = 1.0;
            double mosquitoArealDensity = this.getScalingFactor() * (eFactor * tFactor) * (vFactor * rFactor);
            mosquitoArealDensity += 1.14;
            StandardPopulationModelLabel pml = this.findStandardPopulationModelLabel(n, this.getHost());
            double numHuman = 0.0;
            if (pml != null) {
                numHuman = ((StandardPopulationModelLabelValue)pml.getTempValue()).getCount();
            }
            double humanArealDensity = numHuman / area;
            double feedingMosquitos = mosquitoArealDensity * 0.007853981633974483;
            double humansPerTrapArea = humanArealDensity * 0.007853981633974483;
            double feedingMosquitosPerPerson = 0.0;
            double mosquitoScaling = 1.0;
            if (humansPerTrapArea < 1.0) {
                mosquitoScaling = humansPerTrapArea;
            }
            feedingMosquitos *= mosquitoScaling;
            if (humansPerTrapArea > 0.0) {
                feedingMosquitosPerPerson = feedingMosquitos / humansPerTrapArea;
            }
            double newPopulation = mosquitoArealDensity;
            double pdelta = newPopulation - currentPopulation;
            if (currentPopulation == 0.0 && pdelta < 0.0) {
                System.out.println("Problem");
            }
            double adjustedMortalityRate = this.getMortalityRate() * ((double)timeDelta / (double)this.getTimePeriod());
            double deaths = births = current.getCount() * adjustedMortalityRate;
            if (pdelta > 0.0) {
                births += pdelta;
            } else if ((births += pdelta) < 0.0) {
                deaths -= births;
                births = 0.0;
            }
            delta.setCount(pdelta);
            delta.setBirths(births);
            delta.setDeaths(deaths);
            this.computeAdditionalDeltasAndExchanges(slabel, time, t, timeDelta);
        }
    }

    StandardPopulationModelLabel findStandardPopulationModelLabel(Node n, String identifier) {
        for (NodeLabel nl : n.getLabels()) {
            if (!(nl instanceof StandardPopulationModelLabel) || !((StandardPopulationModelLabel)nl).getPopulationIdentifier().equals(identifier)) continue;
            return (StandardPopulationModelLabel)nl;
        }
        return null;
    }

    public boolean isDeterministic() {
        return true;
    }

    public void doModelSpecificAdjustments(LabelValue label) {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.MOSQUITO_POPULATION_MODEL;
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public void setScalingFactor(double newScalingFactor) {
        this.scalingFactor = newScalingFactor;
    }

    @Override
    public double getMortalityRate() {
        return this.mortalityRate;
    }

    @Override
    public void setMortalityRate(double newMortalityRate) {
        this.mortalityRate = newMortalityRate;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String newHost) {
        this.host = newHost;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getScalingFactor();
            }
            case 17: {
                return this.getMortalityRate();
            }
            case 18: {
                return this.getHost();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setScalingFactor((Double)newValue);
                return;
            }
            case 17: {
                this.setMortalityRate((Double)newValue);
                return;
            }
            case 18: {
                this.setHost((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setScalingFactor(1.0);
                return;
            }
            case 17: {
                this.setMortalityRate(0.05);
                return;
            }
            case 18: {
                this.setHost(HOST_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.scalingFactor != 1.0;
            }
            case 17: {
                return this.mortalityRate != 0.05;
            }
            case 18: {
                return HOST_EDEFAULT == null ? this.host != null : !HOST_EDEFAULT.equals(this.host);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (scalingFactor: ");
        result.append(this.scalingFactor);
        result.append(", mortalityRate: ");
        result.append(this.mortalityRate);
        result.append(", host: ");
        result.append(this.host);
        result.append(')');
        return result.toString();
    }
}

