/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.webapp.IFilter;

public class BreadcrumbsFilter
implements IFilter {
    private static final String HEAD_CONTENT1 = "\n<link rel=\"stylesheet\" href=\"";
    private static final String HEAD_CONTENT2 = "/content/org.eclipse.help.webapp/advanced/breadcrumbs.css\" charset=\"ISO-8859-1\" type=\"text/css\"></link>\n<script type=\"text/javascript\" src=\"";
    private static final String HEAD_CONTENT3 = "/content/org.eclipse.help/livehelp.js\"> </script>";

    @Override
    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        String uri = req.getRequestURI();
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm") && !UrlUtil.isNavPath(uri)) {
            return out;
        }
        if ("/rtopic".equals(req.getServletPath()) || "/nftopic".equals(req.getServletPath())) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        if ("true".equals(req.getParameter("noframes"))) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        String servletPath = req.getServletPath();
        if (pathInfo == null || servletPath == null) {
            return out;
        }
        boolean showBreadcrumbs = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "showBreadcrumbs", false, null);
        if (!showBreadcrumbs) {
            return out;
        }
        String locale = UrlUtil.getLocale(req, null);
        String pathParam = req.getParameter("cp");
        String breadcrumbPath = pathParam != null && pathParam.length() > 0 ? "/nav/" + pathParam : String.valueOf(servletPath) + pathInfo;
        int[] path = UrlUtil.getTopicPath(breadcrumbPath, locale);
        if (path != null && path.length > 1) {
            try {
                boolean isNarrow = "/ntopic".equals(req.getServletPath());
                String backpath = this.getBackpath(pathInfo);
                String bodyContent = this.getBodyContent(path, backpath, isNarrow, locale);
                String headContent = HEAD_CONTENT1 + backpath + HEAD_CONTENT2 + backpath + HEAD_CONTENT3;
                return new FilterHTMLHeadAndBodyOutputStream(out, headContent.getBytes(StandardCharsets.US_ASCII), bodyContent);
            }
            catch (Exception exception) {
                return out;
            }
        }
        return out;
    }

    private String getBackpath(String path) {
        int num = new Path(path).segmentCount();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < num) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append("..");
            ++i;
        }
        return buf.toString();
    }

    private String getBodyContent(int[] path, String backPath, boolean isNarrow, String locale) {
        StringBuilder buf = new StringBuilder();
        StringBuilder pathBuf = new StringBuilder();
        ITopic topic = HelpPlugin.getTocManager().getTocs(locale)[path[0]].getTopic(null);
        pathBuf.append(path[0]);
        boolean isMirrored = ProductPreferences.isRTL();
        if (isMirrored) {
            buf.append("\u202b");
        }
        buf.append("<div class=\"help_breadcrumbs\">");
        int i = 0;
        while (i < path.length - 1) {
            buf.append("<a href=\"");
            String href = topic.getHref();
            href = href != null ? String.valueOf(backPath) + (isNarrow ? "/ntopic" : "/topic") + href : (isNarrow ? "javascript:liveAction('org.eclipse.help.ui', 'org.eclipse.help.ui.internal.ShowInTocAction', '" + pathBuf.toString() + "')" : String.valueOf(backPath) + "/nav/" + pathBuf.toString());
            buf.append(href);
            buf.append("\">");
            buf.append(UrlUtil.htmlEncode(topic.getLabel()));
            buf.append("</a>");
            if (i < path.length - 2 || path.length == 2) {
                if (isMirrored) {
                    buf.append(" \u200f> ");
                } else {
                    buf.append(" > ");
                }
            }
            topic = topic.getSubtopics()[path[i + 1]];
            pathBuf.append('_');
            pathBuf.append(path[i + 1]);
            ++i;
        }
        buf.append("</div>");
        if (isMirrored) {
            buf.append("\u202c");
        }
        return buf.toString();
    }
}

