/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.io.File;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;

public abstract class LogWriter {
    protected static Calendar now = Calendar.getInstance();
    public static final String LOCATIONID_PREFIX = "/node/geo/region/";
    protected static final String sep = File.separator;
    public boolean needsHeader = true;
    protected boolean done = false;

    public abstract void logHeader(RelativeValueProviderAdapter var1);

    public abstract void logHeader(ISimulation var1, IntegrationDecorator var2, Map<Node, Integer> var3, TimeProvider var4);

    public abstract void flushLoggerData();

    public abstract void closeLoggerData();

    public abstract void logData(RelativeValueProviderAdapter var1, TimeProvider var2);

    public abstract void logData(ISimulation var1, IntegrationDecorator var2, Map<Node, Integer> var3, TimeProvider var4, boolean var5);

    public static void reset() {
        now = Calendar.getInstance();
    }

    public static String getDateTimeNumeric() {
        int month = now.get(2) + 1;
        int day = now.get(5);
        int year = now.get(1);
        int hrs = now.get(11) + 1;
        int mins = now.get(12);
        String smonth = "" + month;
        if (month < 10) {
            smonth = "0" + smonth;
        }
        String sday = "" + day;
        if (day < 10) {
            sday = "0" + sday;
        }
        String shrs = "" + hrs;
        if (hrs < 10) {
            shrs = "0" + shrs;
        }
        String smin = "" + mins;
        if (mins < 10) {
            smin = "0" + smin;
        }
        String time = year + smonth + sday + "_" + shrs + smin;
        return time;
    }

    public static String filterFilename(String unfiltered) {
        int last = unfiltered.indexOf(LOCATIONID_PREFIX);
        if (last >= 0) {
            return unfiltered.substring(last += LOCATIONID_PREFIX.length(), unfiltered.length());
        }
        return unfiltered;
    }

    public abstract String getDirectoryName();

    public abstract String getLogDataObjectName();
}

