/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextInformationProvider;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategyProvider;
import org.eclipse.xtext.ui.editor.contentassist.IContentAssistantFactory;
import org.eclipse.xtext.ui.editor.doubleClicking.DoubleClickStrategyProvider;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.hyperlinking.SingleHoverShowingHyperlinkPresenter;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapper;
import org.eclipse.xtext.ui.editor.quickfix.XtextQuickAssistAssistant;
import org.eclipse.xtext.ui.editor.reconciler.XtextReconciler;
import org.eclipse.xtext.ui.editor.toggleComments.ISingleLineCommentHelper;

public class XtextSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    public static final String XTEXT_TEMPLATE_POS_CATEGORY = "xtext_template_position_category";
    @Inject
    private IContentAssistantFactory contentAssistantFactory;
    @Inject
    private IHyperlinkDetector detector;
    @Inject
    private Provider<IReconciler> reconcilerProvider;
    @Inject
    private Provider<IPresentationDamager> damagerProvider;
    @Inject
    private Provider<IPresentationRepairer> repairerProvider;
    @Inject(optional=true)
    private IContentFormatterFactory contentFormatterFactory;
    @Inject(optional=true)
    private ISingleLineCommentHelper singleLineCommentHelper;
    @Inject
    private Provider<XtextQuickAssistAssistant> quickAssistAssistentProvider;
    @Inject
    private Provider<XtextPresentationReconciler> presentationReconcilerProvider;
    @Inject
    private ITokenTypeToPartitionTypeMapper partitionTypesMapper;
    @Inject
    private Provider<IAnnotationHover> annotationHoverProvider;
    @Inject
    private Provider<ITextHover> textHoverProvider;
    private IEditorPart editor;
    @Inject
    private XtextInformationProvider informationProvider;
    @Inject(optional=true)
    private IQuickAssistAssistant quickAssistant;
    @Inject
    private AbstractEditStrategyProvider editStrategyProvider;
    @Inject
    private DoubleClickStrategyProvider doubleClickStrategyProvider;

    public IEditorPart getEditor() {
        return this.editor;
    }

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        IAnnotationHover hover = (IAnnotationHover)this.annotationHoverProvider.get();
        if (hover instanceof ISourceViewerAware) {
            ((ISourceViewerAware)hover).setSourceViewer(sourceViewer);
        }
        return hover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        ITextHover hover = (ITextHover)this.textHoverProvider.get();
        if (hover instanceof ISourceViewerAware) {
            ((ISourceViewerAware)hover).setSourceViewer(sourceViewer);
        }
        return hover;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        return this.contentAssistantFactory.createConfiguredAssistant((SourceViewerConfiguration)this, sourceViewer);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IReconciler reconciler = (IReconciler)this.reconcilerProvider.get();
        if (reconciler instanceof XtextReconciler && this.editor instanceof XtextEditor) {
            ((XtextReconciler)reconciler).setEditor((XtextEditor)this.editor);
        }
        return reconciler;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        String[] types;
        XtextPresentationReconciler reconciler = (XtextPresentationReconciler)((Object)this.getPresentationReconcilerProvider().get());
        reconciler.setDocumentPartitioning(this.getDocumentPartitioning(sourceViewer));
        IPresentationRepairer repairer = (IPresentationRepairer)this.repairerProvider.get();
        IPresentationDamager damager = (IPresentationDamager)this.damagerProvider.get();
        String[] stringArray = types = this.partitionTypesMapper.getSupportedPartitionTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String partitionType = stringArray[n2];
            reconciler.setRepairer(repairer, partitionType);
            reconciler.setDamager(damager, partitionType);
            ++n2;
        }
        return reconciler;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.partitionTypesMapper.getSupportedPartitionTypes();
    }

    protected String getDocumentPartitioning(ISourceViewer sourceViewer) {
        return this.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        LinkedList<IHyperlinkDetector> detectors = new LinkedList<IHyperlinkDetector>();
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (inheritedDetectors != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = inheritedDetectors;
            int n = inheritedDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                final IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                detectors.add(new IHyperlinkDetector(){

                    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                        try {
                            IHyperlink[] result = detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
                            if (result != null && result.length == 0) {
                            }
                            return result;
                        }
                        finally {
                            return null;
                        }
                    }
                });
                ++n2;
            }
        }
        detectors.add(this.detector);
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        IHyperlinkPresenter base = super.getHyperlinkPresenter(sourceViewer);
        try {
            SingleHoverShowingHyperlinkPresenter wrapper = new SingleHoverShowingHyperlinkPresenter((MultipleHyperlinkPresenter)base);
            HashSet interfaces = Sets.newHashSet();
            Class<?> c = base.getClass();
            while (c != null) {
                Collections.addAll(interfaces, c.getInterfaces());
                c = c.getSuperclass();
            }
            IHyperlinkPresenter result = (IHyperlinkPresenter)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), interfaces.toArray(new Class[0]), (InvocationHandler)wrapper);
            return result;
        }
        catch (Exception e) {
            return base;
        }
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (sourceViewer.isEditable()) {
            if (this.quickAssistant == null) {
                this.quickAssistant = (IQuickAssistAssistant)this.quickAssistAssistentProvider.get();
            }
            return this.quickAssistant;
        }
        return null;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.contentFormatterFactory != null) {
            return this.contentFormatterFactory.createConfiguredFormatter((SourceViewerConfiguration)this, sourceViewer);
        }
        return super.getContentFormatter(sourceViewer);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        if (this.singleLineCommentHelper != null) {
            return this.singleLineCommentHelper.getDefaultPrefixes(sourceViewer, contentType);
        }
        return super.getDefaultPrefixes(sourceViewer, contentType);
    }

    public void setSingleLineCommentHelper(ISingleLineCommentHelper singleLineCommentHelper) {
        this.singleLineCommentHelper = singleLineCommentHelper;
    }

    public ISingleLineCommentHelper getSingleLineCommentHelper() {
        return this.singleLineCommentHelper;
    }

    public void setPresentationReconcilerProvider(Provider<XtextPresentationReconciler> presentationReconcilerProvider) {
        this.presentationReconcilerProvider = presentationReconcilerProvider;
    }

    public Provider<XtextPresentationReconciler> getPresentationReconcilerProvider() {
        return this.presentationReconcilerProvider;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        List<IAutoEditStrategy> strategies = this.editStrategyProvider.getStrategies(sourceViewer, contentType);
        return strategies.toArray(new IAutoEditStrategy[strategies.size()]);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return this.doubleClickStrategyProvider.getStrategy(sourceViewer, contentType, this.getConfiguredDocumentPartitioning(sourceViewer));
    }

    void setPreferenceStore(IPreferenceStore preferenceStore) {
        this.fPreferenceStore = preferenceStore;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider((IInformationProvider)this.informationProvider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(100, 12, true, true);
        return presenter;
    }
}

