/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.ui.util.FileOpener;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.Messages;

public abstract class XtextNewProjectWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = Logger.getLogger(XtextNewProjectWizard.class);
    protected IStructuredSelection selection;
    @Inject
    private FileOpener fileOpener;
    private IProjectCreator creator;
    private IWorkbench workbench;

    public XtextNewProjectWizard(IProjectCreator creator) {
        this.creator = creator;
        this.setNeedsProgressMonitor(true);
    }

    protected abstract IProjectInfo getProjectInfo();

    public boolean performFinish() {
        final IProjectInfo projectInfo = this.getProjectInfo();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        XtextNewProjectWizard.this.doFinish(projectInfo, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.XtextNewProjectWizard_ErrorDialog_Title, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void doFinish(IProjectInfo projectInfo, IProgressMonitor monitor) {
        try {
            this.creator.setProjectInfo(projectInfo);
            this.creator.run(monitor);
            this.fileOpener.selectAndReveal(this.creator.getResult());
            this.fileOpener.openFileToEdit(this.getShell(), this.creator.getResult());
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected IProjectCreator getCreator() {
        return this.creator;
    }
}

