/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EPackageManager {
    private static EPackageManager INSTANCE;
    private final Map<String, EPackage> loadedPackages = new HashMap<String, EPackage>();
    private final Map<String, GenModel> loadedGenModels = new HashMap<String, GenModel>();
    private ResourceSet resourceSet = new ResourceSetImpl();
    private Map<IProject, List<IFile>> workspaceEcores;

    private EPackageManager() {
        this.resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
    }

    public static synchronized EPackageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EPackageManager();
        }
        return INSTANCE;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void loadGenModelsForResource(Resource resource, IProgressMonitor monitor) {
        URI uri;
        String scheme;
        if (resource.getURI() != null && resource.getURI().lastSegment().endsWith(".ecore") && "platform".equals(scheme = (uri = resource.getResourceSet().getURIConverter().normalize(resource.getURI())).scheme()) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            if (resourceFile != null && resourceFile.exists()) {
                this.loadContainerGenModels((IResource)resourceFile.getProject(), monitor);
            }
        }
    }

    public Map<String, EPackage> getLoadedPackages() {
        return this.loadedPackages;
    }

    public GenModel findGenModelForPackage(EPackage pkg) {
        for (GenModel gm : this.loadedGenModels.values()) {
            GenPackage gp = gm.findGenPackage(pkg);
            if (gp == null) continue;
            return gp.getGenModel();
        }
        return null;
    }

    private void load(GenModel gm) {
        this.loadedGenModels.put(gm.toString(), gm);
    }

    private void load(EPackage pkg) {
        GenModel gm = this.findGenModelForPackage(pkg);
        if (gm == null) {
            System.err.println("Warning, GM is null for " + pkg.getNsURI());
            return;
        }
        this.loadedPackages.put(pkg.getNsURI(), pkg);
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.load(subPkg);
        }
    }

    public EObject load(URI uri) throws IOException {
        Resource resource = this.resourceSet.createResource(uri);
        resource.load(null);
        if (resource.getContents().size() > 0) {
            EObject obj = (EObject)resource.getContents().get(0);
            EcoreUtil.resolveAll((EObject)obj);
            if (obj instanceof EPackage) {
                this.load((EPackage)obj);
            }
            if (obj instanceof GenModel) {
                this.load((GenModel)obj);
            }
            return obj;
        }
        return null;
    }

    private Map<IProject, List<IFile>> groupFilesByProject(List<IFile> files) {
        HashMap<IProject, List<IFile>> projectsMap = new HashMap<IProject, List<IFile>>();
        if (files != null && files.size() > 0) {
            for (IFile file : files) {
                IProject project = file.getProject();
                ArrayList<IFile> projectFiles = (ArrayList<IFile>)projectsMap.get(project);
                if (projectFiles == null) {
                    projectFiles = new ArrayList<IFile>();
                    projectsMap.put(project, projectFiles);
                }
                projectFiles.add(file);
            }
        }
        return projectsMap;
    }

    public void loadECoresFromProjects(List<IProject> projects, IProgressMonitor monitor) {
        if (this.workspaceEcores == null) {
            this.workspaceEcores = this.findECoresInWorkspace(monitor);
        }
        for (Map.Entry<IProject, List<IFile>> projectEntry : this.workspaceEcores.entrySet()) {
            this.loadContainerGenModels((IResource)projectEntry.getKey(), monitor);
            for (IFile ecore : projectEntry.getValue()) {
                if (!projects.contains(ecore.getProject())) continue;
                try {
                    URI ecoreURI = URI.createPlatformResourceURI((String)ecore.getFullPath().toString(), (boolean)true);
                    EObject eObject = this.load(ecoreURI);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void loadContainerGenModels(IResource container, IProgressMonitor monitor) {
        for (IFile genModel : this.findGenModelsInContainer(container, monitor)) {
            try {
                this.load(URI.createPlatformResourceURI((String)genModel.getFullPath().toString(), (boolean)true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Map<IProject, List<IFile>> findECoresInWorkspace(IProgressMonitor monitor) {
        return this.groupFilesByProject(this.findECoresInContainer((IResource)ResourcesPlugin.getWorkspace().getRoot(), monitor));
    }

    private List<IFile> findECoresInContainer(IResource container, IProgressMonitor monitor) {
        return this.findFilesInContainer(".ecore", container, monitor);
    }

    private List<IFile> findGenModelsInContainer(IResource container, IProgressMonitor monitor) {
        return this.findFilesInContainer(".genmodel", container, monitor);
    }

    private List<IFile> findFilesInContainer(final String extension, IResource container, final IProgressMonitor monitor) {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IResource file;
                    if (monitor.isCanceled() || proxy.getName().startsWith(".")) {
                        return false;
                    }
                    if (proxy.getName().endsWith(extension) && (file = proxy.requestResource()) instanceof IFile) {
                        files.add((IFile)file);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return files;
    }
}

