/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.sequencer.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.SequencerPackage;
import org.eclipse.stem.core.sequencer.SequentialSequencer;
import org.eclipse.stem.core.sequencer.impl.SequencerImpl;

public class SequentialSequencerImpl
extends SequencerImpl
implements SequentialSequencer {
    protected static final long TIME_INCREMENT_EDEFAULT = STEMTime.Units.DAY.getMilliseconds();
    protected long timeIncrement = TIME_INCREMENT_EDEFAULT;
    private double workIncrementRunningTotal = 0.0;
    private boolean endOfSequenceReached = false;
    private boolean getNextTimeNotCalled = true;

    protected SequentialSequencerImpl() {
        this.timeDelta = this.getTimeIncrement();
    }

    @Override
    protected EClass eStaticClass() {
        return SequencerPackage.Literals.SEQUENTIAL_SEQUENCER;
    }

    @Override
    public long getTimeIncrement() {
        return this.timeIncrement;
    }

    @Override
    public boolean isTimeToStop() {
        return this.endOfSequenceReached || this.isEndTimeBefore(this.getCurrentTime());
    }

    @Override
    public void setTimeIncrement(long newTimeIncrement) {
        long oldTimeIncrement = this.getTimeIncrement();
        this.timeIncrement = newTimeIncrement;
        this.timeDelta = this.getTimeIncrement();
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldTimeIncrement, this.getTimeIncrement()));
        }
    }

    @Override
    public STEMTime getNextTime() {
        super.getNextTime();
        STEMTime nextTime = null;
        if (this.getNextTimeNotCalled) {
            nextTime = this.getStartTime();
            this.getNextTimeNotCalled = false;
        } else {
            STEMTime potentialNextTime = this.getCurrentTime().addIncrement(this.getTimeIncrement());
            nextTime = this.isEndTimeBefore(potentialNextTime) ? (STEMTime)EcoreUtil.copy((EObject)this.getEndTime()) : potentialNextTime;
            if (nextTime.valueEquals(this.getEndTime())) {
                this.endOfSequenceReached = true;
            }
        }
        this.setCurrentTime(nextTime);
        this.setWorkComplete(Math.min(this.getWorkComplete() + (double)this.getWorkIncrement(), 100.0));
        return this.getCurrentTime();
    }

    protected boolean isEndTimeBefore(STEMTime time) {
        return this.getEndTime() != null && this.getEndTime().getTime().before(time.getTime());
    }

    @Override
    public int getWorkIncrement() {
        int retValue = 0;
        if (this.getDuration() != -1L) {
            this.workIncrementRunningTotal += 100.0 * (double)this.getTimeIncrement() / (double)(this.getDuration() + this.getTimeIncrement());
            if (this.workIncrementRunningTotal >= 1.0) {
                retValue = (int)this.workIncrementRunningTotal;
                this.workIncrementRunningTotal -= (double)retValue;
            }
        }
        return retValue;
    }

    @Override
    public void reset() {
        super.reset();
        this.workIncrementRunningTotal = 0.0;
        this.getNextTimeNotCalled = true;
        this.endOfSequenceReached = false;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                return this.getTimeIncrement();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.setTimeIncrement((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.setTimeIncrement(TIME_INCREMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return this.timeIncrement != TIME_INCREMENT_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (timeIncrement: ");
        result.append(this.timeIncrement);
        result.append(')');
        return result.toString();
    }
}

