/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.sourcelookup.advanced;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.CompositeSourceContainer;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.DefaultProjectDescriber;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.FileHashing;
import org.eclipse.jdt.launching.sourcelookup.advanced.IWorkspaceProjectDescriber;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class WorkspaceProjectSourceContainers {
    private final IElementChangedListener changeListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            try {
                HashSet<IJavaProject> remove = new HashSet<IJavaProject>();
                HashSet<IJavaProject> add = new HashSet<IJavaProject>();
                this.processDelta(event.getDelta(), remove, add);
                if (!remove.isEmpty() || !add.isEmpty()) {
                    AdvancedSourceLookupSupport.schedule(m -> WorkspaceProjectSourceContainers.this.updateProjects(remove, add, m));
                }
            }
            catch (CoreException coreException) {}
        }

        private void processDelta(IJavaElementDelta delta, Set<IJavaProject> remove, Set<IJavaProject> add) throws CoreException {
            IJavaElement element = delta.getElement();
            int kind = delta.getKind();
            switch (element.getElementType()) {
                case 1: {
                    this.processChangedChildren(delta, remove, add);
                    break;
                }
                case 2: {
                    switch (kind) {
                        case 2: {
                            remove.add((IJavaProject)element);
                            break;
                        }
                        case 1: {
                            add.add((IJavaProject)element);
                            break;
                        }
                        case 4: {
                            if ((delta.getFlags() & 0x400) != 0) {
                                remove.add((IJavaProject)element);
                                break;
                            }
                            if ((delta.getFlags() & 0x200) != 0) {
                                add.add((IJavaProject)element);
                                break;
                            }
                            if ((delta.getFlags() & 0x220000) == 0) break;
                            remove.add((IJavaProject)element);
                            add.add((IJavaProject)element);
                        }
                    }
                    this.processChangedChildren(delta, remove, add);
                    break;
                }
                case 3: {
                    if ((delta.getFlags() & 0xC0) == 0) break;
                    remove.add(element.getJavaProject());
                    add.add(element.getJavaProject());
                }
            }
        }

        private void processChangedChildren(IJavaElementDelta delta, Set<IJavaProject> remove, Set<IJavaProject> add) throws CoreException {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                this.processDelta(childDelta, remove, add);
                ++n2;
            }
        }
    };
    private final Object lock = new Object(){};
    private final Map<File, JavaProjectDescription> locations = new HashMap<File, JavaProjectDescription>();
    private final Map<Object, Collection<JavaProjectDescription>> hashes = new HashMap<Object, Collection<JavaProjectDescription>>();
    private final Map<IJavaProject, JavaProjectDescription> projects = new HashMap<IJavaProject, JavaProjectDescription>();

    public ISourceContainer createProjectContainer(File projectLocation) {
        Collection<JavaProjectDescription> desciptions;
        FileHashing.Hasher hasher = FileHashing.hasher();
        JavaProjectDescription description = this.getProjectByLocation(projectLocation);
        if (description == null && !(desciptions = this.getProjectsByHash(projectLocation, hasher)).isEmpty()) {
            description = desciptions.iterator().next();
        }
        if (description == null) {
            return null;
        }
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>();
        for (Supplier<ISourceContainer> factory : description.sourceContainerFactories) {
            containers.add(factory.get());
        }
        return CompositeSourceContainer.compose(containers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaProjectDescription getProjectByLocation(File projectLocation) {
        Object object = this.lock;
        synchronized (object) {
            return this.locations.get(projectLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<JavaProjectDescription> getProjectsByHash(File projectLocation, FileHashing.Hasher hasher) {
        Object object = this.lock;
        synchronized (object) {
            Collection<JavaProjectDescription> projects = this.hashes.get(hasher.hash(projectLocation));
            return projects != null ? new HashSet<JavaProjectDescription>(projects) : Collections.emptySet();
        }
    }

    public ISourceContainer createClasspathEntryContainer(File projectLocation, File entryLocation) {
        FileHashing.Hasher hasher = FileHashing.hasher();
        JavaProjectDescription projectByLocation = this.getProjectByLocation(projectLocation);
        IPackageFragmentRoot dependency = this.getProjectDependency(projectByLocation, entryLocation, hasher);
        if (dependency == null && projectByLocation == null) {
            for (JavaProjectDescription projectByHash : this.getProjectsByHash(projectLocation, hasher)) {
                dependency = this.getProjectDependency(projectByHash, entryLocation, hasher);
                if (dependency != null) break;
            }
        }
        if (dependency == null) {
            return null;
        }
        return new PackageFragmentRootSourceContainer(dependency);
    }

    private IPackageFragmentRoot getProjectDependency(JavaProjectDescription project, File entryLocation, FileHashing.Hasher hasher) {
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot dependency = project.dependencies.get(entryLocation);
        if (dependency == null) {
            dependency = project.dependencyHashes.get(hasher.hash(entryLocation));
        }
        return dependency;
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
        JavaCore.addElementChangedListener((IElementChangedListener)this.changeListener);
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject[] javaProjects = javaModel.getJavaProjects();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)javaProjects.length);
        FileHashing.Hasher hasher = FileHashing.newHasher();
        List<IWorkspaceProjectDescriber> describers = this.getJavaProjectDescribers();
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            this.addJavaProject(project, describers, hasher, (IProgressMonitor)progress.split(1));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.changeListener);
        Object object = this.lock;
        synchronized (object) {
            this.locations.clear();
            this.hashes.clear();
            this.projects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJavaProject(IJavaProject project, List<IWorkspaceProjectDescriber> describers, FileHashing.Hasher hasher, IProgressMonitor monitor) throws CoreException {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        JavaProjectDescriptionBuilder builder = new JavaProjectDescriptionBuilder();
        for (IWorkspaceProjectDescriber describer : describers) {
            describer.describeProject(project, builder);
        }
        Set<File> locations = builder.locations;
        List<Supplier<ISourceContainer>> factories = builder.factories;
        Map<File, IPackageFragmentRoot> dependencies = builder.dependencyLocations;
        locations.forEach(location -> {
            Object v = dependencies.remove(location);
        });
        HashSet<Object> hashes = new HashSet<Object>();
        locations.forEach(location -> {
            Object hash = hasher.hash((File)location);
            if (hash != null) {
                hashes.add(hash);
            }
        });
        HashMap<Object, IPackageFragmentRoot> dependencyHashes = new HashMap<Object, IPackageFragmentRoot>();
        dependencies.forEach((location, packageFragmentRoot) -> {
            IPackageFragmentRoot iPackageFragmentRoot = dependencyHashes.put(hasher.hash((File)location), (IPackageFragmentRoot)packageFragmentRoot);
        });
        JavaProjectDescription info = new JavaProjectDescription(locations, hashes, factories, dependencies, dependencyHashes);
        Object object = this.lock;
        synchronized (object) {
            for (File file : locations) {
                this.locations.put(file, info);
            }
            for (File file : hashes) {
                Collection<JavaProjectDescription> hashProjects = this.hashes.get(file);
                if (hashProjects == null) {
                    hashProjects = new HashSet<JavaProjectDescription>();
                    this.hashes.put(file, hashProjects);
                }
                hashProjects.add(info);
            }
            this.projects.put(project, info);
        }
        SubMonitor.done((IProgressMonitor)monitor);
    }

    protected List<IWorkspaceProjectDescriber> getJavaProjectDescribers() {
        IConfigurationElement[] elements;
        ArrayList<IWorkspaceProjectDescriber> result = new ArrayList<IWorkspaceProjectDescriber>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.jdt.launching.workspaceProjectDescribers");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("describer".equals(element.getName())) {
                try {
                    result.add((IWorkspaceProjectDescriber)element.createExecutableExtension("class"));
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        result.add(new DefaultProjectDescriber());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJavaProject(IJavaProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            JavaProjectDescription description = this.projects.remove(project);
            if (description != null) {
                for (File location : description.classesLocations) {
                    this.locations.remove(location);
                }
                for (Object hash : description.classesLocationsHashes) {
                    Collection<JavaProjectDescription> hashProjects = this.hashes.get(hash);
                    if (hashProjects == null) continue;
                    hashProjects.remove(description);
                    if (!hashProjects.isEmpty()) continue;
                    this.hashes.remove(hash);
                }
            }
        }
    }

    void updateProjects(Set<IJavaProject> remove, Set<IJavaProject> add, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + add.size()));
        progress.split(1);
        for (IJavaProject project : remove) {
            this.removeJavaProject(project);
        }
        List<IWorkspaceProjectDescriber> describers = this.getJavaProjectDescribers();
        FileHashing.Hasher hasher = FileHashing.newHasher();
        for (IJavaProject project : add) {
            this.addJavaProject(project, describers, hasher, (IProgressMonitor)progress.split(1));
        }
    }

    private static class JavaProjectDescription {
        final Set<File> classesLocations;
        final Set<Object> classesLocationsHashes;
        final List<Supplier<ISourceContainer>> sourceContainerFactories;
        final Map<File, IPackageFragmentRoot> dependencies;
        final Map<Object, IPackageFragmentRoot> dependencyHashes;

        public JavaProjectDescription(Set<File> locations, Set<Object> hashes, List<Supplier<ISourceContainer>> factories, Map<File, IPackageFragmentRoot> dependencies, Map<Object, IPackageFragmentRoot> dependencyHashes) {
            this.classesLocations = Collections.unmodifiableSet(locations);
            this.classesLocationsHashes = Collections.unmodifiableSet(hashes);
            this.sourceContainerFactories = Collections.unmodifiableList(factories);
            this.dependencies = Collections.unmodifiableMap(dependencies);
            this.dependencyHashes = Collections.unmodifiableMap(dependencyHashes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JavaProjectDescription)) {
                return false;
            }
            JavaProjectDescription other = (JavaProjectDescription)obj;
            return this.classesLocations.equals(other.classesLocations);
        }

        public int hashCode() {
            return this.classesLocations.hashCode();
        }
    }

    private static class JavaProjectDescriptionBuilder
    implements IWorkspaceProjectDescriber.IJavaProjectSourceDescription {
        final Set<File> locations = new HashSet<File>();
        final List<Supplier<ISourceContainer>> factories = new ArrayList<Supplier<ISourceContainer>>();
        final Map<File, IPackageFragmentRoot> dependencyLocations = new HashMap<File, IPackageFragmentRoot>();

        private JavaProjectDescriptionBuilder() {
        }

        @Override
        public void addLocation(File location) {
            this.locations.add(location);
        }

        @Override
        public void addSourceContainerFactory(Supplier<ISourceContainer> factory) {
            this.factories.add(factory);
        }

        @Override
        public void addDependencies(Map<File, IPackageFragmentRoot> dependencies) {
            this.dependencyLocations.putAll(dependencies);
        }
    }
}

