/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.preferences;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.ui.Activator;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static String[] UNIX_OS = new String[]{"Linux", "Unix"};

    public void initializeDefaultPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setDefault("org.eclipse.stem.ui.initialattributename", "I");
        store.setDefault("org.eclipse.stem.ui.initialattributename2", "S");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregrounddefaultcolor", "0,0,172");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorone", "0,0,255");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolortwo", "255,255,0");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorthee", "255,0,0");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorfour", "0,255,0");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorfive", "128,128,128");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorsix", "0,255,255");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorseven", "210,200,200");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcoloreight", "192,192,192");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolornine", "128,128,128");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorten", "64,64,64");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregrounddefaultstring", "DEFAULT");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringone", "S");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringtwo", "E");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringthee", "I");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringfour", "R");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringfive", "Count");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringsix", "Density");
        store.setDefault("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundstringseven", "Incidence");
        String osName = System.getProperty("os.name");
        int numThreads = this.getNumCPUs(osName);
        if (numThreads == 0) {
            numThreads = 2;
        }
        store.setDefault("simulationThreads", 2);
        store.setDefault("defaultSolver", "org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl");
    }

    private short getNumCPUs(String os) {
        boolean unix = false;
        String[] stringArray = UNIX_OS;
        int n = UNIX_OS.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (os.equalsIgnoreCase(o)) {
                unix = true;
            }
            ++n2;
        }
        if (!unix) {
            return 0;
        }
        short numCPUs = 0;
        BufferedReader fileReader = null;
        try {
            try {
                fileReader = new BufferedReader(new FileReader("/proc/cpuinfo"));
                if (fileReader != null) {
                    String buffer = null;
                    while (!PreferenceInitializer.EOF(buffer = fileReader.readLine())) {
                        if (!buffer.startsWith("processor")) continue;
                        numCPUs = (short)(numCPUs + 1);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {
                }
            }
            catch (IOException iOException) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fileReader.close();
            }
            catch (Exception exception) {}
        }
        return numCPUs;
    }

    protected static boolean EOF(String buffer) {
        return buffer == null;
    }
}

