/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.ui.embed;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.stem.model.ctdl.ContextSensitiveResourceWrapper;
import org.eclipse.stem.model.ctdl.scoping.CTDLScopeProvider;
import org.eclipse.stem.model.ctdl.scoping.MetamodelContextLinker;
import org.eclipse.stem.model.ctdl.ui.internal.CTDLActivator;
import org.eclipse.stem.model.metamodel.MetamodelPackage;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.metamodel.provider.TransitionItemProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.validation.Issue;

public class EmbeddedExpressionEditorComposite
extends Composite {
    protected EmbeddedEditorFactory factory;
    protected EmbeddedEditorFactory.Builder builder;
    protected EmbeddedEditor embeddedEditor;
    protected EmbeddedEditorModelAccess partialEditorModelAccess;
    protected ILinkingService linker;
    protected Injector injector;
    protected Transition transition;
    protected EditingDomain editingDomain;
    protected boolean edited = false;
    protected TransitionItemProvider itemProvider;
    protected final IEditedResourceProvider resourceProvider = new IEditedResourceProvider(){

        public XtextResource createResource() {
            XtextResourceSet resourceSet = new XtextResourceSet();
            XtextResource resource = (XtextResource)resourceSet.createResource(URI.createURI((String)"empty.sctd"));
            resourceSet.getResources().add((Object)resource);
            return resource;
        }
    };
    protected final XtextResource emptyResource = this.resourceProvider.createResource();

    public EmbeddedExpressionEditorComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setupEditor();
    }

    public void setTransition(Transition transition, EditingDomain editingDomain) {
        if (this.transition == transition) {
            return;
        }
        if (transition == null) {
            this.transition = null;
            this.embeddedEditor.getDocument().setInput(this.resourceProvider.createResource());
            this.embeddedEditor.getDocument().set("");
            this.embeddedEditor.getViewer().getTextWidget().setEditable(true);
        } else {
            this.transition = transition;
            this.editingDomain = editingDomain;
            this.itemProvider = (TransitionItemProvider)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt((Notifier)transition, IItemPropertySource.class);
            if (this.itemProvider != null) {
                this.itemProvider.addListener(new INotifyChangedListener(){

                    public void notifyChanged(Notification notification) {
                        StyledText txt2;
                        if (notification.getEventType() == 1 && notification.getFeature() == MetamodelPackage.Literals.TRANSITION__EXPRESSION && (txt2 = EmbeddedExpressionEditorComposite.this.embeddedEditor.getViewer().getTextWidget()) != null && !txt2.isFocusControl()) {
                            EmbeddedExpressionEditorComposite.this.embeddedEditor.getDocument().set(notification.getNewStringValue());
                        }
                    }
                });
            }
            XtextResource newResource = this.resourceProvider.createResource();
            String expr = transition.getExpression();
            if (expr == null) {
                expr = "";
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(expr.getBytes());
            try {
                newResource.load((InputStream)bais, Collections.emptyMap());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            transition.setExpressionResource((Resource)newResource);
            MetamodelContextLinker linker = (MetamodelContextLinker)((LazyLinkingResource)newResource).getLinkingService();
            linker.setTransition(transition);
            if (linker.getScopeProvider() instanceof CTDLScopeProvider) {
                ((CTDLScopeProvider)linker.getScopeProvider()).setTransition(transition);
            }
            if (newResource instanceof ContextSensitiveResourceWrapper) {
                ((ContextSensitiveResourceWrapper)newResource).setTransition(transition);
            }
            if (newResource != null && newResource instanceof LazyLinkingResource) {
                boolean cfr_ignored_0 = ((LazyLinkingResource)newResource).getLinkingService() instanceof MetamodelContextLinker;
            }
            this.embeddedEditor.getDocument();
            this.embeddedEditor.getDocument().setInput(newResource);
            this.embeddedEditor.getDocument().set(expr);
            this.embeddedEditor.getViewer().getTextWidget().setEditable(true);
            this.flagDirty(false);
        }
    }

    public void setTransition(Transition transition) {
        this.setTransition(transition, null);
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public void verifySaveChanges() {
        if (this.isDirty()) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Sure?", (String)"Do you wish to save the current transition?")) {
                this.applyChanges();
            } else {
                this.revertChanges();
            }
        }
    }

    protected void applyChanges() {
        final XtextDocument doc = this.getDocument();
        if (doc != null && this.transition != null) {
            if (this.editingDomain != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedExpressionEditorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)EmbeddedExpressionEditorComposite.this.editingDomain, (Object)EmbeddedExpressionEditorComposite.this.transition, (Object)MetamodelPackage.Literals.TRANSITION__EXPRESSION, (Object)doc.get()));
                    }
                });
            } else {
                this.transition.setExpression(doc.get());
            }
        }
        this.flagDirty(false);
    }

    protected void revertChanges() {
        XtextDocument doc = this.getDocument();
        if (doc != null && this.transition != null) {
            doc.set(this.transition.getExpression());
        }
        this.flagDirty(false);
    }

    protected XtextDocument getDocument() {
        return this.embeddedEditor.getDocument();
    }

    public boolean isDirty() {
        return false;
    }

    protected void flagDirty(boolean dirty) {
    }

    protected void setupEditor() {
        Composite editorCanvas = new Composite((Composite)this, 0);
        GridData canvasData = new GridData(1808);
        canvasData.horizontalSpan = 2;
        editorCanvas.setLayoutData((Object)canvasData);
        editorCanvas.setLayout((Layout)new GridLayout());
        CTDLActivator activator = CTDLActivator.getInstance();
        this.injector = activator.getInjector("org.eclipse.stem.model.ctdl.CTDL");
        this.factory = (EmbeddedEditorFactory)this.injector.getInstance(EmbeddedEditorFactory.class);
        this.linker = (ILinkingService)this.injector.getInstance(ILinkingService.class);
        this.builder = this.factory.newEditor(this.resourceProvider);
        this.embeddedEditor = this.builder.processIssuesBy((IValidationIssueProcessor)new EmbeddedEditorIssueProcessor()).showErrorAndWarningAnnotations().withParent(editorCanvas);
        this.partialEditorModelAccess = this.embeddedEditor.createPartialEditor(true);
        this.embeddedEditor.getDocument().addModelListener(new IXtextModelListener(){

            public void modelChanged(XtextResource resource) {
                if (EmbeddedExpressionEditorComposite.this.edited) {
                    String contents = EmbeddedExpressionEditorComposite.this.getDocument().get();
                    if (contents != null && !contents.equals(EmbeddedExpressionEditorComposite.this.transition.getExpression())) {
                        EmbeddedExpressionEditorComposite.this.applyChanges();
                    }
                    EmbeddedExpressionEditorComposite.this.edited = false;
                }
            }
        });
        this.embeddedEditor.getDocument().addXtextDocumentContentObserver(new IXtextDocumentContentObserver(){

            public void documentChanged(DocumentEvent event) {
                EmbeddedExpressionEditorComposite.this.edited = true;
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public boolean performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
                return true;
            }

            public boolean hasPendingUpdates() {
                return false;
            }
        });
    }

    private class EmbeddedEditorIssueProcessor
    implements IValidationIssueProcessor {
        private EmbeddedEditorIssueProcessor() {
        }

        public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
            for (Issue issue : issues) {
                System.err.println(issue.getMessage());
            }
        }
    }
}

