/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.builder.Activator;
import org.eclipse.stem.model.builder.BuilderUtils;
import org.eclipse.stem.model.builder.ExpressionMethodGenerator;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.codegen.STEMGenClass;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.MetamodelRegenerateValidator;
import org.eclipse.stem.model.xtext.XtextUtils;
import org.eclipse.xtext.resource.XtextResource;

public class MetamodelBuilder
extends IncrementalProjectBuilder {
    protected void runGenerator(List<XtextResource> resources, Model model, GenModel genModel) {
        GenClass genClass = GeneratorUtils.getGenClassForMetamodelModel((Model)model, (GenModel)genModel);
        if (genClass != null) {
            STEMGenClass modelWrapper = STEMGenClass.get((GenClass)genClass);
            GenClass labelGenClass = modelWrapper.getDefaultLabelGenClass();
            GenClass labelValueGenClass = modelWrapper.getDefaultLabelValueGenClass();
            ExpressionMethodGenerator generator = new ExpressionMethodGenerator(this.getProject(), genClass, labelGenClass, labelValueGenClass);
            generator.generate(resources);
        }
    }

    protected boolean hasErrors(IResource resource) {
        int severity = -1;
        try {
            severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return severity == 2;
    }

    protected void compileAndValidate(Package metamodel, IResource workspaceResource, GenModel genModel) throws CoreException {
        if (this.hasErrors(workspaceResource)) {
            return;
        }
        for (Model model : metamodel.getModels()) {
            List resources = XtextUtils.getXtextResourcesForModel((Model)model);
            for (XtextResource expressionResource : resources) {
                this.checkXtextResourceForErrorsAndWarnings(workspaceResource, expressionResource);
            }
            if (!this.hasErrors(workspaceResource)) {
                this.runGenerator(resources, model, genModel);
            }
            for (XtextResource expressionResource : resources) {
                BuilderUtils.safeUnload((Resource)expressionResource);
            }
        }
    }

    protected void clearAllProblemMarkers(IResource workspaceResource) {
        try {
            workspaceResource.getProject().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    protected void checkEmfResourceForErrorsAndWarnings(IResource workspaceResource, Resource emfResource) throws CoreException {
        for (Resource.Diagnostic error : emfResource.getErrors()) {
            BuilderUtils.createEmfResourceMarker(workspaceResource, emfResource, error, 2);
        }
        for (Resource.Diagnostic error : emfResource.getWarnings()) {
            BuilderUtils.createEmfResourceMarker(workspaceResource, emfResource, error, 1);
        }
    }

    protected void checkXtextResourceForErrorsAndWarnings(IResource workspaceResource, XtextResource xtextResource) throws CoreException {
        for (Resource.Diagnostic error : xtextResource.getErrors()) {
            BuilderUtils.createXtextResourceMarker(workspaceResource, xtextResource, error, 2);
        }
        for (Resource.Diagnostic error : xtextResource.getWarnings()) {
            BuilderUtils.createXtextResourceMarker(workspaceResource, xtextResource, error, 1);
        }
    }

    protected void checkMetamodelNeedsRegeneration(Package metamodel, IFile metamodelFile, IProgressMonitor monitor) throws CoreException, IOException {
        MetamodelRegenerateValidator regenValidator = new MetamodelRegenerateValidator(metamodel, metamodelFile);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking if model needs regeneration", (int)100);
        if (regenValidator.checkNeedRegeneration((IProgressMonitor)subMonitor.split(1))) {
            BuilderUtils.createNeedsRegenerationMarker((IResource)metamodelFile, "Model project requires regeneration", 2);
        }
    }

    protected void loadAndBuildMetamodel(IFile metamodelFile, IProgressMonitor monitor) {
        block7: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Building Metamodel " + metamodelFile.getFullPath()), (int)6);
            GenModel genModel = null;
            Package metamodel = null;
            try {
                metamodel = BuilderUtils.loadMetamodel(metamodelFile);
                subMonitor.worked(1);
                this.checkMetamodelNeedsRegeneration(metamodel, metamodelFile, (IProgressMonitor)subMonitor.split(1));
                this.checkEmfResourceForErrorsAndWarnings((IResource)metamodelFile, metamodel.eResource());
                subMonitor.worked(1);
                genModel = BuilderUtils.loadGenmodelForMetamodel(metamodelFile);
                subMonitor.worked(1);
                this.compileAndValidate(metamodel, (IResource)metamodelFile, genModel);
                subMonitor.worked(1);
            }
            catch (CoreException ce) {
                this.handleError(ce);
                BuilderUtils.safeUnload((EObject)metamodel);
                BuilderUtils.safeUnload(genModel);
                subMonitor.worked(1);
                break block7;
            }
            catch (IOException ioe) {
                try {
                    this.handleError(ioe);
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BuilderUtils.safeUnload((EObject)metamodel);
                    BuilderUtils.safeUnload(genModel);
                    subMonitor.worked(1);
                }
            }
            BuilderUtils.safeUnload((EObject)metamodel);
            BuilderUtils.safeUnload((EObject)genModel);
            subMonitor.worked(1);
        }
    }

    private void handleError(Throwable t) {
        Status status = new Status(4, "org.eclipse.stem.model.builder", t.getMessage(), t);
        Activator.log((IStatus)status);
    }

    private List<IFile> getMetamodelsDelta() throws CoreException {
        IResourceDelta delta = this.getDelta(this.getProject());
        final ArrayList<IFile> metamodelsInDelta = new ArrayList<IFile>();
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getResource() instanceof IFile) {
                    IFile file = (IFile)delta.getResource();
                    if (delta.getResource().getFileExtension().equals("metamodel")) {
                        metamodelsInDelta.add(file);
                    }
                }
                return true;
            }
        });
        return metamodelsInDelta;
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        block7: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Building Metamodels for " + this.getProject().getName()), (int)105);
            IResourceDelta delta = this.getDelta(this.getProject());
            List<IFile> metamodels = null;
            if (delta != null) {
                metamodels = this.getMetamodelsDelta();
            } else if (kind == 6) {
                metamodels = BuilderUtils.findMetamodelsInProject(this.getProject(), (IProgressMonitor)subMonitor.split(5));
            }
            try {
                if (monitor.isCanceled() || metamodels.size() <= 0) break block7;
                int perTick = (int)(100.0 / (double)metamodels.size());
                for (IFile metamodel : metamodels) {
                    if (!monitor.isCanceled()) {
                        this.clearAllProblemMarkers((IResource)metamodel);
                        this.loadAndBuildMetamodel(metamodel, (IProgressMonitor)subMonitor.split(perTick / 2));
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                this.handleError(t);
            }
        }
        return null;
    }
}

